/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.gui.element;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import org.lwjgl.input.Mouse;

public class GuiElementGradientList
extends Gui {
    public static final int BUTTON_HEIGHT = 20;
    public int width;
    public int height;
    public int xPosition;
    public int yPosition;
    public List<ListElement> listContents = new ArrayList<ListElement>();
    public int sliderPos = this.yPosition + 1;
    private int lastMousePosY;
    private boolean sliderGrabbed;
    private boolean sliderEnabled;
    private int selectedIndex = -1;

    public GuiElementGradientList(int xPos, int yPos, int width, int height) {
        this.xPosition = xPos;
        this.yPosition = yPos;
        this.width = width;
        this.height = height;
    }

    public void updateListContents(List<ListElement> newContents) {
        this.listContents = newContents;
        boolean bl = this.sliderEnabled = this.listContents.size() * 20 > this.height;
        if (this.selectedIndex >= this.listContents.size()) {
            this.selectedIndex = -1;
        }
    }

    public void draw(int mousePosX, int mousePosY) {
        if (this.sliderEnabled) {
            if (this.sliderGrabbed || mousePosX >= this.xPosition + this.width - 9 && mousePosX < this.xPosition + this.width && mousePosY >= this.yPosition && mousePosY < this.yPosition + this.height) {
                if (Mouse.isButtonDown((int)0)) {
                    this.sliderGrabbed = true;
                    if (this.lastMousePosY > 0) {
                        if (mousePosY >= this.sliderPos && mousePosY < this.sliderPos + 15) {
                            int deltaY = this.lastMousePosY - this.sliderPos;
                            this.sliderPos = mousePosY - deltaY;
                        } else {
                            this.sliderPos = mousePosY - 7;
                        }
                    }
                    this.lastMousePosY = mousePosY;
                } else {
                    this.sliderGrabbed = false;
                }
            } else {
                this.lastMousePosY = 0;
            }
        }
        if (Mouse.isButtonDown((int)0) && mousePosX >= this.xPosition && mousePosX < this.xPosition + this.width - 10 && mousePosY >= this.yPosition && mousePosY < this.yPosition + this.height) {
            int clickPosY = mousePosY - this.yPosition + (int)Math.floor((float)(this.listContents.size() * 20 - this.height) * this.getSliderPercentage());
            this.selectedIndex = clickPosY / 20;
            if (this.selectedIndex < 0 || this.selectedIndex >= this.listContents.size()) {
                this.selectedIndex = -1;
            }
        }
        this.sliderPos = Math.min(Math.max(this.yPosition, this.sliderPos), this.yPosition + this.height - 15);
        this.func_73733_a(this.xPosition, this.yPosition, this.xPosition + this.width - 10, this.yPosition + this.height, GCCoreUtil.to32BitColor(255, 30, 30, 30), GCCoreUtil.to32BitColor(255, 30, 30, 30));
        this.func_73733_a(this.xPosition + this.width - 9, this.yPosition, this.xPosition + this.width, this.yPosition + this.height, GCCoreUtil.to32BitColor(255, 50, 50, 50), GCCoreUtil.to32BitColor(255, 50, 50, 50));
        int sliderColor = this.sliderEnabled ? GCCoreUtil.to32BitColor(255, 90, 90, 90) : GCCoreUtil.to32BitColor(255, 40, 40, 40);
        this.func_73733_a(this.xPosition + this.width - 9, this.sliderPos, this.xPosition + this.width, this.sliderPos + 15, sliderColor, sliderColor);
        Gui.func_73734_a((int)(this.xPosition + this.width - 1), (int)this.yPosition, (int)(this.xPosition + this.width), (int)(this.yPosition + this.height), (int)GCCoreUtil.to32BitColor(255, 0, 0, 0));
        Gui.func_73734_a((int)(this.xPosition + this.width - 10), (int)this.yPosition, (int)(this.xPosition + this.width - 9), (int)(this.yPosition + this.height), (int)GCCoreUtil.to32BitColor(255, 0, 0, 0));
        Gui.func_73734_a((int)this.xPosition, (int)this.yPosition, (int)(this.xPosition + 1), (int)(this.yPosition + this.height), (int)GCCoreUtil.to32BitColor(255, 0, 0, 0));
        Gui.func_73734_a((int)this.xPosition, (int)this.yPosition, (int)(this.xPosition + this.width), (int)(this.yPosition + 1), (int)GCCoreUtil.to32BitColor(255, 0, 0, 0));
        Gui.func_73734_a((int)this.xPosition, (int)(this.yPosition + this.height - 1), (int)(this.xPosition + this.width), (int)(this.yPosition + this.height), (int)GCCoreUtil.to32BitColor(255, 0, 0, 0));
        sliderColor = this.sliderEnabled ? GCCoreUtil.to32BitColor(255, 120, 120, 120) : GCCoreUtil.to32BitColor(255, 60, 60, 60);
        Gui.func_73734_a((int)(this.xPosition + this.width - 9), (int)(this.sliderPos + 1), (int)(this.xPosition + this.width - 8), (int)(this.sliderPos + 14), (int)sliderColor);
        Gui.func_73734_a((int)(this.xPosition + this.width - 2), (int)(this.sliderPos + 1), (int)(this.xPosition + this.width - 1), (int)(this.sliderPos + 14), (int)sliderColor);
        Gui.func_73734_a((int)(this.xPosition + this.width - 9), (int)this.sliderPos, (int)(this.xPosition + this.width - 1), (int)(this.sliderPos + 1), (int)sliderColor);
        Gui.func_73734_a((int)(this.xPosition + this.width - 9), (int)(this.sliderPos + 15), (int)(this.xPosition + this.width - 1), (int)(this.sliderPos + 14), (int)sliderColor);
        int currentDrawHeight = this.yPosition + 1 - (int)Math.floor((float)(this.listContents.size() * 20 - this.height) * this.getSliderPercentage());
        FontRenderer fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
        for (int i = 0; i < this.listContents.size(); ++i) {
            ListElement displayButton = this.listContents.get(i);
            if (displayButton == null || displayButton.value == null || displayButton.value.isEmpty()) continue;
            int yCoord0 = currentDrawHeight;
            int yCoord1 = currentDrawHeight + 20 - 1;
            if (yCoord1 > this.yPosition && yCoord0 < this.yPosition + this.height) {
                yCoord0 = Math.max(this.yPosition + 1, yCoord0);
                yCoord1 = Math.min(this.yPosition + this.height - 1, yCoord1);
                int color = i == this.selectedIndex ? GCCoreUtil.to32BitColor(255, 35, 35, 35) : GCCoreUtil.to32BitColor(255, 25, 25, 25);
                Gui.func_73734_a((int)(this.xPosition + 1), (int)yCoord0, (int)(this.xPosition + this.width - 10), (int)yCoord1, (int)color);
                if (currentDrawHeight + 10 - fontRenderer.field_78288_b / 2 > this.yPosition && currentDrawHeight + 10 + fontRenderer.field_78288_b / 2 < this.yPosition + this.height) {
                    fontRenderer.func_78276_b(displayButton.value, this.xPosition + (this.width - 10) / 2 - fontRenderer.func_78256_a(displayButton.value) / 2, currentDrawHeight + 10 - fontRenderer.field_78288_b / 2, displayButton.color);
                }
            }
            currentDrawHeight += 20;
        }
    }

    public void update() {
    }

    private float getSliderPercentage() {
        if (!this.sliderEnabled) {
            return 0.0f;
        }
        return (float)(this.sliderPos - this.yPosition) / (float)(this.height - 15);
    }

    public ListElement getSelectedElement() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.listContents.get(this.selectedIndex);
    }

    public static class ListElement {
        public String value;
        public int color;

        public ListElement(String value, int color) {
            this.value = value;
            this.color = color;
        }
    }
}

