/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.entities.EntityAdvanced;
import micdoodle8.mods.galacticraft.core.entities.IBubble;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDistributor;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityBubble
extends EntityAdvanced
implements IPacketReceiver,
IBubble {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float size;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean shouldRender = true;
    public TileEntityOxygenDistributor distributor;

    public EntityBubble(World world, Vector3 mainBlockVec, TileEntityOxygenDistributor distributor) {
        this(world);
        this.field_70165_t = mainBlockVec.x + 0.5;
        this.field_70163_u = mainBlockVec.y + 1.0;
        this.field_70161_v = mainBlockVec.z + 0.5;
        this.distributor = distributor;
    }

    public EntityBubble(World world) {
        super(world);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70091_d(double par1, double par3, double par5) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.func_70107_b(par1, par3, par5);
        this.func_70101_b(par7, par8);
    }

    public void func_70030_z() {
        if (this.distributor != null) {
            Vector3 vec = new Vector3(this.distributor);
            this.field_70165_t = vec.x + 0.5;
            this.field_70163_u = vec.y + 1.0;
            this.field_70161_v = vec.z + 0.5;
        }
        super.func_70030_z();
        TileEntity tileAt = this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v));
        if (tileAt instanceof TileEntityOxygenDistributor) {
            this.distributor = (TileEntityOxygenDistributor)tileAt;
        } else if (tileAt == null) {
            if (this.distributor != null) {
                this.distributor.oxygenBubble = null;
            }
            this.distributor = null;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!(this.distributor == null || this.distributor.oxygenBubble != null && this.distributor.oxygenBubble.equals(this))) {
                this.distributor.oxygenBubble = this;
            }
            if (this.distributor == null) {
                this.func_70106_y();
            }
            if (tileAt == null) {
                this.func_70106_y();
            }
        }
        if (!this.field_70170_p.field_72995_K && this.distributor != null) {
            this.size = this.distributor.getEnergyStoredGC() > 0.0f && this.distributor.storedOxygen > this.distributor.oxygenPerTick ? (this.size += 0.01f) : (this.size -= 0.1f);
            this.size = Math.min(Math.max(this.size, 0.0f), 10.0f);
        }
        if (this.distributor != null) {
            Vector3 vec = new Vector3(this.distributor);
            this.field_70165_t = vec.x + 0.5;
            this.field_70163_u = vec.y + 1.0;
            this.field_70161_v = vec.z + 0.5;
        }
    }

    @Override
    public void handlePacketData(Side side, EntityPlayer player) {
    }

    public boolean func_70067_L() {
        return false;
    }

    public void setSize(float bubbleSize) {
        this.size = bubbleSize;
    }

    @Override
    public float getSize() {
        return this.size;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.size = nbt.func_150296_c().contains("bubbleSize") ? (float)nbt.func_74769_h("bubbleSize") : nbt.func_74760_g("bubbleSizeF");
        System.err.println("READ " + this.size);
        this.setShouldRender(nbt.func_74767_n("ShouldRender"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        System.err.println("WRITE" + this.size);
        nbt.func_74776_a("bubbleSizeF", this.size);
        nbt.func_74757_a("ShouldRender", this.shouldRender);
    }

    @Override
    public boolean shouldRender() {
        return this.shouldRender;
    }

    public void setShouldRender(boolean shouldRender) {
        this.shouldRender = shouldRender;
    }

    @Override
    public boolean isNetworkedEntity() {
        return true;
    }

    @Override
    public int getPacketCooldown(Side side) {
        return 3;
    }

    @Override
    public void onPacketClient(EntityPlayer player) {
    }

    @Override
    public void onPacketServer(EntityPlayer player) {
    }

    @Override
    public double getPacketRange() {
        return 64.0;
    }
}

