/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOrbit;
import micdoodle8.mods.galacticraft.core.entities.player.GCEntityPlayerMP;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.world.ChunkLoadingCallback;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;

public class ConnectionEvents {
    private static boolean clientConnected = false;

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ChunkLoadingCallback.onPlayerLogout(event.player);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ChunkLoadingCallback.onPlayerLogin(event.player);
        if (event.player instanceof GCEntityPlayerMP) {
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_CLIENT_ID, new Object[]{((GCEntityPlayerMP)event.player).getPlayerStats().spaceStationDimensionID}), (EntityPlayerMP)event.player);
        }
        if (event.player.field_70170_p.field_73011_w instanceof WorldProviderOrbit && event.player instanceof EntityPlayerMP) {
            ((WorldProviderOrbit)event.player.field_70170_p.field_73011_w).sendPacketsToClient((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onConnectionReceived(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        ((NetHandlerPlayServer)event.handler).func_147359_a((Packet)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_PLANETS_LIST, WorldUtil.getPlanetList()));
        ((NetHandlerPlayServer)event.handler).func_147359_a((Packet)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_LIST, WorldUtil.getSpaceStationList()));
    }

    @SubscribeEvent
    public void onConnectionOpened(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!event.isLocal) {
            clientConnected = true;
        }
    }

    @SubscribeEvent
    public void onConnectionClosed(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (clientConnected) {
            clientConnected = false;
            WorldUtil.unregisterPlanets();
            WorldUtil.unregisterSpaceStations();
        }
    }

    static {
        EnumConnectionState.field_150761_f.put(PacketSimple.class, EnumConnectionState.PLAY);
        EnumConnectionState.PLAY.field_150770_i.put((Object)2515, PacketSimple.class);
    }
}

