/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.tile.AirLockProtocol;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLock;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;

public class TileEntityAirLockController
extends TileEntityAirLock {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean redstoneActivation;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean playerDistanceActivation;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int playerDistanceSelection;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean playerNameMatches;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String playerToOpenFor = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean invertSelection;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean horizontalModeEnabled;
    public boolean lastHorizontalModeEnabled;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String ownerName = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean active;
    public boolean lastActive;
    public ArrayList<TileEntityAirLock> otherAirLocks;
    public ArrayList<TileEntityAirLock> lastOtherAirLocks;
    private AirLockProtocol protocol;
    private AirLockProtocol lastProtocol = this.protocol;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            boolean optionHandled = false;
            if (this.redstoneActivation) {
                optionHandled = true;
                this.active = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.playerDistanceActivation) {
                optionHandled = true;
                double distance = 0.0;
                switch (this.playerDistanceSelection) {
                    case 0: {
                        distance = 1.0;
                        break;
                    }
                    case 1: {
                        distance = 2.0;
                        break;
                    }
                    case 2: {
                        distance = 5.0;
                        break;
                    }
                    case 3: {
                        distance = 10.0;
                    }
                }
                Vector3 thisPos = new Vector3(this).translate(0.5);
                Vector3 minPos = new Vector3(thisPos).translate(-distance);
                Vector3 maxPos = new Vector3(thisPos).translate(distance);
                AxisAlignedBB matchingRegion = AxisAlignedBB.func_72330_a((double)minPos.x, (double)minPos.y, (double)minPos.z, (double)maxPos.x, (double)maxPos.y, (double)maxPos.z);
                List playersWithin = this.field_145850_b.func_72872_a(EntityPlayer.class, matchingRegion);
                boolean foundPlayer = false;
                for (int i = 0; i < playersWithin.size(); ++i) {
                    Object o = playersWithin.get(i);
                    if (!(o instanceof EntityPlayer)) continue;
                    if (this.playerNameMatches) {
                        if (!((EntityPlayer)o).func_146103_bH().getName().equalsIgnoreCase(this.playerToOpenFor)) continue;
                        foundPlayer = true;
                        break;
                    }
                    foundPlayer = true;
                    break;
                }
                boolean bl = this.active = !foundPlayer;
            }
            if (!optionHandled) {
                this.active = false;
            }
            if (this.invertSelection) {
                boolean bl = this.active = !this.active;
            }
            if (this.protocol == null) {
                this.protocol = this.lastProtocol = new AirLockProtocol(this);
            }
            if (this.ticks % 10L == 0L) {
                if (this.horizontalModeEnabled != this.lastHorizontalModeEnabled) {
                    this.unsealAirLock();
                } else {
                    this.otherAirLocks = this.protocol.calculate(this.horizontalModeEnabled);
                    if (this.active && (this.otherAirLocks != null || this.otherAirLocks != null && this.lastOtherAirLocks != null && this.otherAirLocks != this.lastOtherAirLocks || this.otherAirLocks != null && this.lastOtherAirLocks != null && this.otherAirLocks.size() != this.lastOtherAirLocks.size())) {
                        this.sealAirLock();
                    } else if (!this.active && this.lastActive || this.otherAirLocks == null && this.lastOtherAirLocks != null) {
                        this.unsealAirLock();
                    }
                }
                if (this.active != this.lastActive) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                this.lastActive = this.active;
                this.lastOtherAirLocks = this.otherAirLocks;
                this.lastProtocol = this.protocol;
                this.lastHorizontalModeEnabled = this.horizontalModeEnabled;
            }
        }
    }

    public void sealAirLock() {
        block11: {
            int z;
            int y;
            int x;
            block10: {
                x = this.lastProtocol.minX + (this.lastProtocol.maxX - this.lastProtocol.minX) / 2;
                y = this.lastProtocol.minY + (this.lastProtocol.maxY - this.lastProtocol.minY) / 2;
                z = this.lastProtocol.minZ + (this.lastProtocol.maxZ - this.lastProtocol.minZ) / 2;
                if (this.field_145850_b.func_147439_a(x, y, z) != GCBlocks.airLockSeal) {
                    this.field_145850_b.func_72908_a((double)x, (double)y, (double)z, GalacticraftCore.TEXTURE_PREFIX + "player.openairlock", 1.0f, 1.0f);
                }
                if (!this.horizontalModeEnabled) break block10;
                if (this.protocol.minY != this.protocol.maxY || this.protocol.minX == this.protocol.maxX || this.protocol.minZ == this.protocol.maxZ) break block11;
                for (x = this.protocol.minX + 1; x <= this.protocol.maxX - 1; ++x) {
                    for (z = this.protocol.minZ + 1; z <= this.protocol.maxZ - 1; ++z) {
                        Block blockAt = this.field_145850_b.func_147439_a(x, y, z);
                        if (!blockAt.isAir((IBlockAccess)this.field_145850_b, x, y, z)) continue;
                        this.field_145850_b.func_147465_d(x, this.protocol.minY, z, GCBlocks.airLockSeal, 0, 3);
                    }
                }
                break block11;
            }
            if (this.protocol.minX != this.protocol.maxX) {
                for (x = this.protocol.minX + 1; x <= this.protocol.maxX - 1; ++x) {
                    for (y = this.protocol.minY + 1; y <= this.protocol.maxY - 1; ++y) {
                        Block blockAt = this.field_145850_b.func_147439_a(x, y, z);
                        if (!blockAt.isAir((IBlockAccess)this.field_145850_b, x, y, z)) continue;
                        this.field_145850_b.func_147465_d(x, y, this.protocol.minZ, GCBlocks.airLockSeal, 0, 3);
                    }
                }
            } else if (this.protocol.minZ != this.protocol.maxZ) {
                for (z = this.protocol.minZ + 1; z <= this.protocol.maxZ - 1; ++z) {
                    for (y = this.protocol.minY + 1; y <= this.protocol.maxY - 1; ++y) {
                        Block block = this.field_145850_b.func_147439_a(x, y, z);
                        if (!block.isAir((IBlockAccess)this.field_145850_b, x, y, z)) continue;
                        this.field_145850_b.func_147465_d(this.protocol.minX, y, z, GCBlocks.airLockSeal, 0, 3);
                    }
                }
            }
        }
    }

    public void unsealAirLock() {
        block12: {
            int z;
            int y;
            int x;
            block11: {
                if (this.lastProtocol == null) {
                    return;
                }
                x = this.lastProtocol.minX + (this.lastProtocol.maxX - this.lastProtocol.minX) / 2;
                y = this.lastProtocol.minY + (this.lastProtocol.maxY - this.lastProtocol.minY) / 2;
                z = this.lastProtocol.minZ + (this.lastProtocol.maxZ - this.lastProtocol.minZ) / 2;
                if (this.field_145850_b.func_147439_a(x, y, z) != Blocks.field_150350_a) {
                    this.field_145850_b.func_72908_a((double)x, (double)y, (double)z, GalacticraftCore.TEXTURE_PREFIX + "player.closeairlock", 1.0f, 1.0f);
                }
                if (!this.lastHorizontalModeEnabled) break block11;
                if (this.protocol.minY != this.protocol.maxY || this.protocol.minX == this.protocol.maxX || this.protocol.minZ == this.protocol.maxZ) break block12;
                for (x = this.protocol.minX + 1; x <= this.protocol.maxX - 1; ++x) {
                    for (z = this.protocol.minZ + 1; z <= this.protocol.maxZ - 1; ++z) {
                        Block blockAt = this.field_145850_b.func_147439_a(x, y, z);
                        if (blockAt != GCBlocks.airLockSeal) continue;
                        this.field_145850_b.func_147468_f(x, this.protocol.minY, z);
                    }
                }
                break block12;
            }
            if (this.lastProtocol.minX != this.lastProtocol.maxX) {
                for (x = this.lastProtocol.minX + 1; x <= this.lastProtocol.maxX - 1; ++x) {
                    for (y = this.lastProtocol.minY + 1; y <= this.lastProtocol.maxY - 1; ++y) {
                        Block blockAt = this.field_145850_b.func_147439_a(x, y, z);
                        if (blockAt != GCBlocks.airLockSeal) continue;
                        this.field_145850_b.func_147468_f(x, y, this.lastProtocol.minZ);
                    }
                }
            } else if (this.lastProtocol.minZ != this.lastProtocol.maxZ) {
                for (z = this.lastProtocol.minZ + 1; z <= this.lastProtocol.maxZ - 1; ++z) {
                    for (y = this.lastProtocol.minY + 1; y <= this.lastProtocol.maxY - 1; ++y) {
                        Block blockAt = this.field_145850_b.func_147439_a(x, y, z);
                        if (blockAt != GCBlocks.airLockSeal) continue;
                        this.field_145850_b.func_147468_f(this.lastProtocol.minX, y, z);
                    }
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.ownerName = nbt.func_74779_i("OwnerName");
        this.redstoneActivation = nbt.func_74767_n("RedstoneActivation");
        this.playerDistanceActivation = nbt.func_74767_n("PlayerDistanceActivation");
        this.playerDistanceSelection = nbt.func_74762_e("PlayerDistanceSelection");
        this.playerNameMatches = nbt.func_74767_n("PlayerNameMatches");
        this.playerToOpenFor = nbt.func_74779_i("PlayerToOpenFor");
        this.invertSelection = nbt.func_74767_n("InvertSelection");
        this.active = nbt.func_74767_n("active");
        this.lastActive = nbt.func_74767_n("lastActive");
        this.horizontalModeEnabled = nbt.func_74767_n("HorizontalModeEnabled");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("OwnerName", this.ownerName);
        nbt.func_74757_a("RedstoneActivation", this.redstoneActivation);
        nbt.func_74757_a("PlayerDistanceActivation", this.playerDistanceActivation);
        nbt.func_74768_a("PlayerDistanceSelection", this.playerDistanceSelection);
        nbt.func_74757_a("PlayerNameMatches", this.playerNameMatches);
        nbt.func_74778_a("PlayerToOpenFor", this.playerToOpenFor);
        nbt.func_74757_a("InvertSelection", this.invertSelection);
        nbt.func_74757_a("active", this.active);
        nbt.func_74757_a("lastActive", this.lastActive);
        nbt.func_74757_a("HorizontalModeEnabled", this.horizontalModeEnabled);
    }

    @Override
    public double getPacketRange() {
        return 20.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }
}

