/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.ISpecialElectricItem;
import java.lang.reflect.Constructor;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.NetworkConfigHandler;
import micdoodle8.mods.galacticraft.api.transmission.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.transmission.item.IItemElectric;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.core.tile.EnergyStorageTile;
import micdoodle8.mods.galacticraft.core.tile.ReceiverMode;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityUniversalElectrical
extends EnergyStorageTile {
    protected boolean isAddedToEnergyNet;
    protected Object powerHandlerBC;
    private float IC2surplus = 0.0f;

    @Override
    public double getPacketRange() {
        return 12.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }

    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.allOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
    }

    public void discharge(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            float energyToDischarge = this.getRequest(ForgeDirection.UNKNOWN);
            if (item instanceof IItemElectric) {
                this.storage.receiveEnergyGC(ElectricItemHelper.dischargeItem(itemStack, energyToDischarge), false);
            } else if (NetworkConfigHandler.isIndustrialCraft2Loaded()) {
                ISpecialElectricItem electricItem;
                if (item instanceof IElectricItem) {
                    IElectricItem electricItem2 = (IElectricItem)item;
                    if (electricItem2.canProvideEnergy(itemStack)) {
                        float energyDischarged = (float)ElectricItem.manager.discharge(itemStack, (int)(energyToDischarge * NetworkConfigHandler.TO_IC2_RATIO), 4, false, false) * NetworkConfigHandler.IC2_RATIO;
                        this.storage.receiveEnergyGC(energyDischarged, false);
                    }
                } else if (item instanceof ISpecialElectricItem && (electricItem = (ISpecialElectricItem)item).canProvideEnergy(itemStack)) {
                    float energyDischarged = (float)electricItem.getManager(itemStack).discharge(itemStack, (int)(energyToDischarge * NetworkConfigHandler.TO_IC2_RATIO), 4, false, false) * NetworkConfigHandler.IC2_RATIO;
                    this.storage.receiveEnergyGC(energyDischarged, false);
                }
            }
        }
    }

    @Override
    public void initiate() {
        super.initiate();
        if (NetworkConfigHandler.isBuildcraftLoaded()) {
            this.initBuildCraft();
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isAddedToEnergyNet) {
                this.initIC();
            }
            if (NetworkConfigHandler.isBuildcraftLoaded()) {
                PowerHandler handler;
                double energyBC;
                if (this.powerHandlerBC == null) {
                    this.initBuildCraft();
                }
                if ((energyBC = (handler = (PowerHandler)this.powerHandlerBC).getEnergyStored()) > 0.0) {
                    float usedBC;
                    if ((energyBC -= (double)(usedBC = this.storage.receiveEnergyGC((float)energyBC * NetworkConfigHandler.BC3_RATIO, false) * NetworkConfigHandler.TO_BC_RATIO)) < 0.0) {
                        energyBC = 0.0;
                    }
                    handler.setEnergy(energyBC);
                }
            }
        }
    }

    public void func_145843_s() {
        this.unloadTileIC2();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.unloadTileIC2();
        super.onChunkUnload();
    }

    protected void initIC() {
        if (NetworkConfigHandler.isIndustrialCraft2Loaded()) {
            try {
                Class<?> tileLoadEvent = Class.forName("ic2.api.energy.event.EnergyTileLoadEvent");
                Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
                Constructor<?> constr = tileLoadEvent.getConstructor(energyTile);
                Object o = constr.newInstance(this);
                if (o != null && o instanceof Event) {
                    MinecraftForge.EVENT_BUS.post((Event)o);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isAddedToEnergyNet = true;
    }

    private void unloadTileIC2() {
        if (this.isAddedToEnergyNet && this.field_145850_b != null) {
            if (NetworkConfigHandler.isIndustrialCraft2Loaded() && !this.field_145850_b.field_72995_K) {
                try {
                    Class<?> tileLoadEvent = Class.forName("ic2.api.energy.event.EnergyTileUnloadEvent");
                    Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
                    Constructor<?> constr = tileLoadEvent.getConstructor(energyTile);
                    Object o = constr.newInstance(this);
                    if (o != null && o instanceof Event) {
                        MinecraftForge.EVENT_BUS.post((Event)o);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.isAddedToEnergyNet = false;
        }
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public double demandedEnergyUnits() {
        try {
            if (this.IC2surplus < 0.001f) {
                this.IC2surplus = 0.0f;
                return Math.ceil((this.storage.getCapacityGC() - this.storage.getEnergyStoredGC()) * NetworkConfigHandler.TO_IC2_RATIO);
            }
            float received = this.storage.receiveEnergyGC(this.IC2surplus, true);
            this.IC2surplus -= received;
            if (this.IC2surplus < 0.001f) {
                this.IC2surplus = 0.0f;
                return Math.ceil((this.storage.getCapacityGC() - this.storage.getEnergyStoredGC()) * NetworkConfigHandler.TO_IC2_RATIO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public double injectEnergyUnits(ForgeDirection direction, double amount) {
        if (direction == ForgeDirection.UNKNOWN || this.getElectricalInputDirections().contains(direction)) {
            float convertedEnergy = (float)amount * NetworkConfigHandler.IC2_RATIO;
            int tierFromIC2 = amount >= 128.0 ? 2 : 1;
            float receive = this.receiveElectricity(direction, convertedEnergy, tierFromIC2, true);
            this.IC2surplus = convertedEnergy > receive ? convertedEnergy - receive : 0.0f;
            return Math.round(amount - (double)(receive * NetworkConfigHandler.TO_IC2_RATIO));
        }
        return amount;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public double getMaxSafeInput() {
        return 2.147483647E9;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergyAcceptor", modID="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        if (emitter instanceof IElectrical || emitter instanceof IConductor) {
            return false;
        }
        try {
            Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
            if (!energyTile.isInstance(emitter)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getElectricalInputDirections().contains(direction);
    }

    public void initBuildCraft() {
        if (this.powerHandlerBC == null) {
            this.powerHandlerBC = new PowerHandler((IPowerReceptor)this, PowerHandler.Type.MACHINE);
        }
        ((PowerHandler)this.powerHandlerBC).configure(0.0, (double)(this.storage.getMaxReceive() * NetworkConfigHandler.TO_BC_RATIO), 0.0, (double)((int)Math.ceil(this.getMaxEnergyStoredGC() * NetworkConfigHandler.TO_BC_RATIO)));
        ((PowerHandler)this.powerHandlerBC).configurePowerPerdition(1, 10);
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.power.IPowerReceptor", modID="BuildCraft|Energy")
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        if (this.getElectricalInputDirections().contains(side)) {
            this.initBuildCraft();
            return ((PowerHandler)this.powerHandlerBC).getPowerReceiver();
        }
        return null;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.power.IPowerReceptor", modID="BuildCraft|Energy")
    public void doWork(PowerHandler workProvider) {
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.power.IPowerReceptor", modID="BuildCraft|Energy")
    public World getWorld() {
        return this.func_145831_w();
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.ISidedBatteryProvider", modID="BuildCraft|Energy")
    public IBatteryObject getMjBattery(String kind, ForgeDirection direction) {
        if (this.getElectricalInputDirections().contains(direction)) {
            return (IBatteryObject)this;
        }
        return null;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="BuildCraft|Energy")
    public double getEnergyRequested() {
        return this.getRequest(ForgeDirection.UNKNOWN) * NetworkConfigHandler.TO_BC_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="BuildCraft|Energy")
    public double addEnergy(double mj) {
        float convertedEnergy = (float)mj * NetworkConfigHandler.BC3_RATIO;
        float used = this.receiveElectricity(ForgeDirection.UNKNOWN, convertedEnergy, 1, true);
        return used * NetworkConfigHandler.TO_BC_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="BuildCraft|Energy")
    public double addEnergy(double mj, boolean ignoreCycleLimit) {
        float convertedEnergy = (float)mj * NetworkConfigHandler.BC3_RATIO;
        float used = this.receiveElectricity(ForgeDirection.UNKNOWN, convertedEnergy, 1, true);
        return used * NetworkConfigHandler.TO_BC_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="BuildCraft|Energy")
    public double getEnergyStored() {
        return this.getEnergyStoredGC() * NetworkConfigHandler.TO_BC_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="BuildCraft|Energy")
    public void setEnergyStored(double mj) {
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="BuildCraft|Energy")
    public double maxCapacity() {
        return this.getMaxEnergyStoredGC() * NetworkConfigHandler.TO_BC_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="BuildCraft|Energy")
    public double minimumConsumption() {
        return this.storage.getMaxReceive() * NetworkConfigHandler.TO_BC_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="BuildCraft|Energy")
    public double maxReceivedPerCycle() {
        return (this.getMaxEnergyStoredGC() - this.getEnergyStoredGC()) * NetworkConfigHandler.TO_BC_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="BuildCraft|Energy")
    public IBatteryObject reconfigure(double maxCapacity, double maxReceivedPerCycle, double minimumConsumption) {
        return (IBatteryObject)this;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="BuildCraft|Energy")
    public String kind() {
        return "buildcraft.kinesis";
    }

    @Override
    public ReceiverMode getModeFromDirection(ForgeDirection direction) {
        if (this.getElectricalInputDirections().contains(direction)) {
            return ReceiverMode.RECEIVE;
        }
        if (this.getElectricalOutputDirections().contains(direction)) {
            return ReceiverMode.EXTRACT;
        }
        return null;
    }

    public void updateFacing() {
        if (NetworkConfigHandler.isIndustrialCraft2Loaded() && !this.field_145850_b.field_72995_K) {
            this.unloadTileIC2();
        }
    }
}

