/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import com.google.common.primitives.Ints;
import cpw.mods.fml.client.config.IConfigElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;

public class ConfigManagerCore {
    public static boolean loaded;
    static Configuration configuration;
    public static int idDimensionOverworldOrbit;
    public static int idDimensionOverworldOrbitStatic;
    public static int idDimensionMoon;
    public static int idSchematicRocketT1;
    public static int idSchematicMoonBuggy;
    public static int idSchematicAddSchematic;
    public static int idAchievBase;
    public static int idEntityEvolvedSpider;
    public static int idEntityEvolvedCreeper;
    public static int idEntityEvolvedZombie;
    public static int idEntityEvolvedSkeleton;
    public static int idEntityEvolvedSkeletonBoss;
    public static int idEntitySpaceship;
    public static int idEntityAntiGravityArrow;
    public static int idEntityMeteor;
    public static int idEntityBuggy;
    public static int idEntityFlag;
    public static int idEntityAstroOrb;
    public static int idEntityParaChest;
    public static int idEntityAlienVillager;
    public static int idEntityOxygenBubble;
    public static int idEntityLander;
    public static int idEntityLanderChest;
    public static int idEntityMeteorChunk;
    public static boolean moreStars;
    public static boolean wasdMapMovement;
    public static String[] sealableIDs;
    public static String[] detectableIDs;
    public static boolean disableSpaceshipParticles;
    public static boolean disableSpaceshipGrief;
    public static boolean oxygenIndicatorLeft;
    public static boolean oxygenIndicatorBottom;
    public static double oilGenFactor;
    public static boolean disableLeafDecay;
    public static boolean spaceStationsRequirePermission;
    public static boolean disableSpaceStationCreation;
    public static boolean overrideCapes;
    public static double spaceStationEnergyScalar;
    public static boolean disableLander;
    public static double dungeonBossHealthMod;
    public static int suffocationCooldown;
    public static int suffocationDamage;
    public static int[] externalOilGen;
    public static boolean forceOverworldRespawn;
    public static boolean enableDebug;
    public static boolean enableCopperOreGen;
    public static boolean enableTinOreGen;
    public static boolean enableAluminumOreGen;
    public static boolean enableSiliconOreGen;
    public static int[] staticLoadDimensions;
    public static boolean disableCheeseMoon;
    public static boolean disableTinMoon;
    public static boolean disableCopperMoon;
    public static boolean disableMoonVillageGen;
    public static boolean enableSealerMultithreading;
    public static boolean enableSealerEdgeChecks;
    public static boolean alternateCanisterRecipe;

    public static void initialize(File file) {
        if (!loaded) {
            configuration = new Configuration(file);
        }
        configuration.load();
        ConfigManagerCore.syncConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncConfig() {
        try {
            idDimensionMoon = configuration.get("dimensions", "idDimensionMoon", -28).getInt(-28);
            idDimensionOverworldOrbit = configuration.get("dimensions", "idDimensionOverworldOrbit", -27).getInt(-27);
            idDimensionOverworldOrbitStatic = configuration.get("dimensions", "idDimensionOverworldOrbitStatic", -26, "Static Space Station ID").getInt(-26);
            staticLoadDimensions = configuration.get("dimensions", "Static Loaded Dimensions", staticLoadDimensions, "IDs to load at startup, and keep loaded until server stops. Can be added via /gckeeploaded").getIntList();
            idSchematicRocketT1 = configuration.get("schematic", "idSchematicRocketT1", 0).getInt(0);
            idSchematicMoonBuggy = configuration.get("schematic", "idSchematicMoonBuggy", 1).getInt(1);
            idSchematicAddSchematic = configuration.get("schematic", "idSchematicAddSchematic", Integer.MAX_VALUE).getInt(Integer.MAX_VALUE);
            idAchievBase = configuration.get("achievements", "idAchievBase", 1784).getInt(1784);
            idEntityEvolvedSpider = configuration.get("entities", "idEntityEvolvedSpider", 155).getInt(155);
            idEntityEvolvedCreeper = configuration.get("entities", "idEntityEvolvedCreeper", 156).getInt(156);
            idEntityEvolvedZombie = configuration.get("entities", "idEntityEvolvedZombie", 157).getInt(157);
            idEntityEvolvedSkeleton = configuration.get("entities", "idEntityEvolvedSkeleton", 158).getInt(158);
            idEntitySpaceship = configuration.get("entities", "idEntitySpaceship", 159).getInt(159);
            idEntityAntiGravityArrow = configuration.get("entities", "idEntityAntiGravityArrow", 160).getInt(160);
            idEntityMeteor = configuration.get("entities", "idEntityMeteor", 161).getInt(161);
            idEntityBuggy = configuration.get("entities", "idEntityBuggy", 162).getInt(162);
            idEntityFlag = configuration.get("entities", "idEntityFlag", 163).getInt(163);
            idEntityAstroOrb = configuration.get("entities", "idEntityAstroOrb", 164).getInt(164);
            idEntityParaChest = configuration.get("entities", "idEntityParaChest", 165).getInt(165);
            idEntityAlienVillager = configuration.get("entities", "idEntityAlienVillager", 166).getInt(166);
            idEntityOxygenBubble = configuration.get("entities", "idEntityOxygenBubble", 167).getInt(167);
            idEntityLander = configuration.get("entities", "idEntityLander", 168).getInt(168);
            idEntityLanderChest = configuration.get("entities", "idEntityLanderChest", 169).getInt(169);
            idEntityEvolvedSkeletonBoss = configuration.get("entities", "idEntityEvolvedSkeletonBoss", 170).getInt(170);
            idEntityMeteorChunk = configuration.get("entities", "idEntityMeteorChunk", 179).getInt(179);
            moreStars = configuration.get("general", "More Stars", true, "Setting this to false will revert night skies back to default minecraft star count").getBoolean(true);
            wasdMapMovement = configuration.get("general", "WASD Map Movement", true, "If you prefer to move the Galaxy map with your mouse, set to false").getBoolean(true);
            oilGenFactor = configuration.get("general", "Oil Generation Factor", 1.8, "Increasing this will increase amount of oil that will generate in each chunk.").getDouble(1.8);
            disableSpaceshipParticles = configuration.get("general", "Disable Spaceship Particles", false, "If you have FPS problems, setting this to true will help if spaceship particles are in your sights").getBoolean(false);
            disableSpaceshipGrief = configuration.get("general", "Disable Spaceship Explosion", false, "Spaceships will not explode on contact if set to true").getBoolean(false);
            oxygenIndicatorLeft = configuration.get("general", "Minimap Left", false, "If true, this will move the Oxygen Indicator to the left side. You can combine this with \"Minimap Bottom\"").getBoolean(false);
            oxygenIndicatorBottom = configuration.get("general", "Minimap Bottom", false, "If true, this will move the Oxygen Indicator to the bottom. You can combine this with \"Minimap Left\"").getBoolean(false);
            disableLeafDecay = configuration.get("general", "Disable Oxygen Collector Leaf Decay", false, "If set to true, Oxygen Collectors will not consume leaf blocks.").getBoolean(false);
            spaceStationsRequirePermission = configuration.get("general", "Space Stations Require Permission", true, "While true, space stations require you to invite other players using /ssinvite <playername>").getBoolean(true);
            disableSpaceStationCreation = configuration.get("general", "Disable Space Station creation", false, "If set to true on a server, players will be completely unable to create space stations.").getBoolean(false);
            overrideCapes = configuration.get("general", "Override Capes", true, "By default, Galacticraft will override capes with the mod's donor cape. Set to false to disable.").getBoolean(true);
            spaceStationEnergyScalar = configuration.get("general", "Space Station Solar Energy Multiplier", 2.0, "If Mekanism is installed, solar panels will work (default 2x) more effective on space stations.").getDouble(2.0);
            sealableIDs = configuration.get("general", "External Sealable IDs", new String[]{String.valueOf(Block.func_149682_b((Block)Blocks.field_150410_aZ) + ":0")}, "List IDs of non-opaque blocks from other mods (for example, special types of glass) that the Oxygen Sealer should recognize as solid seals. Format is ID:METADATA").getStringList();
            detectableIDs = configuration.get("general", "External Detectable IDs", new String[]{String.valueOf(Block.func_149682_b((Block)Blocks.field_150365_q) + ":0"), String.valueOf(Block.func_149682_b((Block)Blocks.field_150482_ag) + ":0"), String.valueOf(Block.func_149682_b((Block)Blocks.field_150352_o) + ":0"), String.valueOf(Block.func_149682_b((Block)Blocks.field_150366_p) + ":0"), String.valueOf(Block.func_149682_b((Block)Blocks.field_150369_x) + ":0"), String.valueOf(Block.func_149682_b((Block)Blocks.field_150450_ax) + ":0"), String.valueOf(Block.func_149682_b((Block)Blocks.field_150439_ay) + ":0")}, "List IDs from other mods that the Sensor Glasses should recognize as solid blocks. Format is ID:METADATA").getStringList();
            dungeonBossHealthMod = configuration.get("general", "Dungeon Boss Health Modifier", 1.0, "Change this is you wish to balance the mod (if you have more powerful weapon mods)").getDouble(1.0);
            suffocationCooldown = configuration.get("general", "Suffocation Cooldown", 100, "Lower/Raise this value to change time between suffocation damage ticks").getInt(100);
            suffocationDamage = configuration.get("general", "Suffocation Damage", 2, "Change this value to modify the damage taken per suffocation tick").getInt(2);
            externalOilGen = configuration.get("general", "Oil gen in external dimensions", new int[]{0}, "List of non-galacticraft dimension IDs to generate oil in").getIntList();
            forceOverworldRespawn = configuration.get("general", "Force Overworld Spawn", false, "By default, you will respawn on galacticraft dimensions if you die. If you set this to true, you will respawn back on earth.").getBoolean(false);
            enableDebug = configuration.get("general", "Enable Debug Messages", false, "If this is enabled, debug messages will appear in the console. This is useful for finding bugs in the mod.").getBoolean(false);
            enableSealerMultithreading = configuration.get("general", "Enable Sealer Multithreading", false, "(Experimental) If this is enabled, Oxygen Sealers seal checks will run in a separate thread - faster but there may be block deletions or other severe artifacts.").getBoolean(false);
            enableSealerMultithreading = false;
            enableSealerEdgeChecks = configuration.get("general", "Enable Sealed edge checks", true, "If this is enabled, areas sealed by Oxygen Sealers will run a seal check when the player breaks or places a block (or on block updates).  This should be enabled for a 100% accurate sealed status is accurate, but can be disabled on servers for performance reasons.").getBoolean(true);
            enableCopperOreGen = configuration.get("general", "Enable Copper Ore Gen", true, "If this is enabled, copper ore will generate on the overworld.").getBoolean(true);
            enableTinOreGen = configuration.get("general", "Enable Tin Ore Gen", true, "If this is enabled, tin ore will generate on the overworld.").getBoolean(true);
            enableAluminumOreGen = configuration.get("general", "Enable Aluminum Ore Gen", true, "If this is enabled, aluminum ore will generate on the overworld.").getBoolean(true);
            enableSiliconOreGen = configuration.get("general", "Enable Silicon Ore Gen", true, "If this is enabled, silicon ore will generate on the overworld.").getBoolean(true);
            disableCheeseMoon = configuration.get("general", "Disable Cheese Ore Gen on Moon", false).getBoolean(false);
            disableTinMoon = configuration.get("general", "Disable Tin Ore Gen on Moon", false).getBoolean(false);
            disableCopperMoon = configuration.get("general", "Disable Copper Ore Gen on Moon", false).getBoolean(false);
            disableMoonVillageGen = configuration.get("general", "Disable Moon Village Gen", false).getBoolean(false);
            alternateCanisterRecipe = configuration.get("general", "Alternate recipe for canisters", false, "Enable this if the standard canister recipe causes a conflict.").getBoolean(false);
        }
        catch (Exception e) {
            GCLog.severe("Problem loading core config (\"core.conf\")");
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
            loaded = true;
        }
    }

    public static boolean setLoaded(int newID) {
        boolean found = false;
        for (int staticLoadDimension : staticLoadDimensions) {
            if (staticLoadDimension != newID) continue;
            found = true;
            break;
        }
        if (!found) {
            int[] oldIDs = staticLoadDimensions;
            staticLoadDimensions = new int[staticLoadDimensions.length + 1];
            System.arraycopy(oldIDs, 0, staticLoadDimensions, 0, oldIDs.length);
            ConfigManagerCore.staticLoadDimensions[ConfigManagerCore.staticLoadDimensions.length - 1] = newID;
            String[] values = new String[staticLoadDimensions.length];
            Arrays.sort(staticLoadDimensions);
            for (int i = 0; i < values.length; ++i) {
                values[i] = String.valueOf(staticLoadDimensions[i]);
            }
            configuration.get("dimensions", "Static Loaded Dimensions", staticLoadDimensions, "IDs to load at startup, and keep loaded until server stops. Can be added via /gckeeploaded").set(values);
            configuration.save();
        }
        return !found;
    }

    public static boolean setUnloaded(int idToRemove) {
        int foundCount = 0;
        for (int staticLoadDimension : staticLoadDimensions) {
            if (staticLoadDimension != idToRemove) continue;
            ++foundCount;
        }
        if (foundCount > 0) {
            ArrayList idArray = new ArrayList(Ints.asList((int[])staticLoadDimensions));
            idArray.removeAll(Collections.singleton(idToRemove));
            staticLoadDimensions = new int[idArray.size()];
            for (int i = 0; i < idArray.size(); ++i) {
                ConfigManagerCore.staticLoadDimensions[i] = (Integer)idArray.get(i);
            }
            String[] values = new String[staticLoadDimensions.length];
            Arrays.sort(staticLoadDimensions);
            for (int i = 0; i < values.length; ++i) {
                values[i] = String.valueOf(staticLoadDimensions[i]);
            }
            configuration.get("dimensions", "Static Loaded Dimensions", staticLoadDimensions, "IDs to load at startup, and keep loaded until server stops. Can be added via /gckeeploaded").set(values);
            configuration.save();
        }
        return foundCount > 0;
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(configuration.getCategory("dimensions")).getChildElements());
        list.addAll(new ConfigElement(configuration.getCategory("schematic")).getChildElements());
        list.addAll(new ConfigElement(configuration.getCategory("achievements")).getChildElements());
        list.addAll(new ConfigElement(configuration.getCategory("entities")).getChildElements());
        list.addAll(new ConfigElement(configuration.getCategory("general")).getChildElements());
        return list;
    }

    static {
        staticLoadDimensions = new int[0];
    }
}

