/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.world.gen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WorldGenMinableMeta
extends WorldGenMinable {
    private final Block minableBlockId;
    private final int numberOfBlocks;
    private final int metadata;
    private boolean usingMetadata = false;
    private final Block fillerID;
    private final int fillerMetadata;

    public WorldGenMinableMeta(Block par1, int par2, int par3, boolean par4, Block id, int meta) {
        super(par1, par2);
        this.minableBlockId = par1;
        this.numberOfBlocks = par2;
        this.metadata = par3;
        this.usingMetadata = par4;
        this.fillerID = id;
        this.fillerMetadata = meta;
    }

    public boolean func_76484_a(World par1World, Random par2Random, int px, int py, int pz) {
        float f = par2Random.nextFloat() * (float)Math.PI;
        float sinf = MathHelper.func_76126_a((float)f) * (float)this.numberOfBlocks / 8.0f;
        float cosf = MathHelper.func_76134_b((float)f) * (float)this.numberOfBlocks / 8.0f;
        float x1 = (float)(px + 8) + sinf;
        float x2 = -2.0f * sinf;
        float z1 = (float)(pz + 8) + cosf;
        float z2 = -2.0f * cosf;
        float y1 = py + par2Random.nextInt(3) - 2;
        float y2 = (float)(py + par2Random.nextInt(3) - 2) - y1;
        for (int l = 0; l <= this.numberOfBlocks; ++l) {
            float progress = (float)l / (float)this.numberOfBlocks;
            float cx = x1 + x2 * progress;
            float cy = y1 + y2 * progress;
            float cz = z1 + z2 * progress;
            float size = ((MathHelper.func_76126_a((float)((float)Math.PI * progress)) + 1.0f) * par2Random.nextFloat() * (float)this.numberOfBlocks / 16.0f + 1.0f) / 2.0f;
            int xMin = MathHelper.func_76141_d((float)(cx - size));
            int yMin = MathHelper.func_76141_d((float)(cy - size));
            int zMin = MathHelper.func_76141_d((float)(cz - size));
            int xMax = MathHelper.func_76141_d((float)(cx + size));
            int yMax = MathHelper.func_76141_d((float)(cy + size));
            int zMax = MathHelper.func_76141_d((float)(cz + size));
            for (int ix = xMin; ix <= xMax; ++ix) {
                float dx = ((float)ix + 0.5f - cx) / size;
                if (!((dx *= dx) < 1.0f)) continue;
                for (int iy = yMin; iy <= yMax; ++iy) {
                    float dy = ((float)iy + 0.5f - cy) / size;
                    if (!(dx + (dy *= dy) < 1.0f)) continue;
                    for (int iz = zMin; iz <= zMax; ++iz) {
                        float dz = ((float)iz + 0.5f - cz) / size;
                        if (!(dx + dy + (dz *= dz) < 1.0f) || par1World.func_147439_a(ix, iy, iz) != this.fillerID || par1World.func_72805_g(ix, iy, iz) != this.fillerMetadata) continue;
                        if (!this.usingMetadata) {
                            par1World.func_147465_d(ix, iy, iz, this.minableBlockId, 0, 3);
                            continue;
                        }
                        par1World.func_147465_d(ix, iy, iz, this.minableBlockId, this.metadata, 3);
                    }
                }
            }
        }
        return true;
    }
}

