/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.transmission.compatibility;

import ic2.api.item.IElectricItemManager;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.NetworkConfigHandler;
import micdoodle8.mods.galacticraft.api.transmission.item.ItemElectric;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public class ElectricItemManagerIC2
implements IElectricItemManager {
    public int charge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (itemStack.func_77973_b() instanceof ItemElectric) {
            ItemElectric item = (ItemElectric)itemStack.func_77973_b();
            float energy = (float)amount * NetworkConfigHandler.IC2_RATIO;
            float rejectedElectricity = Math.max(item.getElectricityStored(itemStack) + energy - item.getMaxElectricityStored(itemStack), 0.0f);
            float energyToReceive = energy - rejectedElectricity;
            if (!ignoreTransferLimit && energyToReceive > item.transferMax) {
                rejectedElectricity += energyToReceive - item.transferMax;
                energyToReceive = item.transferMax;
            }
            if (!simulate) {
                item.setElectricity(itemStack, item.getElectricityStored(itemStack) + energyToReceive);
            }
            return (int)(energyToReceive * NetworkConfigHandler.TO_IC2_RATIO);
        }
        return 0;
    }

    public int discharge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (itemStack.func_77973_b() instanceof ItemElectric) {
            ItemElectric item = (ItemElectric)itemStack.func_77973_b();
            float energy = (float)amount * NetworkConfigHandler.IC2_RATIO;
            float energyToTransfer = Math.min(item.getElectricityStored(itemStack), energy);
            if (!ignoreTransferLimit) {
                energyToTransfer = Math.min(energyToTransfer, item.transferMax);
            }
            if (!simulate) {
                item.setElectricity(itemStack, item.getElectricityStored(itemStack) - energyToTransfer);
            }
            return (int)(energyToTransfer * NetworkConfigHandler.TO_IC2_RATIO);
        }
        return 0;
    }

    public int getCharge(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemElectric) {
            ItemElectric item = (ItemElectric)itemStack.func_77973_b();
            return (int)(item.getElectricityStored(itemStack) * NetworkConfigHandler.TO_IC2_RATIO);
        }
        return 0;
    }

    public boolean canUse(ItemStack itemStack, int amount) {
        if (itemStack.func_77973_b() instanceof ItemElectric) {
            return this.getCharge(itemStack) >= amount;
        }
        return false;
    }

    public boolean use(ItemStack itemStack, int amount, EntityLivingBase entity) {
        if (itemStack.func_77973_b() instanceof ItemElectric) {
            return this.discharge(itemStack, amount, 1, true, false) >= amount - 1;
        }
        return false;
    }

    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
    }

    public String getToolTip(ItemStack itemStack) {
        return null;
    }
}

