/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.gui.container;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.transmission.EnergyHelper;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.inventory.ContainerOxygenCompressor;
import micdoodle8.mods.galacticraft.core.items.ItemOxygenTank;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenCompressor;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiOxygenCompressor
extends GuiContainerGC {
    private static final ResourceLocation compressorTexture = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/compressor.png");
    private final TileEntityOxygenCompressor compressor;
    private GuiElementInfoRegion oxygenInfoRegion;
    private GuiElementInfoRegion electricInfoRegion;

    public GuiOxygenCompressor(InventoryPlayer par1InventoryPlayer, TileEntityOxygenCompressor par2TileEntityAirDistributor) {
        super(new ContainerOxygenCompressor(par1InventoryPlayer, par2TileEntityAirDistributor));
        this.oxygenInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 112, (this.field_146295_m - this.field_147000_g) / 2 + 24, 56, 9, new ArrayList<String>(), this.field_146294_l, this.field_146295_m, this);
        this.electricInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 112, (this.field_146295_m - this.field_147000_g) / 2 + 37, 56, 9, new ArrayList<String>(), this.field_146294_l, this.field_146295_m, this);
        this.compressor = par2TileEntityAirDistributor;
        this.field_147000_g = 180;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate("gui.batterySlot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate("gui.batterySlot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 31, (this.field_146295_m - this.field_147000_g) / 2 + 26, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, this));
        ArrayList<String> compressorSlotDesc = new ArrayList<String>();
        compressorSlotDesc.add("Compressor tank slot, place oxygen tank");
        compressorSlotDesc.add("here to fill it with breathable oxygen.");
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 132, (this.field_146295_m - this.field_147000_g) / 2 + 70, 18, 18, compressorSlotDesc, this.field_146294_l, this.field_146295_m, this));
        ArrayList<String> oxygenDesc = new ArrayList<String>();
        oxygenDesc.add(GCCoreUtil.translate("gui.oxygenStorage.desc.0"));
        oxygenDesc.add((Object)((Object)EnumColor.YELLOW) + GCCoreUtil.translate("gui.oxygenStorage.desc.1") + ": " + (int)Math.floor(this.compressor.storedOxygen) + " / " + (int)Math.floor(this.compressor.maxOxygen));
        this.oxygenInfoRegion.tooltipStrings = oxygenDesc;
        this.oxygenInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 112;
        this.oxygenInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 24;
        this.oxygenInfoRegion.parentWidth = this.field_146294_l;
        this.oxygenInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.oxygenInfoRegion);
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate("gui.energyStorage.desc.0"));
        electricityDesc.add((Object)((Object)EnumColor.YELLOW) + GCCoreUtil.translate("gui.energyStorage.desc.1") + (int)Math.floor(this.compressor.getEnergyStoredGC()) + " / " + (int)Math.floor(this.compressor.getMaxEnergyStoredGC()));
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.electricInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 112;
        this.electricInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 37;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
    }

    protected void func_146979_b(int par1, int par2) {
        this.field_146289_q.func_78276_b(this.compressor.func_145825_b(), 8, 10, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate("gui.message.in.name") + ":", 87, 26, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate("gui.message.in.name") + ":", 87, 38, 0x404040);
        String status = GCCoreUtil.translate("gui.message.status.name") + ": " + this.getStatus();
        this.field_146289_q.func_78276_b(status, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(status) / 2, 50, 0x404040);
        status = "Oxygen Use: 20/s";
        this.field_146289_q.func_78276_b(status, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(status) / 2, 60, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate("container.inventory"), 8, this.field_147000_g - 104 + 17, 0x404040);
    }

    private String getStatus() {
        if (this.compressor.func_70301_a(0) == null || !(this.compressor.func_70301_a(0).func_77973_b() instanceof ItemOxygenTank)) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.missingtank.name");
        }
        if (this.compressor.getEnergyStoredGC() == 0.0f) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.missingpower.name");
        }
        if (this.compressor.func_70301_a(0) != null && this.compressor.func_70301_a(0).func_77960_j() == 0) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.fulltank.name");
        }
        if ((double)this.compressor.storedOxygen < 1.0) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.missingoxygen.name");
        }
        return (Object)((Object)EnumColor.DARK_GREEN) + GCCoreUtil.translate("gui.status.active.name");
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(compressorTexture);
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(var5, var6 + 5, 0, 0, this.field_146999_f, 181);
        if (this.compressor != null) {
            int scale = this.compressor.getCappedScaledOxygenLevel(54);
            this.func_73729_b(var5 + 113, var6 + 25, 197, 7, Math.min(scale, 54), 7);
            scale = this.compressor.getScaledElecticalLevel(54);
            this.func_73729_b(var5 + 113, var6 + 38, 197, 0, Math.min(scale, 54), 7);
            if (this.compressor.getEnergyStoredGC() > 0.0f) {
                this.func_73729_b(var5 + 99, var6 + 37, 176, 0, 11, 10);
            }
            if (this.compressor.storedOxygen > 0.0f) {
                this.func_73729_b(var5 + 100, var6 + 24, 187, 0, 10, 10);
            }
            ArrayList<String> oxygenDesc = new ArrayList<String>();
            oxygenDesc.add(GCCoreUtil.translate("gui.oxygenStorage.desc.0"));
            oxygenDesc.add((Object)((Object)EnumColor.YELLOW) + GCCoreUtil.translate("gui.oxygenStorage.desc.1") + ": " + (int)Math.floor(this.compressor.storedOxygen) + " / " + (int)Math.floor(this.compressor.maxOxygen));
            this.oxygenInfoRegion.tooltipStrings = oxygenDesc;
            ArrayList<String> electricityDesc = new ArrayList<String>();
            electricityDesc.add(GCCoreUtil.translate("gui.energyStorage.desc.0"));
            EnergyHelper.getEnergyDisplayTooltip(this.compressor.getEnergyStoredGC(), this.compressor.getMaxEnergyStoredGC(), electricityDesc);
            this.electricInfoRegion.tooltipStrings = electricityDesc;
        }
    }
}

