/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.lang.ref.WeakReference;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRace;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRaceManager;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOrbit;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.entities.EntityParachest;
import micdoodle8.mods.galacticraft.core.entities.player.GCEntityPlayerMP;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;

public class GCPlayerHandler {
    private ConcurrentHashMap<UUID, GCPlayerStats> playerStatsMap = new ConcurrentHashMap();

    public ConcurrentHashMap<UUID, GCPlayerStats> getServerStatList() {
        return this.playerStatsMap;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof GCEntityPlayerMP) {
            this.onPlayerLogin((GCEntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player instanceof GCEntityPlayerMP) {
            this.onPlayerLogout((GCEntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player instanceof GCEntityPlayerMP) {
            this.onPlayerRespawn((GCEntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof GCEntityPlayerMP && GCPlayerStats.get((GCEntityPlayerMP)event.entity) == null) {
            GCPlayerStats.register((GCEntityPlayerMP)event.entity);
        }
    }

    private void onPlayerLogin(GCEntityPlayerMP player) {
        GCPlayerStats oldData = this.playerStatsMap.remove(player.getPersistentID());
        if (oldData != null) {
            oldData.saveNBTData(player.getEntityData());
        }
        GCPlayerStats stats = GCPlayerStats.get(player);
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_GET_CELESTIAL_BODY_LIST, new Object[0]), player);
    }

    private void onPlayerLogout(GCEntityPlayerMP player) {
    }

    private void onPlayerRespawn(GCEntityPlayerMP player) {
        GCPlayerStats oldData = this.playerStatsMap.remove(player.getPersistentID());
        GCPlayerStats stats = GCPlayerStats.get(player);
        if (oldData != null) {
            stats.copyFrom(oldData, false);
        }
        stats.player = new WeakReference<GCEntityPlayerMP>(player);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving instanceof GCEntityPlayerMP) {
            this.onPlayerUpdate((GCEntityPlayerMP)event.entityLiving);
        }
    }

    private void onPlayerUpdate(GCEntityPlayerMP player) {
        int tick = player.field_70173_aa - 1;
        if (tick == 25 && !player.openedSpaceRaceManager) {
            SpaceRace race = SpaceRaceManager.getSpaceRaceFromPlayer(player.func_146103_bH().getName());
            if (race == null || race.getTeamName().equals("Unnamed Team")) {
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_OPEN_SPACE_RACE_GUI, new Object[0]), player);
            }
            player.openedSpaceRaceManager = true;
        }
        GCPlayerStats GCPlayer = player.getPlayerStats();
        boolean isInGCDimension = player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider;
        if (GCPlayer.cryogenicChamberCooldown > 0) {
            --GCPlayer.cryogenicChamberCooldown;
        }
        if (!player.field_70122_E && GCPlayer.lastOnGround) {
            GCPlayer.touchedGround = true;
        }
        if (GCPlayer.teleportCooldown > 0) {
            --GCPlayer.teleportCooldown;
        }
        if (GCPlayer.chatCooldown > 0) {
            --GCPlayer.chatCooldown;
        }
        if (GCPlayer.openPlanetSelectionGuiCooldown > 0) {
            --GCPlayer.openPlanetSelectionGuiCooldown;
            if (GCPlayer.openPlanetSelectionGuiCooldown == 1 && !GCPlayer.hasOpenedPlanetSelectionGui) {
                player.sendPlanetList();
                GCPlayer.usingPlanetSelectionGui = true;
                GCPlayer.hasOpenedPlanetSelectionGui = true;
            }
        }
        if (GCPlayer.usingParachute) {
            if (GCPlayer.lastParachuteInSlot != null) {
                player.field_70143_R = 0.0f;
            }
            if (player.field_70122_E) {
                player.setUsingParachute(false);
            }
        }
        player.checkCurrentItem();
        if (GCPlayer.usingPlanetSelectionGui) {
            player.sendPlanetList();
        }
        if (GCPlayer.damageCounter > 0) {
            --GCPlayer.damageCounter;
        }
        if (isInGCDimension) {
            if (tick % 30 == 0) {
                player.sendAirRemainingPacket();
                player.sendThermalLevelPacket();
            }
            if (player.field_70154_o instanceof EntityLanderBase) {
                GCPlayer.inLander = true;
                GCPlayer.justLanded = false;
            } else {
                if (GCPlayer.inLander) {
                    GCPlayer.justLanded = true;
                }
                GCPlayer.inLander = false;
            }
            if (player.field_70122_E && GCPlayer.justLanded) {
                GCPlayer.justLanded = false;
                if (player.getBedLocation(player.field_70170_p.field_73011_w.field_76574_g) == null) {
                    int i = 30000000;
                    int j = Math.min(i, Math.max(-i, MathHelper.func_76128_c((double)(player.field_70165_t + 0.5))));
                    int k = Math.min(256, Math.max(0, MathHelper.func_76128_c((double)(player.field_70163_u + 1.5))));
                    int l = Math.min(i, Math.max(-i, MathHelper.func_76128_c((double)(player.field_70161_v + 0.5))));
                    ChunkCoordinates coords = new ChunkCoordinates(j, k, l);
                    player.setSpawnChunk(coords, true, player.field_70170_p.field_73011_w.field_76574_g);
                }
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_RESET_THIRD_PERSON, new Object[0]), player);
            }
            if (player.field_70170_p.field_73011_w instanceof WorldProviderOrbit) {
                player.field_70143_R = 0.0f;
            }
        }
        player.checkGear();
        if (GCPlayer.chestSpawnCooldown > 0) {
            --GCPlayer.chestSpawnCooldown;
            if (GCPlayer.chestSpawnCooldown == 180 && GCPlayer.chestSpawnVector != null) {
                EntityParachest chest = new EntityParachest(player.field_70170_p, GCPlayer.rocketStacks, GCPlayer.fuelLevel);
                chest.func_70107_b(GCPlayer.chestSpawnVector.x, GCPlayer.chestSpawnVector.y, GCPlayer.chestSpawnVector.z);
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_72838_d((Entity)chest);
                }
            }
        }
        if (GCPlayer.launchAttempts > 0 && player.field_70154_o == null) {
            GCPlayer.launchAttempts = 0;
        }
        player.checkThermalStatus();
        player.checkOxygen();
        if (isInGCDimension && (GCPlayer.oxygenSetupValid != GCPlayer.lastOxygenSetupValid || tick % 100 == 0)) {
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_OXYGEN_VALIDITY, new Object[]{GCPlayer.oxygenSetupValid}), player);
        }
        player.throwMeteors();
        player.updateSchematics();
        if (tick % 250 == 0 && GCPlayer.frequencyModuleInSlot == null && !GCPlayer.receivedSoundWarning && isInGCDimension && player.field_70122_E && tick > 0) {
            player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.YELLOW) + GCCoreUtil.translate("gui.frequencymodule.warning0") + " " + (Object)((Object)EnumColor.AQUA) + GCItems.basicItem.func_77653_i(new ItemStack(GCItems.basicItem, 1, 19)) + (Object)((Object)EnumColor.YELLOW) + " " + GCCoreUtil.translate("gui.frequencymodule.warning1")));
            GCPlayer.receivedSoundWarning = true;
        }
        GCPlayer.lastOxygenSetupValid = GCPlayer.oxygenSetupValid;
        GCPlayer.lastUnlockedSchematics = GCPlayer.unlockedSchematics;
        GCPlayer.lastOnGround = player.field_70122_E;
    }
}

