/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.event;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.api.event.oxygen.GCCoreOxygenSuffocationEvent;
import micdoodle8.mods.galacticraft.api.item.IKeyItem;
import micdoodle8.mods.galacticraft.api.item.IKeyable;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicEvent;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.entities.player.GCEntityClientPlayerMP;
import micdoodle8.mods.galacticraft.core.entities.player.GCEntityPlayerMP;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.DamageSourceGC;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.world.ChunkLoadingCallback;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class EventHandlerGC {
    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.modID.equals("GalacticraftCore")) {
            ConfigManagerCore.syncConfig();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        ChunkLoadingCallback.save((WorldServer)event.world);
    }

    @SubscribeEvent
    public void onChunkDataLoad(ChunkDataEvent.Load event) {
        ChunkLoadingCallback.load((WorldServer)event.world);
    }

    @SubscribeEvent
    public void onWorldLoad(ChunkEvent.Load event) {
        if (!event.world.field_72995_K) {
            ChunkLoadingCallback.load((WorldServer)event.world);
        }
    }

    @SubscribeEvent
    public void onEntityDamaged(LivingHurtEvent event) {
        if (event.source.field_76373_n.equals(DamageSource.field_76370_b.field_76373_n) && event.entityLiving.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            if (event.entityLiving.field_70170_p instanceof WorldServer) {
                ((WorldServer)event.entityLiving.field_70170_p).func_147487_a("smoke", event.entityLiving.field_70165_t, event.entityLiving.field_70163_u + event.entityLiving.field_70121_D.field_72337_e - event.entityLiving.field_70121_D.field_72338_b, event.entityLiving.field_70161_v, 50, 0.0, 0.05, 0.0, 0.001);
            }
            event.entityLiving.func_70066_B();
        }
    }

    @SubscribeEvent
    public void onEntityFall(LivingFallEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (player.field_70154_o instanceof EntityAutoRocket || player.field_70154_o instanceof EntityLanderBase) {
                event.distance = 0.0f;
                event.setCanceled(true);
                return;
            }
        }
        if (event.entityLiving.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            event.distance *= ((IGalacticraftWorldProvider)event.entityLiving.field_70170_p.field_73011_w).getFallDamageModifier();
        }
    }

    @SubscribeEvent
    public void onPlayerClicked(PlayerInteractEvent event) {
        ItemStack heldStack = event.entityPlayer.field_71071_by.func_70448_g();
        TileEntity tileClicked = event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z);
        Block idClicked = event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z);
        if (heldStack != null) {
            if (tileClicked != null && tileClicked instanceof IKeyable) {
                if (event.action.equals((Object)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK)) {
                    event.setCanceled(!((IKeyable)tileClicked).canBreak() && !event.entityPlayer.field_71075_bZ.field_75098_d);
                    return;
                }
                if (event.action.equals((Object)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK)) {
                    if (heldStack.func_77973_b() instanceof IKeyItem) {
                        if (((IKeyItem)heldStack.func_77973_b()).getTier(heldStack) == -1 || ((IKeyable)tileClicked).getTierOfKeyRequired() == -1 || ((IKeyItem)heldStack.func_77973_b()).getTier(heldStack) == ((IKeyable)tileClicked).getTierOfKeyRequired()) {
                            event.setCanceled(((IKeyable)tileClicked).onValidKeyActivated(event.entityPlayer, heldStack, event.face));
                        } else {
                            event.setCanceled(((IKeyable)tileClicked).onActivatedWithoutKey(event.entityPlayer, event.face));
                        }
                    } else {
                        event.setCanceled(((IKeyable)tileClicked).onActivatedWithoutKey(event.entityPlayer, event.face));
                    }
                }
            }
            if (event.entityPlayer.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && !((IGalacticraftWorldProvider)event.entityPlayer.field_70170_p.field_73011_w).isGasPresent(IAtmosphericGas.OXYGEN) && heldStack.func_77973_b() instanceof ItemFlintAndSteel && !event.entity.field_70170_p.field_72995_K && event.action.equals((Object)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && idClicked != Blocks.field_150335_W && !OxygenUtil.isAABBInBreathableAirBlock(event.entityLiving.field_70170_p, new Vector3(event.x, event.y, event.z), new Vector3(event.x + 1, event.y + 2, event.z + 1))) {
                event.setCanceled(true);
            }
        } else if (tileClicked != null && tileClicked instanceof IKeyable) {
            if (event.action.equals((Object)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK)) {
                event.setCanceled(!((IKeyable)tileClicked).canBreak() && !event.entityPlayer.field_71075_bZ.field_75098_d);
                return;
            }
            event.setCanceled(((IKeyable)tileClicked).onActivatedWithoutKey(event.entityPlayer, event.face));
        }
    }

    @SubscribeEvent
    public void entityLivingEvent(LivingEvent.LivingUpdateEvent event) {
        if (!(!(event.entityLiving.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) || event.entityLiving instanceof EntityPlayer || OxygenUtil.isAABBInBreathableAirBlock((Entity)event.entityLiving) || event.entityLiving instanceof IEntityBreathable && ((IEntityBreathable)event.entityLiving).canBreath() || event.entityLiving.field_70173_aa % 100 != 0)) {
            GCCoreOxygenSuffocationEvent.Pre suffocationEvent = new GCCoreOxygenSuffocationEvent.Pre(event.entityLiving);
            MinecraftForge.EVENT_BUS.post((Event)suffocationEvent);
            if (suffocationEvent.isCanceled()) {
                return;
            }
            event.entityLiving.func_70097_a((DamageSource)DamageSourceGC.oxygenSuffocation, 1.0f);
            GCCoreOxygenSuffocationEvent.Post suffocationEventPost = new GCCoreOxygenSuffocationEvent.Post(event.entityLiving);
            MinecraftForge.EVENT_BUS.post((Event)suffocationEventPost);
        }
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        ItemStack result = this.fillCustomBucket(event.world, event.target);
        if (result == null) {
            return;
        }
        event.result = result;
        event.setResult(Event.Result.ALLOW);
    }

    public ItemStack fillCustomBucket(World world, MovingObjectPosition pos) {
        Block blockID;
        Class<?> buildCraftClass = null;
        Block bcOilID1 = null;
        Block bcOilID2 = null;
        Item bcOilBucket = null;
        try {
            buildCraftClass = Class.forName("buildcraft.BuildCraftEnergy");
            if (buildCraftClass != null) {
                for (Field f : buildCraftClass.getFields()) {
                    if (f.getName().equals("oilMoving")) {
                        bcOilID1 = (Block)f.get(null);
                        continue;
                    }
                    if (f.getName().equals("oilStill")) {
                        bcOilID2 = (Block)f.get(null);
                        continue;
                    }
                    if (!f.getName().equals("bucketOil")) continue;
                    bcOilBucket = (Item)f.get(null);
                }
            }
        }
        catch (Throwable cnfe) {
            // empty catch block
        }
        if (((blockID = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d)) == bcOilID1 || blockID == bcOilID2 || blockID == GCBlocks.crudeOilStill) && world.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) == 0 && bcOilBucket != null) {
            world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            return new ItemStack(bcOilBucket);
        }
        return null;
    }

    @SubscribeEvent
    public void populate(PopulateChunkEvent.Post event) {
        boolean doGen = TerrainGen.populate((IChunkProvider)event.chunkProvider, (World)event.world, (Random)event.rand, (int)event.chunkX, (int)event.chunkX, (boolean)event.hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM);
        boolean doGen2 = false;
        int[] arr$ = ConfigManagerCore.externalOilGen;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer dim = arr$[i$];
            if (dim != event.world.field_73011_w.field_76574_g) continue;
            doGen2 = true;
            break;
        }
        if (!doGen || !(event.world.field_73011_w instanceof IGalacticraftWorldProvider) && !doGen2) {
            return;
        }
        int worldX = event.chunkX << 4;
        int worldZ = event.chunkZ << 4;
        EventHandlerGC.doPopulate(event.world, event.rand, worldX + event.rand.nextInt(16), worldZ + event.rand.nextInt(16));
    }

    public static void doPopulate(World world, Random rand, int x, int z) {
        boolean flag2;
        BiomeGenBase biomegenbase = world.func_72807_a(x + 16, z + 16);
        if (biomegenbase.field_76756_M == BiomeGenBase.field_76779_k.field_76756_M || biomegenbase.field_76756_M == BiomeGenBase.field_76778_j.field_76756_M) {
            return;
        }
        double randMod = Math.min(0.5, 0.2 * ConfigManagerCore.oilGenFactor);
        boolean flag1 = rand.nextDouble() <= randMod;
        boolean bl = flag2 = rand.nextDouble() <= randMod;
        if (flag1 || flag2) {
            int cy = 20 + rand.nextInt(11);
            int r = 2 + rand.nextInt(2);
            int r2 = r * r;
            for (int bx = -r; bx <= r; ++bx) {
                for (int by = -r; by <= r; ++by) {
                    for (int bz = -r; bz <= r; ++bz) {
                        int d2 = bx * bx + by * by + bz * bz;
                        if (d2 > r2) continue;
                        world.func_147465_d(bx + x, by + cy, bz + z, GCBlocks.crudeOilStill, 0, 2);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void schematicUnlocked(SchematicEvent.Unlock event) {
        GCEntityPlayerMP player = (GCEntityPlayerMP)event.player;
        if (!player.getPlayerStats().unlockedSchematics.contains(event.page)) {
            player.getPlayerStats().unlockedSchematics.add(event.page);
            Collections.sort(player.getPlayerStats().unlockedSchematics);
            if (player != null && player.field_71135_a != null) {
                Integer[] iArray = new Integer[player.getPlayerStats().unlockedSchematics.size()];
                for (int i = 0; i < iArray.length; ++i) {
                    ISchematicPage page = player.getPlayerStats().unlockedSchematics.get(i);
                    iArray[i] = page == null ? -2 : page.getPageID();
                }
                ArrayList<Object> objList = new ArrayList<Object>();
                objList.add(iArray);
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SCHEMATIC_LIST, objList), player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void schematicFlipEvent(SchematicEvent.FlipPage event) {
        ISchematicPage page = null;
        switch (event.direction) {
            case 1: {
                page = EventHandlerGC.getNextSchematic(event.index);
                break;
            }
            case -1: {
                page = EventHandlerGC.getLastSchematic(event.index);
            }
        }
        if (page != null) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_OPEN_SCHEMATIC_PAGE, new Object[]{page.getPageID()}));
            FMLClientHandler.instance().getClient().field_71439_g.openGui((Object)GalacticraftCore.instance, page.getGuiID(), FMLClientHandler.instance().getClient().field_71439_g.field_70170_p, (int)FMLClientHandler.instance().getClient().field_71439_g.field_70165_t, (int)FMLClientHandler.instance().getClient().field_71439_g.field_70163_u, (int)FMLClientHandler.instance().getClient().field_71439_g.field_70161_v);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static ISchematicPage getNextSchematic(int currentIndex) {
        HashMap<Integer, Integer> idList = new HashMap<Integer, Integer>();
        GCEntityClientPlayerMP player = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g, false);
        for (int i = 0; i < player.unlockedSchematics.size(); ++i) {
            idList.put(i, player.unlockedSchematics.get(i).getPageID());
        }
        TreeSet keys = new TreeSet(idList.keySet());
        Iterator iterator = keys.iterator();
        for (int count = 0; count < keys.size(); ++count) {
            int i = (Integer)iterator.next();
            ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)idList.get(i));
            if (page.getPageID() != currentIndex) continue;
            if (count + 1 < player.unlockedSchematics.size()) {
                return player.unlockedSchematics.get(count + 1);
            }
            return null;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static ISchematicPage getLastSchematic(int currentIndex) {
        HashMap<Integer, Integer> idList = new HashMap<Integer, Integer>();
        GCEntityClientPlayerMP player = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g, false);
        for (int i = 0; i < player.unlockedSchematics.size(); ++i) {
            idList.put(i, player.unlockedSchematics.get(i).getPageID());
        }
        TreeSet keys = new TreeSet(idList.keySet());
        Iterator iterator = keys.iterator();
        for (int count = 0; count < keys.size(); ++count) {
            int i = (Integer)iterator.next();
            ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)idList.get(i));
            if (page.getPageID() != currentIndex) continue;
            if (count - 1 >= 0) {
                return player.unlockedSchematics.get(count - 1);
            }
            return null;
        }
        return null;
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.entityLiving instanceof GCEntityPlayerMP && !event.entityLiving.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            for (int i = 0; i < ((GCEntityPlayerMP)event.entityLiving).getPlayerStats().extendedInventory.func_70302_i_(); ++i) {
                ItemStack stack = ((GCEntityPlayerMP)event.entityLiving).getPlayerStats().extendedInventory.func_70301_a(i);
                if (stack == null) continue;
                ((GCEntityPlayerMP)event.entityLiving).func_71019_a(stack, true);
                ((GCEntityPlayerMP)event.entityLiving).getPlayerStats().extendedInventory.func_70299_a(i, null);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onLeaveBedButtonClicked(SleepCancelledEvent event) {
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (player instanceof GCEntityClientPlayerMP) {
            ((GCEntityClientPlayerMP)player).wakeUpPlayer(false, true, true, true);
        }
    }

    @SubscribeEvent
    public void onZombieSummonAid(ZombieEvent.SummonAidEvent event) {
        if (event.entity instanceof EntityEvolvedZombie) {
            event.customSummonedAid = new EntityEvolvedZombie(event.world);
            if ((double)((EntityLivingBase)event.entity).func_70681_au().nextFloat() < ((EntityEvolvedZombie)event.entity).func_110148_a(((EntityEvolvedZombie)event.entity).getReinforcementsAttribute()).func_111126_e()) {
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    public static class OrientCameraEvent
    extends Event {
    }

    public static class SleepCancelledEvent
    extends Event {
    }

    private static class SoundPlayEntry {
        private final String name;
        private final float x;
        private final float y;
        private final float z;
        private final float volume;

        private SoundPlayEntry(String name, float x, float y, float z, float volume) {
            this.name = name;
            this.volume = volume;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

