/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.oxygen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.oxygen.ThreadFindSeal;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class OxygenPressureProtocol {
    public static final Map<Block, ArrayList<Integer>> nonPermeableBlocks = new HashMap<Block, ArrayList<Integer>>();

    public static void updateSealerStatus(TileEntityOxygenSealer head) {
        try {
            head.threadSeal = new ThreadFindSeal(head);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public static void onEdgeBlockUpdated(World world, BlockVec3 vec) {
        if (ConfigManagerCore.enableSealerEdgeChecks) {
            TickHandlerServer.scheduleNewEdgeCheck(world.field_73011_w.field_76574_g, vec);
        }
    }

    public static boolean canBlockPassAir(World world, Block block, BlockVec3 vec, int side) {
        ArrayList<Integer> metaList;
        if (block instanceof BlockLeavesBase) {
            return true;
        }
        if (block.func_149662_c()) {
            return block instanceof BlockGravel || block.func_149688_o() == Material.field_151580_n || block instanceof BlockSponge;
        }
        if (block instanceof BlockGlass || block instanceof BlockStainedGlass) {
            return false;
        }
        if (block instanceof IPartialSealableBlock) {
            return !((IPartialSealableBlock)block).isSealed(world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)side));
        }
        if (nonPermeableBlocks.containsKey(block) && ((metaList = nonPermeableBlocks.get(block)).contains(-1) || metaList.contains(vec.getBlockMetadata((IBlockAccess)world)))) {
            return false;
        }
        if (block instanceof BlockSlab) {
            return !(side == 0 && (vec.getBlockMetadata((IBlockAccess)world) & 8) == 8 || side == 1 && (vec.getBlockMetadata((IBlockAccess)world) & 8) == 0);
        }
        if (block instanceof BlockFarmland || block instanceof BlockEnchantmentTable || block instanceof BlockLiquid) {
            return side != 1;
        }
        if (block instanceof BlockPistonBase) {
            BlockPistonBase piston = (BlockPistonBase)block;
            int meta = vec.getBlockMetadata((IBlockAccess)world);
            if (BlockPistonBase.func_150075_c((int)meta)) {
                int facing = BlockPistonBase.func_150076_b((int)meta);
                return side != facing;
            }
            return false;
        }
        return !block.isSideSolid((IBlockAccess)world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)(side ^ 1)));
    }

    static {
        for (String s : ConfigManagerCore.sealableIDs) {
            try {
                String[] split = s.split(":");
                Block b = Block.func_149729_e((int)Integer.parseInt(split[0]));
                if (nonPermeableBlocks.containsKey(b)) {
                    ArrayList<Integer> list = nonPermeableBlocks.get(b);
                    if (split.length > 1) {
                        list.add(Integer.parseInt(split[1]));
                    } else {
                        list.add(-1);
                    }
                    nonPermeableBlocks.put(b, list);
                    continue;
                }
                ArrayList<Integer> a = new ArrayList<Integer>();
                if (split.length > 1) {
                    a.add(Integer.parseInt(split[1]));
                } else {
                    a.add(-1);
                }
                nonPermeableBlocks.put(b, a);
            }
            catch (Exception e) {
                System.err.println("Galacticraft config External Sealable IDs: error parsing '" + s + "'  Must be in the form ID#:Metadata");
            }
        }
    }
}

