/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

class AirLockProtocol {
    private ArrayList<TileEntityAirLock> adjacentAirLocks = new ArrayList();
    private final World worldObj;
    private final TileEntity head;
    private final int maxLoops;
    private int airLocksVerticalMin = 0;
    private int airLocksVerticalMax = 0;
    private int airLocksHorizontalMin = 0;
    private int airLocksHorizontalMax = 0;
    private boolean horizontal;
    public int minX = 6000000;
    public int maxX = -6000000;
    public int minY = 6000000;
    public int maxY = -6000000;
    public int minZ = 6000000;
    public int maxZ = -6000000;

    public AirLockProtocol(TileEntity head) {
        this.worldObj = head.func_145831_w();
        this.head = head;
        this.maxLoops = 40;
    }

    public void loopThrough(TileEntity tile2, int loops) {
        if (loops > 0) {
            for (int y = -1; y <= 1; ++y) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        TileEntity tile = this.worldObj.func_147438_o(tile2.field_145851_c + x, tile2.field_145848_d + y, tile2.field_145849_e + z);
                        new Vector3(this.head).translate(new Vector3(x, y, z));
                        if (x == 0 && y == 0 && z == 0 || tile == null || !(tile instanceof TileEntityAirLock) || this.adjacentAirLocks.contains(tile)) continue;
                        if (this.horizontal && tile.field_145848_d == this.head.field_145848_d) {
                            this.adjacentAirLocks.add((TileEntityAirLock)tile);
                            this.loopThrough(tile, loops - 1);
                            continue;
                        }
                        if ((this.horizontal || tile.field_145851_c != this.head.field_145851_c) && tile.field_145849_e != this.head.field_145849_e) continue;
                        this.adjacentAirLocks.add((TileEntityAirLock)tile);
                        this.loopThrough(tile, loops - 1);
                    }
                }
            }
        }
    }

    @Deprecated
    public ArrayList<TileEntityAirLock> calculate() {
        return this.calculate(false);
    }

    public ArrayList<TileEntityAirLock> calculate(boolean horizontal) {
        TileEntity tileAt;
        int y;
        if (this.worldObj.field_72995_K) {
            return null;
        }
        this.adjacentAirLocks = new ArrayList();
        this.horizontal = horizontal;
        this.loopThrough(this.head, this.maxLoops);
        for (TileEntityAirLock airLock : this.adjacentAirLocks) {
            Vector3 vecAt = new Vector3(airLock);
            if (vecAt.intX() < this.minX) {
                this.minX = vecAt.intX();
            }
            if (vecAt.intX() > this.maxX) {
                this.maxX = vecAt.intX();
            }
            if (vecAt.intY() < this.minY) {
                this.minY = vecAt.intY();
            }
            if (vecAt.intY() > this.maxY) {
                this.maxY = vecAt.intY();
            }
            if (vecAt.intZ() < this.minZ) {
                this.minZ = vecAt.intZ();
            }
            if (vecAt.intZ() <= this.maxZ) continue;
            this.maxZ = vecAt.intZ();
        }
        int count = this.maxX - this.minX + this.maxZ - this.minZ + this.maxY - this.minY;
        if (count > 16 || this.maxX - this.minX == 0 && this.maxZ - this.minZ == 0) {
            return null;
        }
        this.airLocksVerticalMin = 0;
        this.airLocksVerticalMax = 0;
        this.airLocksHorizontalMin = 0;
        this.airLocksHorizontalMax = 0;
        for (y = this.minY; y <= this.maxY; ++y) {
            tileAt = new Vector3(this.minX, y, this.minZ).getTileEntity((IBlockAccess)this.worldObj);
            if (!(tileAt instanceof TileEntityAirLock)) continue;
            ++this.airLocksVerticalMin;
        }
        for (y = this.minY; y <= this.maxY; ++y) {
            tileAt = new Vector3(this.maxX, y, this.maxZ).getTileEntity((IBlockAccess)this.worldObj);
            if (!(tileAt instanceof TileEntityAirLock)) continue;
            ++this.airLocksVerticalMax;
        }
        if (this.minX != this.maxX) {
            int x;
            for (x = this.minX; x <= this.maxX; ++x) {
                tileAt = new Vector3(x, this.maxY, this.maxZ).getTileEntity((IBlockAccess)this.worldObj);
                if (!(tileAt instanceof TileEntityAirLock)) continue;
                ++this.airLocksHorizontalMax;
            }
            for (x = this.minX; x <= this.maxX; ++x) {
                tileAt = new Vector3(x, this.minY, this.maxZ).getTileEntity((IBlockAccess)this.worldObj);
                if (!(tileAt instanceof TileEntityAirLock)) continue;
                ++this.airLocksHorizontalMin;
            }
        } else if (this.minZ != this.maxZ) {
            int z;
            for (z = this.minZ; z <= this.maxZ; ++z) {
                tileAt = new Vector3(this.maxX, this.maxY, z).getTileEntity((IBlockAccess)this.worldObj);
                if (!(tileAt instanceof TileEntityAirLock)) continue;
                ++this.airLocksHorizontalMax;
            }
            for (z = this.minZ; z <= this.maxZ; ++z) {
                tileAt = new Vector3(this.maxX, this.minY, z).getTileEntity((IBlockAccess)this.worldObj);
                if (!(tileAt instanceof TileEntityAirLock)) continue;
                ++this.airLocksHorizontalMin;
            }
        }
        if (this.airLocksHorizontalMax == 0 || this.airLocksHorizontalMin == 0 || !this.horizontal && (this.airLocksVerticalMin == 0 || this.airLocksVerticalMax == 0) || this.airLocksHorizontalMax != this.airLocksHorizontalMin || this.airLocksVerticalMax != this.airLocksVerticalMin) {
            return null;
        }
        return this.adjacentAirLocks;
    }
}

