/*
 * Decompiled with CFR 0.152.
 */
package lawnmower.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lawnmower.EntityLawnMower;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class HUDLawnMower
extends Gui {
    private static final ResourceLocation hud = new ResourceLocation("paraknight", "textures/gui/lawnmowerhud.png");
    private final Minecraft game;
    private int wave = 0;
    private int windowWidth;

    public HUDLawnMower(Minecraft var1) {
        this.game = var1;
    }

    @SubscribeEvent
    public void renderSkillHUD(RenderGameOverlayEvent event) {
        this.windowWidth = event.resolution.func_78326_a();
        if (this.game.field_71439_g.field_70154_o != null && this.game.field_71439_g.field_70154_o instanceof EntityLawnMower) {
            this.renderBG();
            this.renderHealthBar((EntityLawnMower)this.game.field_71439_g.field_70154_o);
            this.renderFuelBar((EntityLawnMower)this.game.field_71439_g.field_70154_o);
            this.renderSpeedometer((EntityLawnMower)this.game.field_71439_g.field_70154_o);
            if (this.wave > 360) {
                this.wave = 0;
            }
            this.wave += 20;
        }
    }

    private void renderBG() {
        GL11.glEnable((int)3042);
        this.game.field_71446_o.func_110577_a(hud);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        this.func_73729_b((this.windowWidth - 155) / 2, 0, 0, 0, 155, 44);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderFuelBar(EntityLawnMower var1) {
        this.game.field_71446_o.func_110577_a(hud);
        this.func_73729_b((this.windowWidth - 102) / 2 + 19, 15, 0, 44, 102, 8);
        if (var1.getFuelTime() <= 15) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(Math.sin(Math.toRadians(this.wave)) / 2.0 + 0.5)));
        }
        this.func_73729_b((this.windowWidth - 102) / 2 + 19 + 1, 16, 0, 58, var1.getFuelTime(), 6);
        this.game.field_71466_p.func_78261_a("Fuel:", this.windowWidth / 2 - 68, 15, 0xFFFFFF);
    }

    private void renderHealthBar(EntityLawnMower var1) {
        this.func_73729_b((this.windowWidth - 102) / 2 + 19, 5, 0, 44, 102, 8);
        if ((80.0f - var1.getDamageTaken()) * 2.0f <= 15.0f) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(Math.sin(Math.toRadians(this.wave)) / 2.0 + 0.5)));
        }
        this.func_73729_b((this.windowWidth - 102) / 2 + 19 + 1, 6, 0, 52, (int)(80.0f - var1.getDamageTaken()) * 2, 6);
        this.game.field_71466_p.func_78261_a("Health:", this.windowWidth / 2 - 68, 5, 0xFFFFFF);
    }

    private void renderSpeedometer(EntityLawnMower var1) {
        this.game.field_71466_p.func_78261_a("Speed: " + (float)Math.round((float)(var1.speed * 10.0)) / 10.0f + " bps", this.windowWidth / 2 - 68 + 6, 29, 0xFFFFFF);
        GL11.glDisable((int)3042);
    }
}

