/*
 * Decompiled with CFR 0.152.
 */
package steambikes;

import core.EntityChestBoat;
import core.ModPack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public abstract class EntitySteamBike
extends EntityChestBoat {
    public float wheelAngle = 0.0f;
    public float turnAngle = 0.0f;

    public EntitySteamBike(World world) {
        super(world);
        this.func_70105_a(2.5f, 1.0f);
        this.field_70138_W = 1.0f;
        this.speedMultiplier = 1.0 / this.getFrictionFactor();
        this.maxSpeed = 2.0 / this.getFrictionFactor();
        this.minSpeed = 0.5 / this.getFrictionFactor();
    }

    public EntitySteamBike(World world, double d, double e, double f) {
        this(world);
        this.func_70107_b(d, e + (double)this.field_70129_M, f);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = e;
        this.field_70166_s = f;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract String getEntityTexture();

    public abstract double getFrictionFactor();

    public String func_145825_b() {
        return "Steam Bike";
    }

    @Override
    public abstract int getItemDamage();

    @Override
    public double func_70042_X() {
        return this.field_70131_O + 0.5f;
    }

    @Override
    public void handleSoundEffects() {
        if (this.field_70153_n != null && this.getFuelTime() > 0) {
            this.field_70170_p.func_72956_a((Entity)this, "paraknight:purr", 0.1f + (float)(this.speed / 14.0), (float)(this.speed / 6.0));
            if (this.getFuelTime() < 10 && this.field_70146_Z.nextInt(75) == 0) {
                this.field_70170_p.func_72956_a((Entity)this, "paraknight:steam", 0.1f, this.field_70146_Z.nextFloat());
            }
        }
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (Keyboard.isKeyDown((int)29)) {
            player.openGui((Object)ModPack.instance, 160, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            return true;
        }
        ItemStack heldItem = player.func_71045_bC();
        if (heldItem != null) {
            if (heldItem.func_77973_b() == Items.field_151044_h) {
                if (this.addFuel()) {
                    if (--heldItem.field_77994_a <= 0) {
                        player.func_71028_bD();
                    }
                    return true;
                }
                return false;
            }
            if (heldItem.func_77973_b() == ModPack.wrench) {
                if (this.getDamageTaken() >= 10.0f) {
                    this.setDamageTaken(this.getDamageTaken() - 10.0f);
                    heldItem.func_77972_a(1, (EntityLivingBase)player);
                    if (heldItem.func_77960_j() <= 0) {
                        player.func_71028_bD();
                    }
                    this.field_70170_p.func_72956_a((Entity)this, "note.hat", 1.0f, 1.0f);
                    return true;
                }
                return false;
            }
        }
        if (this.field_70153_n == null || !(this.field_70153_n instanceof EntityPlayer) || this.field_70153_n == player) {
            if (this.field_70153_n == null) {
                this.field_70170_p.func_72956_a((Entity)this, "paraknight:ignition", 1.0f, 1.0f);
            }
            if (!this.field_70170_p.field_72995_K) {
                player.func_70078_a((Entity)this);
            }
            return true;
        }
        return false;
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O + this.func_70033_W() + 0.2, this.field_70161_v);
        }
    }

    @Override
    public void updateSpeedModel() {
        this.speed = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) * 25.0;
        if (this.speed < 0.01 && this.speed > -0.01) {
            this.speed = 0.0;
        }
        this.wheelAngle += (float)this.speed / 16.0f;
        this.wheelAngle = this.wheelAngle >= 360.0f ? this.wheelAngle - 360.0f : this.wheelAngle;
        this.wheelAngle = this.wheelAngle < 0.0f ? this.wheelAngle + 360.0f : this.wheelAngle;
    }

    protected void func_70069_a(float fallDist) {
        super.func_70069_a(fallDist / 2.0f);
        int damage = (int)Math.ceil(fallDist - 3.0f);
        if (damage > 0) {
            this.func_70097_a(DamageSource.field_76379_h, damage / 2);
        }
    }
}

