/*
 * Decompiled with CFR 0.152.
 */
package assets.battlefield.client.core;

import assets.battlefield.client.keys.KeyHandlerMod;
import assets.battlefield.common.Battlefield;
import assets.battlefield.common.items.EnumGunType;
import assets.battlefield.common.items.ItemGun;
import assets.battlefield.common.items.ItemMagazine;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class ClientTickHandler {
    public boolean isZoomed = false;
    private ResourceLocation m22Crosshair = new ResourceLocation("battlefield:textures/gui/crosshair_m22.png");
    private ResourceLocation ironCrosshair = new ResourceLocation("battlefield:textures/gui/crosshair_iron.png");
    private ResourceLocation ammo = new ResourceLocation("battlefield:textures/gui/ammo.png");
    private int lastPerspective = -1;
    public int flashTimeout = 0;
    public int scopeTime = -1;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent event) {
        GL11.glPushMatrix();
        ScaledResolution res = event.resolution;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_70694_bm();
        ItemGun item = stack != null && stack.func_77973_b() instanceof ItemGun ? (ItemGun)stack.func_77973_b() : null;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        if (item != null) {
            if (this.isZoomed) {
                boolean isIronsight = item.hasAttachment(stack, Battlefield.content().ironSights.getName());
                ResourceLocation texture = isIronsight ? this.ironCrosshair : this.m22Crosshair;
                GL11.glDisable((int)2929);
                GL11.glDepthMask((boolean)false);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78374_a(0.0, (double)res.func_78328_b(), -90.0, 0.0, 1.0);
                tessellator.func_78374_a((double)res.func_78326_a(), (double)res.func_78328_b(), -90.0, 1.0, 1.0);
                tessellator.func_78374_a((double)res.func_78326_a(), 0.0, -90.0, 1.0, 0.0);
                tessellator.func_78374_a(0.0, 0.0, -90.0, 0.0, 0.0);
                tessellator.func_78381_a();
                GL11.glDepthMask((boolean)true);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2929);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            NBTTagCompound nbt = stack.field_77990_d;
            ItemMagazine mag = (ItemMagazine)item.getMagazineItem();
            String text = (nbt != null ? nbt.func_74762_e("remainingAmmo") : 0) + "/" + String.valueOf(mag != null ? mag.func_77612_l() : 0);
            fr.func_78261_a(text, res.func_78326_a() - fr.func_78256_a(text) - 10, res.func_78328_b() - 20, 0xFFFFFF);
            String reloadText = null;
            if (item.hasAmmo(stack)) {
                if (nbt.func_74762_e("remainingAmmo") < (item.getGunType() == EnumGunType.PISTOL ? 3 : 10) && nbt.func_74762_e("remainingAmmo") > 0 && item.getGunType() != EnumGunType.MISC) {
                    reloadText = I18n.func_135052_a((String)"gui.overlay.low", (Object[])new Object[0]);
                }
            } else {
                reloadText = I18n.func_135052_a((String)"gui.overlay.reload", (Object[])new Object[]{GameSettings.func_74298_c((int)KeyHandlerMod.reload.func_151463_i())});
            }
            if (reloadText != null && !player.field_71075_bZ.field_75098_d) {
                this.drawCenteredString(fr, reloadText, res.func_78326_a() / 2, res.func_78328_b() / 2 + fr.field_78288_b, 0xFFFFFF);
            }
        }
        GL11.glPopMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void fovUpdate(FOVUpdateEvent event) {
        float fov = event.fov;
        ItemStack stack = event.entity.func_70694_bm();
        if (stack != null && stack.func_77973_b() instanceof ItemGun && ((ItemGun)stack.func_77973_b()).canUseScope(stack) && this.isZoomed) {
            ++this.scopeTime;
            if (this.lastPerspective == -1) {
                this.lastPerspective = Minecraft.func_71410_x().field_71474_y.field_74320_O;
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
            }
            float multiplier = 4.0f;
            boolean isIronsight = ((ItemGun)stack.func_77973_b()).hasAttachment(stack, Battlefield.content().ironSights.getName());
            multiplier *= multiplier;
            if (isIronsight) {
                multiplier *= 0.05f;
            }
            fov *= 1.0f - multiplier * 0.8f;
        } else {
            this.isZoomed = false;
            this.scopeTime = -1;
            if (this.lastPerspective != -1) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = this.lastPerspective;
                this.lastPerspective = -1;
            }
        }
        event.newfov = fov;
    }

    @Deprecated
    public float tickScope(EntityPlayerSP player, ItemStack stack, ItemGun item, float fov) {
        if (this.isZoomed) {
            ++this.scopeTime;
            if (this.lastPerspective == -1) {
                this.lastPerspective = Minecraft.func_71410_x().field_71474_y.field_74320_O;
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
            }
            if (stack == null || item == null || !item.canUseScope(stack)) {
                this.isZoomed = false;
                return fov;
            }
            float f = fov;
            boolean isAcog = item.hasAttachment(stack, Battlefield.content().ironSights.getName());
            if (player.field_71075_bZ.field_75100_b) {
                f *= 1.1f;
            }
            f *= (player.field_70701_bs * player.field_70701_bs + 1.0f) / 2.0f;
            if (player.func_71039_bw() && player.func_71011_bu().func_77969_a(stack)) {
                int i = stack.func_77973_b().func_77626_a(stack);
                float f1 = (float)i / 20.0f;
                f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
                f *= 1.0f - f1 * 0.15f;
            }
            float fovModifierHand = fov;
            if ((fovModifierHand += (f - fovModifierHand) * 0.5f) > 1.5f) {
                fovModifierHand = 1.5f;
            }
            if (fovModifierHand < 0.1f) {
                fovModifierHand = 0.1f;
            }
            if (isAcog) {
                fovModifierHand *= 4.0f;
            }
            return fovModifierHand;
        }
        if (this.lastPerspective != -1) {
            Minecraft.func_71410_x().field_71474_y.field_74320_O = this.lastPerspective;
            this.lastPerspective = -1;
        }
        if (this.scopeTime > 0) {
            this.scopeTime = -1;
        }
        return fov;
    }

    public void drawCenteredString(FontRenderer par1FontRenderer, String par2Str, int par3, int par4, int par5) {
        par1FontRenderer.func_78261_a(par2Str, par3 - par1FontRenderer.func_78256_a(par2Str) / 2, par4, par5);
    }
}

