/*
 * Decompiled with CFR 0.152.
 */
package assets.battlefield.common;

import assets.battlefield.common.core.CommonProxy;
import assets.battlefield.common.core.ConfigHandler;
import assets.battlefield.common.core.CpwEventHandler;
import assets.battlefield.common.core.CraftHandler;
import assets.battlefield.common.core.EventHandler;
import assets.battlefield.common.core.ModContent;
import assets.battlefield.common.network.AddAttachmentPacket;
import assets.battlefield.common.network.GunFirePacket;
import assets.battlefield.common.network.ReloadGunPacket;
import assets.battlefield.common.network.RemoveAttachmentPacket;
import assets.battlefield.common.network.SniperShootPacket;
import assets.battlefield.common.network.ThreadCheckUpdates;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandHandler;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="battlefield", name="Battlefield", version="1.3.3")
public class Battlefield {
    public static final String version = "1.3.3";
    public File workingDirectory = new File(new File(".", "romejanic"), "Battlefield");
    public ConfigHandler config;
    public ModContent content = new ModContent();
    public ThreadCheckUpdates updateChecker = new ThreadCheckUpdates();
    @Mod.Instance
    public static Battlefield instance;
    @SidedProxy(clientSide="assets.battlefield.client.core.ClientProxy", serverSide="assets.battlefield.common.core.CommonProxy")
    public static CommonProxy proxy;
    public static SimpleNetworkWrapper networkHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            this.workingDirectory = new File(new File(Minecraft.func_71410_x().field_71412_D, "romejanic"), "Battlefield");
        }
        if (!this.workingDirectory.exists()) {
            this.workingDirectory.mkdirs();
        }
        this.config = new ConfigHandler(new File(this.workingDirectory, "config.txt"));
        this.content.register(this.config);
        this.content.registerAchievements(this.config);
        proxy.registerClientPre();
        proxy.loadModInfo(event.getModMetadata());
        networkHandler = NetworkRegistry.INSTANCE.newSimpleChannel("Battlefield");
        networkHandler.registerMessage(AddAttachmentPacket.Handler.class, AddAttachmentPacket.class, 0, Side.SERVER);
        networkHandler.registerMessage(RemoveAttachmentPacket.Handler.class, RemoveAttachmentPacket.class, 1, Side.SERVER);
        networkHandler.registerMessage(GunFirePacket.Handler.class, GunFirePacket.class, 2, Side.SERVER);
        networkHandler.registerMessage(SniperShootPacket.Handler.class, SniperShootPacket.class, 3, Side.SERVER);
        networkHandler.registerMessage(ReloadGunPacket.Handler.class, ReloadGunPacket.class, 4, Side.SERVER);
        this.updateChecker.start();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.content.registerCrafting();
        proxy.registerClient(this.config, this.content);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        FMLCommonHandler.instance().bus().register((Object)new CpwEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new CraftHandler());
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        CommandHandler handler = (CommandHandler)event.getServer().func_71187_D();
    }

    public static ModContent content() {
        return Battlefield.instance.content;
    }
}

