/*
 * Decompiled with CFR 0.152.
 */
package assets.battlefield.common.entity;

import assets.battlefield.common.Battlefield;
import assets.battlefield.common.items.ItemGun;
import assets.battlefield.common.util.DamageSourceCreator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public abstract class EntityBullet
extends EntityThrowable {
    public boolean collided = false;
    public int age = 0;
    public int maxAge = 1000;
    public static final double speed = 2.0;
    private boolean isSniper = false;

    public EntityBullet(World par1World) {
        super(par1World);
        this.field_70159_w *= 2.0;
        this.field_70181_x *= 2.0;
        this.field_70179_y *= 2.0;
    }

    public EntityBullet setSniper() {
        this.isSniper = true;
        return this;
    }

    public boolean isSniper() {
        return this.isSniper;
    }

    public EntityBullet(World par1World, EntityLivingBase par2EntityLivingBase) {
        super(par1World, par2EntityLivingBase);
        this.field_70159_w *= 2.0;
        this.field_70181_x *= 2.0;
        this.field_70179_y *= 2.0;
    }

    protected float func_70185_h() {
        return 1.0E-5f;
    }

    public abstract float getDamage();

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.age;
        if (this.age >= this.maxAge) {
            this.func_70106_y();
        }
    }

    public void func_70109_d(NBTTagCompound nbt) {
        super.func_70109_d(nbt);
        nbt.func_74757_a("hasCollided", this.collided);
        nbt.func_74757_a("isSniper", this.isSniper);
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.collided = nbt.func_74767_n("hasCollided");
        this.isSniper = nbt.func_74767_n("isSniper");
    }

    public boolean shouldUseParticles() {
        return true;
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        try {
            if (!this.collided) {
                if (mop.field_72308_g != null) {
                    if (this.func_85052_h() != null) {
                        this.func_85052_h().func_70652_k(mop.field_72308_g);
                        if (this.func_85052_h() instanceof EntityPlayer) {
                            EntityPlayer player = (EntityPlayer)this.func_85052_h();
                            player.func_71064_a((StatBase)Battlefield.content().callingshots, 1);
                        }
                    }
                    mop.field_72308_g.func_70097_a(DamageSourceCreator.createBulletDamage((Entity)this.func_85052_h(), mop.field_72308_g, this.func_85052_h().func_70694_bm() != null && this.func_85052_h().func_70694_bm().func_77973_b() instanceof ItemGun ? (ItemGun)this.func_85052_h().func_70694_bm().func_77973_b() : null), this.getDamage());
                }
                Block hit = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                int hitMeta = this.field_70170_p.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                this.spawnParticle("blockcrack_" + Block.func_149682_b((Block)hit) + "_" + hitMeta, 0.0, 0.2, 0.0);
                if (this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d).func_149688_o() == Material.field_151592_s || this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d).func_149688_o() == Material.field_151585_k) {
                    this.func_85030_a(hit.field_149762_H.func_150495_a(), 1.0f, 1.0f);
                    this.field_70170_p.func_147468_f(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                    for (int i = 0; i < 30; ++i) {
                        this.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)hit) + "_" + hitMeta, (double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger("Battlefield").log(Level.SEVERE, "An exception occoured on bullet collision!", e);
        }
        this.func_70106_y();
    }

    private void spawnParticle(String particle, double mx, double my, double mz) {
        if (!this.shouldUseParticles()) {
            return;
        }
        this.field_70170_p.func_72869_a(particle, this.field_70165_t, this.field_70163_u, this.field_70161_v, mx, my, mz);
    }
}

