/*
 * Decompiled with CFR 0.152.
 */
package assets.battlefield.common.items;

import assets.battlefield.common.Battlefield;
import assets.battlefield.common.items.EnumGunType;
import assets.battlefield.common.items.ItemAttachment;
import assets.battlefield.common.util.DamageSourceCreator;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class ItemGun
extends Item {
    public ItemGun() {
        this.func_77625_d(1);
        Battlefield.content().addGun(this);
    }

    public abstract void onGunFired(ItemStack var1, World var2, EntityPlayer var3);

    public abstract String getRendererTexture();

    public abstract String getFireSound();

    public abstract String getSilencedSound();

    public abstract Item getMagazineItem();

    public abstract EnumGunType getGunType();

    public abstract int getFireRate();

    public String getGunTypeDescription() {
        return StatCollector.func_74838_a((String)("gun.type." + this.getGunType().name().toLowerCase()));
    }

    public void addAttachment(ItemStack stack, ItemAttachment attachment) {
        NBTTagCompound nbt = stack.field_77990_d != null ? stack.field_77990_d : new NBTTagCompound();
        ItemAttachment[] attachments = this.getAttachments(stack);
        ItemAttachment[] newAttachments = new ItemAttachment[attachments.length + 1];
        for (ItemAttachment att : attachments) {
            if (!att.getName().equals(attachment)) continue;
            return;
        }
        for (int i = 0; i < attachments.length; ++i) {
            newAttachments[i] = attachments[i];
        }
        if (attachment.canBeUsedWithGun(this, attachments)) {
            newAttachments[newAttachments.length - 1] = attachment;
        }
        NBTTagList list = new NBTTagList();
        for (ItemAttachment attach : newAttachments) {
            NBTTagString tag = new NBTTagString(attach.getName());
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Attachments", (NBTBase)list);
        stack.field_77990_d = nbt;
    }

    public void removeAttachment(String name, ItemStack stack) {
        NBTTagCompound nbt = stack.field_77990_d;
        if (nbt == null) {
            return;
        }
        ArrayList<ItemAttachment> arr = new ArrayList<ItemAttachment>();
        for (ItemAttachment attach : this.getAttachments(stack)) {
            if (attach.getName().equals(name)) continue;
            arr.add(attach);
        }
        NBTTagList list = new NBTTagList();
        for (ItemAttachment attach : arr.toArray(new ItemAttachment[0])) {
            if (attach == null) continue;
            NBTTagString tag = new NBTTagString(attach.getName());
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Attachments", (NBTBase)list);
        stack.field_77990_d = nbt;
    }

    public void fireRaycastBullet(EntityLivingBase living, float spread) {
        float f = spread;
        double motionX = -MathHelper.func_76126_a((float)(living.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(living.field_70125_A / 180.0f * (float)Math.PI)) * f;
        double motionZ = MathHelper.func_76134_b((float)(living.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(living.field_70125_A / 180.0f * (float)Math.PI)) * f;
        double motionY = -MathHelper.func_76126_a((float)(living.field_70125_A / 180.0f * (float)Math.PI)) * f;
        MovingObjectPosition mop = living.field_70170_p.func_72933_a(Vec3.func_72443_a((double)living.field_70165_t, (double)living.field_70163_u, (double)living.field_70161_v), Vec3.func_72443_a((double)(living.field_70165_t + motionX * 2000.0), (double)(living.field_70163_u + motionY * 2000.0), (double)(living.field_70161_v + motionZ * 2000.0)));
        if (mop != null && mop.field_72308_g != null) {
            living.func_70652_k(mop.field_72308_g);
            if (living instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)living;
                player.func_71064_a((StatBase)Battlefield.content().callingshots, 1);
            }
            mop.field_72308_g.func_70097_a(DamageSourceCreator.createBulletDamage((Entity)living, mop.field_72308_g, living.func_70694_bm() != null && living.func_70694_bm().func_77973_b() instanceof ItemGun ? (ItemGun)living.func_70694_bm().func_77973_b() : null), 10.0f);
        }
        Block hit = living.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        int hitMeta = living.field_70170_p.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        living.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)hit) + "_" + hitMeta, (double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d, 0.0, 0.2, 0.0);
        if (living.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d).func_149688_o() == Material.field_151592_s || living.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d).func_149688_o() == Material.field_151585_k) {
            living.field_70170_p.func_72980_b((double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d, hit.field_149762_H.func_150495_a(), 1.0f, 1.0f, false);
            living.field_70170_p.func_147468_f(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            for (int i = 0; i < 30; ++i) {
                living.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)hit) + "_" + hitMeta, (double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean hasAttachment(ItemStack stack, String name) {
        for (ItemAttachment attach : this.getAttachments(stack)) {
            if (!attach.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public ItemAttachment[] getAttachments(ItemStack stack) {
        ArrayList<ItemAttachment> arr = new ArrayList<ItemAttachment>();
        if (stack != null && stack.field_77990_d != null) {
            NBTTagList list = stack.field_77990_d.func_150295_c("Attachments", 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ItemAttachment attach;
                String att = list.func_150307_f(i);
                if (att == null || (attach = Battlefield.content().getAttachmentFromName(att)) == null) continue;
                arr.add(attach);
            }
        }
        return arr.toArray(new ItemAttachment[0]);
    }

    public boolean hasAmmo(ItemStack stack) {
        NBTTagCompound nbt;
        NBTTagCompound nBTTagCompound = nbt = stack.field_77990_d != null ? stack.field_77990_d : new NBTTagCompound();
        if (!nbt.func_74764_b("remainingAmmo")) {
            nbt.func_74768_a("remainingAmmo", 0);
            stack.field_77990_d = nbt;
        }
        return stack.field_77990_d.func_74762_e("remainingAmmo") > 0;
    }

    public boolean canPutOnGunRack() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract ModelBase getRendererModel();

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!par3EntityPlayer.field_71075_bZ.field_75098_d && par1ItemStack.field_77990_d != null && par1ItemStack.field_77990_d.func_74762_e("remainingAmmo") <= 0 && !par3EntityPlayer.field_71071_by.func_146028_b(this.getMagazineItem())) {
            return par1ItemStack;
        }
        par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        return par1ItemStack;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        NBTTagCompound nbt;
        if (par1ItemStack.field_77990_d != null && (nbt = par1ItemStack.field_77990_d).func_74762_e("fireCooldown") > 0) {
            nbt.func_74768_a("fireCooldown", nbt.func_74762_e("fireCooldown") - 1);
            par1ItemStack.field_77990_d = nbt;
            return;
        }
        Battlefield.proxy.fireGun(par1ItemStack, par2World, par3Entity, this);
    }

    public void fireGun(EntityPlayer player, ItemStack stack, World world) {
        if (!world.field_72995_K && stack != null) {
            String sound;
            boolean silencerAttached = this.hasAttachment(stack, Battlefield.content().silencer.getName());
            String string = sound = silencerAttached ? this.getSilencedSound() : this.getFireSound();
            if (sound != null) {
                world.func_72956_a((Entity)player, sound, silencerAttached ? 0.5f : 1.0f, 1.0f);
            }
            this.onGunFired(stack, world, player);
            this.performRecoilAnimation(stack, player);
            NBTTagCompound nbt = stack.field_77990_d != null ? stack.field_77990_d : new NBTTagCompound();
            nbt.func_74768_a("fireCooldown", this.getFireRate());
            this.consumeAmmo(player, nbt);
            stack.field_77990_d = nbt;
        }
    }

    public void consumeAmmo(EntityPlayer player, NBTTagCompound nbt) {
        if (!player.field_71075_bZ.field_75098_d) {
            nbt.func_74768_a("remainingAmmo", nbt.func_74762_e("remainingAmmo") - 1);
        }
        if (nbt.func_74762_e("remainingAmmo") < 0) {
            nbt.func_74768_a("remainingAmmo", 0);
        }
    }

    public void performRecoilAnimation(ItemStack stack, EntityPlayer player) {
        if (stack != null && stack.func_77973_b() == Battlefield.content().crossbow) {
            return;
        }
        float power = this.getRecoilPower();
        if (player.field_70125_A > -90.0f) {
            player.field_70125_A -= power;
        }
    }

    public boolean canUseScope(ItemStack stack) {
        return this.hasAttachment(stack, Battlefield.content().ironSights.getName());
    }

    public boolean canContinueFiring(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d || this.hasAmmo(player.func_70694_bm());
    }

    public ItemStack func_77654_b(ItemStack is, World world, EntityPlayer player) {
        return is;
    }

    public int func_77626_a(ItemStack is) {
        return 0x6DDD00;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        ItemAttachment[] attachments;
        par3List.add(StatCollector.func_74837_a((String)"gun.info.type", (Object[])new Object[]{this.getGunTypeDescription()}));
        if (this.getMagazineItem() != null) {
            par3List.add(StatCollector.func_74837_a((String)"gun.info.ammo", (Object[])new Object[]{StatCollector.func_74838_a((String)(this.getMagazineItem().func_77658_a() + ".name"))}));
        }
        if ((attachments = this.getAttachments(par1ItemStack)).length > 0) {
            par3List.add(StatCollector.func_74838_a((String)"item.battlefield.gun.attachlist"));
            for (ItemAttachment attach : attachments) {
                par3List.add(StatCollector.func_74838_a((String)(attach.func_77658_a() + ".name")));
            }
        }
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        if (this.hasAttachment(par1ItemStack, Battlefield.content().bayonet.getName())) {
            if (par3EntityLivingBase != null) {
                par3EntityLivingBase.func_70652_k((Entity)par3EntityLivingBase);
            }
            par2EntityLivingBase.func_70097_a(DamageSourceCreator.createBayonetDamage((Entity)par3EntityLivingBase, (Entity)par2EntityLivingBase), 10.0f);
        }
        return true;
    }

    public float getRecoilPower() {
        return 0.7f;
    }
}

