/*
 * Decompiled with CFR 0.152.
 */
package assets.battlefield.common.network;

import assets.battlefield.common.items.ItemGun;
import assets.battlefield.common.util.PacketUtil;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ReloadGunPacket
implements IMessage {
    private String username;
    private int slot;
    private ItemGun gun;

    public ReloadGunPacket() {
    }

    public ReloadGunPacket(String username, int slot, ItemGun gun) {
        this.username = username;
        this.slot = slot;
        this.gun = gun;
    }

    public String getUsername() {
        return this.username;
    }

    public int getSlot() {
        return this.slot;
    }

    public ItemGun getGun() {
        return this.gun;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.username = nbt.func_74779_i("username");
        this.slot = nbt.func_74762_e("slot");
        this.gun = (ItemGun)Item.func_150899_d((int)nbt.func_74762_e("gun"));
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("username", this.getUsername());
        nbt.func_74768_a("slot", this.getSlot());
        nbt.func_74768_a("gun", Item.func_150891_b((Item)this.getGun()));
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    public static class Handler
    implements IMessageHandler<ReloadGunPacket, IMessage> {
        public IMessage onMessage(ReloadGunPacket message, MessageContext ctx) {
            EntityPlayer player = PacketUtil.getPlayer(message.getUsername());
            ItemStack stack = player.field_71071_by.func_70301_a(message.getSlot());
            if (stack != null && stack.func_77973_b() == message.getGun()) {
                NBTTagCompound nbt;
                ItemGun gun = (ItemGun)stack.func_77973_b();
                Item magazine = gun.getMagazineItem();
                NBTTagCompound nBTTagCompound = nbt = stack.field_77990_d != null ? stack.field_77990_d : new NBTTagCompound();
                if (player.field_71071_by.func_146028_b(gun.getMagazineItem())) {
                    nbt.func_74768_a("remainingAmmo", magazine.func_77612_l());
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_146026_a(gun.getMagazineItem());
                    }
                }
                stack.field_77990_d = nbt;
            }
            return null;
        }
    }
}

