/*
 * Decompiled with CFR 0.152.
 */
package assets.battlefield.common.util;

import assets.battlefield.common.Battlefield;
import assets.battlefield.common.entity.solider.EntitySoldier;
import assets.battlefield.common.entity.solider.SoliderSides;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;

public class SoldierUtil {
    private static final Random random = new Random();
    private static final String[] RANKS = new String[]{"Pvt", "Cpr", "Srg", "Wo1", "Wo2", "Lft", "Cpt", "Mgr", "Gen", "Mgr Gen"};
    private static final String TEXTS_WEST = "/assets/battlefield/texts/solider_west.txt";

    public static String generateSoliderName() {
        String rank = SoldierUtil.getRandomString(RANKS);
        String name = "-ERR-";
        try {
            InputStream stream = SoldierUtil.class.getResourceAsStream(TEXTS_WEST);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            ArrayList<String> list = new ArrayList<String>();
            String line = reader.readLine();
            while (line != null) {
                list.add(line);
                line = reader.readLine();
            }
            reader.close();
            name = SoldierUtil.getRandomString(list.toArray(new String[0]));
        }
        catch (Exception e) {
            System.err.println("Cannot generate solider name!");
            e.printStackTrace();
        }
        return rank + ". " + name;
    }

    public static String getRandomString(String[] strs) {
        return strs[random.nextInt(strs.length)];
    }

    public static EntityLivingBase getClosestEnemy(EntitySoldier soldier, float range) {
        for (Entity entity : soldier.field_70170_p.func_72839_b((Entity)soldier, AxisAlignedBB.func_72330_a((double)(soldier.field_70165_t - (double)range), (double)(soldier.field_70163_u - (double)range), (double)(soldier.field_70161_v - (double)range), (double)(soldier.field_70165_t + (double)range), (double)(soldier.field_70163_u + (double)range), (double)(soldier.field_70161_v + (double)range)))) {
            EntitySoldier s;
            if (soldier.getSide() == SoliderSides.EAST) {
                if (!(entity instanceof EntitySoldier) && !(entity instanceof EntityPlayer)) continue;
                EntityLivingBase living = (EntityLivingBase)entity;
                if (living instanceof EntitySoldier && ((EntitySoldier)living).getSide() == SoliderSides.WEST) {
                    return living;
                }
                if (!(living instanceof EntityPlayer) || ((EntityPlayer)living).field_71075_bZ.field_75098_d) continue;
                return living;
            }
            if (soldier.getSide() != SoliderSides.WEST || !(entity instanceof EntitySoldier) || (s = (EntitySoldier)entity).getSide() != SoliderSides.EAST) continue;
            return s;
        }
        return null;
    }

    public static ItemStack getDogTagsForSoldier(EntitySoldier soldier) {
        ItemStack stack = new ItemStack(Battlefield.content().dogTag, 1);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("ownerName", soldier.func_94057_bL() + " (" + StatCollector.func_74838_a((String)("soldier.side." + soldier.getSide().name().toLowerCase())) + ")");
        stack.field_77990_d = nbt;
        return stack;
    }
}

