/*
 * Decompiled with CFR 0.152.
 */
package assets.battlefield.common.entity.solider;

import assets.battlefield.common.Battlefield;
import assets.battlefield.common.entity.EntityGrenade;
import assets.battlefield.common.entity.EntityM16Bullet;
import assets.battlefield.common.entity.solider.SoliderSides;
import assets.battlefield.common.items.ItemGun;
import assets.battlefield.common.items.ItemMedicalKit;
import assets.battlefield.common.util.SoldierUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntitySoldier
extends EntityMob
implements IRangedAttackMob {
    @Deprecated
    private EntityAIArrowAttack aiArrow = new EntityAIArrowAttack((IRangedAttackMob)this, 1.25, 20, 10.0f);
    private SoliderSides side;
    private boolean holdGun = false;
    private boolean female = false;
    private int fireDelay = 0;
    private int timeSinceLastGrenade = 0;
    private PathEntity entityPath;

    public EntitySoldier(World p_i1595_1_) {
        super(p_i1595_1_);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.1));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.female = this.field_70170_p.field_73012_v.nextInt(4) == 0;
        this.func_94058_c(this.generateName(this.getSide()));
        this.func_94061_f(true);
    }

    public String generateName(SoliderSides side) {
        if (this.func_94056_bM()) {
            return this.func_94057_bL();
        }
        if (side == SoliderSides.EAST && this.female && (this.field_70146_Z.nextInt(999) == 0 || this.func_94057_bL() != null && this.func_94057_bL().equalsIgnoreCase("Mother Russia"))) {
            return EnumChatFormatting.RED + "Mother Russia";
        }
        return SoldierUtil.generateSoliderName();
    }

    public EntitySoldier setSide(SoliderSides side) {
        this.side = side;
        this.func_94058_c(this.generateName(this.getSide()));
        return this;
    }

    public SoliderSides getSide() {
        if (this.side == null) {
            this.side = SoliderSides.random();
        }
        return this.side;
    }

    @Deprecated
    private void loadAI() {
        this.field_70715_bh.func_85156_a((EntityAIBase)this.aiArrow);
        if (this.getSide() == SoliderSides.WEST || this.getSide() == SoliderSides.EAST) {
            // empty if block
        }
    }

    public boolean func_70650_aV() {
        return true;
    }

    public boolean isSearchingForPlayer() {
        return this.holdGun;
    }

    public void func_70071_h_() {
        EntityLivingBase target;
        super.func_70071_h_();
        if (this.fireDelay > 0) {
            --this.fireDelay;
        }
        if ((target = SoldierUtil.getClosestEnemy(this, 30.0f)) != null) {
            this.holdGun = true;
            this.func_70671_ap().func_75650_a(target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v, 10.0f, (float)this.func_70646_bf());
            MovingObjectPosition mop = this.field_70170_p.func_72933_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v), Vec3.func_72443_a((double)target.field_70165_t, (double)(target.field_70163_u + (double)target.func_70047_e()), (double)target.field_70161_v));
            if (mop != null) {
                if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) != Blocks.field_150359_w || this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) != Blocks.field_150410_aZ)) {
                    if (this.func_70661_as().func_75500_f()) {
                        this.entityPath = this.func_70661_as().func_75494_a((Entity)target);
                        this.func_70661_as().func_75484_a(this.entityPath, 0.1);
                    }
                    return;
                }
                if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && mop.field_72308_g instanceof EntitySoldier && ((EntitySoldier)mop.field_72308_g).getSide() == this.getSide()) {
                    if (this.func_70661_as().func_75500_f()) {
                        this.entityPath = this.func_70661_as().func_75494_a((Entity)target);
                        this.func_70661_as().func_75484_a(this.entityPath, 0.1);
                    }
                    return;
                }
            }
            if ((target.func_70032_d((Entity)this) > 15.0f || !this.func_70635_at().func_75522_a((Entity)target)) && this.func_70661_as().func_75500_f()) {
                this.func_70661_as().func_75497_a((Entity)target, (double)0.1f);
                if (this.timeSinceLastGrenade <= 0 && this.field_70170_p.field_73012_v.nextInt(100) == 0 && this.field_70170_p.func_82736_K().func_82766_b("soldiersThrowGrenades")) {
                    EntityGrenade grenade = new EntityGrenade(this.field_70170_p, (EntityLivingBase)this).setSoldier();
                    double d0 = target.field_70165_t - this.field_70165_t;
                    double d1 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - grenade.field_70163_u;
                    double d2 = target.field_70161_v - this.field_70161_v;
                    float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
                    grenade.func_70186_c(d0, d1 + (double)f1, d2, 1.6f, 12.0f);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)grenade);
                    }
                    this.timeSinceLastGrenade = 100 + this.field_70170_p.field_73012_v.nextInt(1000);
                }
            }
            if (this.fireDelay <= 0) {
                this.func_82196_d(target, 1.0f);
                if (this.func_71124_b(0) == null || !(this.func_71124_b(0).func_77973_b() instanceof ItemGun)) {
                    return;
                }
                this.fireDelay = ((ItemGun)this.func_71124_b(0).func_77973_b()).getFireRate() * 4;
            }
        } else {
            this.holdGun = false;
        }
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        super.func_70645_a(p_70645_1_);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("soldiersDropDogTags")) {
            this.func_70099_a(SoldierUtil.getDogTagsForSoldier(this), 0.0f);
        }
    }

    public boolean func_70093_af() {
        if (this.func_110143_aJ() < this.func_110138_aP() / 4.0f) {
            return true;
        }
        return super.func_70093_af();
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (player.func_70694_bm() != null) {
            if (player.func_70694_bm().func_77973_b() instanceof ItemMedicalKit) {
                return super.func_70085_c(player);
            }
            if (player.func_70694_bm().func_77973_b() instanceof ItemGun) {
                return super.func_70085_c(player);
            }
        }
        Battlefield.proxy.displaySoldierGui(this, player);
        return true;
    }

    public void func_70109_d(NBTTagCompound nbt) {
        super.func_70109_d(nbt);
        nbt.func_74757_a("Female", this.female);
        nbt.func_74778_a("Side", this.getSide().name().toLowerCase());
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.side = SoliderSides.forName(nbt.func_74779_i("Side"));
        this.female = nbt.func_74767_n("Female");
        this.func_94058_c(this.generateName(this.getSide()));
        this.func_82164_bB();
    }

    protected void func_82164_bB() {
        this.func_70062_b(0, new ItemStack((Item)this.getSide().getGun()));
        this.func_70062_b(4, new ItemStack(this.getSide().getHelmet()));
        this.func_70062_b(2, new ItemStack(this.getSide().getChestplate()));
        this.func_70062_b(3, new ItemStack(this.getSide().getLeggings()));
    }

    public boolean isFemale() {
        return this.female;
    }

    public void setFemale() {
        this.female = true;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData p_110161_1_) {
        p_110161_1_ = super.func_110161_a(p_110161_1_);
        this.func_82164_bB();
        return p_110161_1_;
    }

    public void fireGun(ItemStack stack, World world, EntityLivingBase target) {
        String sound;
        ItemGun gun;
        ItemGun itemGun = gun = stack != null ? (ItemGun)stack.func_77973_b() : null;
        if (gun == null) {
            return;
        }
        boolean silencerAttached = gun.hasAttachment(stack, Battlefield.content().silencer.getName());
        String string = sound = silencerAttached ? gun.getSilencedSound() : gun.getFireSound();
        if (sound != null) {
            this.func_85030_a(sound, silencerAttached ? 0.5f : 1.0f, 1.0f);
        }
        if (!world.field_72995_K) {
            int bulletCount = this.getSide() == SoliderSides.WEST ? 3 : 2;
            for (int i = 0; i < bulletCount; ++i) {
                EntityM16Bullet theBullet = new EntityM16Bullet(world, (EntityLivingBase)this);
                double d0 = target.field_70165_t - this.field_70165_t;
                double d1 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - theBullet.field_70163_u;
                double d2 = target.field_70161_v - this.field_70161_v;
                float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
                theBullet.func_70186_c(d0, d1 + (double)f1, d2, 1.6f, 12.0f);
                world.func_72838_d((Entity)theBullet);
            }
        }
    }

    public void func_82196_d(EntityLivingBase p_82196_1_, float p_82196_2_) {
        this.fireGun(this.func_71124_b(0), this.field_70170_p, p_82196_1_);
    }
}

