/*
 * Decompiled with CFR 0.152.
 */
package assets.battlefield.common.entity.solider;

import assets.battlefield.common.Battlefield;
import assets.battlefield.common.items.ItemGun;
import java.util.Random;
import net.minecraft.item.Item;

public enum SoliderSides {
    WEST,
    EAST;

    private static Random random;

    public ItemGun getGun() {
        switch (this) {
            case WEST: {
                return (ItemGun)Battlefield.content().m16;
            }
            case EAST: {
                return (ItemGun)Battlefield.content().ak47;
            }
        }
        return (ItemGun)Battlefield.content().m16;
    }

    public Item getHelmet() {
        switch (this) {
            case WEST: {
                return Battlefield.content().forestcam;
            }
            case EAST: {
                return Battlefield.content().sas;
            }
        }
        return Battlefield.content().forestcam;
    }

    public Item getChestplate() {
        switch (this) {
            case WEST: {
                return Battlefield.content().commonShirt;
            }
            case EAST: {
                return Battlefield.content().russianShirt;
            }
        }
        return Battlefield.content().commonShirt;
    }

    public Item getLeggings() {
        switch (this) {
            case WEST: {
                return Battlefield.content().commonTrousers;
            }
            case EAST: {
                return Battlefield.content().russianTrousers;
            }
        }
        return Battlefield.content().commonTrousers;
    }

    public static SoliderSides random() {
        return SoliderSides.values()[random.nextInt(SoliderSides.values().length)];
    }

    public static SoliderSides forName(String name) {
        for (SoliderSides side : SoliderSides.values()) {
            if (!side.name().equalsIgnoreCase(name)) continue;
            return side;
        }
        return null;
    }

    public static SoliderSides forIndex(int i) {
        try {
            return SoliderSides.values()[i];
        }
        catch (Exception e) {
            return SoliderSides.random();
        }
    }

    static {
        random = new Random();
    }
}

