/*
 * Decompiled with CFR 0.152.
 */
package assets.battlefield.common.network;

import assets.battlefield.common.items.ItemAttachment;
import assets.battlefield.common.items.ItemGun;
import assets.battlefield.common.util.PacketUtil;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class AddAttachmentPacket
implements IMessage {
    private String username;
    private int itemSlot;
    private ItemAttachment attachment;

    public AddAttachmentPacket() {
    }

    public AddAttachmentPacket(String username, int itemSlot, ItemAttachment attachment) {
        this.username = username;
        this.itemSlot = itemSlot;
        this.attachment = attachment;
    }

    public String getUsername() {
        return this.username;
    }

    public int getItemSlot() {
        return this.itemSlot;
    }

    public ItemAttachment getAttachment() {
        return this.attachment;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.username = nbt.func_74779_i("username");
        this.itemSlot = nbt.func_74762_e("slot");
        this.attachment = (ItemAttachment)Item.field_150901_e.func_82594_a(nbt.func_74779_i("attachment"));
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("username", this.getUsername());
        nbt.func_74768_a("slot", this.getItemSlot());
        nbt.func_74778_a("attachment", Item.field_150901_e.func_148750_c((Object)this.getAttachment()));
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    public static class Handler
    implements IMessageHandler<AddAttachmentPacket, IMessage> {
        public IMessage onMessage(AddAttachmentPacket message, MessageContext ctx) {
            EntityPlayer player = PacketUtil.getPlayer(message.getUsername());
            ItemStack stack = player.field_71071_by.func_70301_a(message.getItemSlot());
            ItemAttachment attachment = message.getAttachment();
            Item gun = stack.func_77973_b();
            if (gun instanceof ItemGun && attachment != null) {
                ((ItemGun)gun).addAttachment(stack, attachment);
                player.field_71071_by.func_146026_a((Item)message.getAttachment());
            }
            return null;
        }
    }
}

