/*
 * Decompiled with CFR 0.152.
 */
package assets.battlefield.common.network;

import assets.battlefield.common.items.ItemGun;
import assets.battlefield.common.util.PacketUtil;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;

public class GunFirePacket
implements IMessage {
    private String username;
    private ItemGun gun;
    private int gunIndex;

    public GunFirePacket() {
    }

    public GunFirePacket(String username, ItemGun gun, int gunIndex) {
        this.username = username;
        this.gun = gun;
        this.gunIndex = gunIndex;
    }

    public String getUsername() {
        return this.username;
    }

    public ItemGun getGun() {
        return this.gun;
    }

    public int getGunIndex() {
        return this.gunIndex;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.username = nbt.func_74779_i("username");
        this.gun = (ItemGun)Item.func_150899_d((int)nbt.func_74762_e("gun"));
        this.gunIndex = nbt.func_74762_e("slot");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("username", this.getUsername());
        nbt.func_74768_a("gun", Item.func_150891_b((Item)this.getGun()));
        nbt.func_74768_a("slot", this.getGunIndex());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    public static class Handler
    implements IMessageHandler<GunFirePacket, IMessage> {
        public IMessage onMessage(GunFirePacket message, MessageContext ctx) {
            EntityPlayer player = PacketUtil.getPlayer(message.getUsername());
            message.getGun().fireGun(player, player.field_71071_by.field_70462_a[message.getGunIndex()], player.field_70170_p);
            return null;
        }
    }
}

