/*
 * Decompiled with CFR 0.152.
 */
package assets.battlefield.common.network;

import assets.battlefield.common.items.ItemAttachment;
import assets.battlefield.common.items.ItemGun;
import assets.battlefield.common.util.PacketUtil;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RemoveAttachmentPacket
implements IMessage {
    private String username;
    private int itemSlot;
    private ItemAttachment attachment;

    public RemoveAttachmentPacket() {
    }

    public RemoveAttachmentPacket(String username, int itemSlot, ItemAttachment attachment) {
        this.username = username;
        this.itemSlot = itemSlot;
        this.attachment = attachment;
    }

    public String getUsername() {
        return this.username;
    }

    public int getItemSlot() {
        return this.itemSlot;
    }

    public ItemAttachment getAttachment() {
        return this.attachment;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.username = nbt.func_74779_i("username");
        this.itemSlot = nbt.func_74762_e("slot");
        this.attachment = (ItemAttachment)Item.func_150899_d((int)nbt.func_74762_e("attachment"));
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("username", this.getUsername());
        nbt.func_74768_a("slot", this.getItemSlot());
        nbt.func_74768_a("attachment", Item.func_150891_b((Item)this.getAttachment()));
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    public static class Handler
    implements IMessageHandler<RemoveAttachmentPacket, IMessage> {
        public IMessage onMessage(RemoveAttachmentPacket message, MessageContext ctx) {
            EntityPlayer player = PacketUtil.getPlayer(message.getUsername());
            ItemStack stack = player.field_71071_by.func_70301_a(message.getItemSlot());
            ItemAttachment attachment = message.getAttachment();
            Item gun = stack.func_77973_b();
            if (gun instanceof ItemGun && attachment != null) {
                ((ItemGun)gun).removeAttachment(attachment.getName(), stack);
                if (!player.field_70170_p.field_72995_K) {
                    EntityItem item = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack((Item)attachment, 1));
                    item.field_145804_b = 1;
                    player.field_70170_p.func_72838_d((Entity)item);
                }
            }
            return null;
        }
    }
}

