/*
 * Decompiled with CFR 0.152.
 */
package assets.battlefield.common.network;

import assets.battlefield.common.items.ItemSniperRifle;
import assets.battlefield.common.util.PacketUtil;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;

public class SniperShootPacket
implements IMessage {
    private String username;
    private ItemSniperRifle gun;
    private int gunIndex;
    private int scopeTime;
    private float x;
    private float y;
    private float z;

    public SniperShootPacket() {
    }

    public SniperShootPacket(String username, ItemSniperRifle gun, int gunIndex, int scopeTime, float x, float y, float z) {
        this.username = username;
        this.gun = gun;
        this.gunIndex = gunIndex;
        this.scopeTime = scopeTime;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public String getUsername() {
        return this.username;
    }

    public ItemSniperRifle getGun() {
        return this.gun;
    }

    public int getGunIndex() {
        return this.gunIndex;
    }

    public int getScopeTime() {
        return this.scopeTime;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.username = nbt.func_74779_i("username");
        this.gun = (ItemSniperRifle)Item.func_150899_d((int)nbt.func_74762_e("gun"));
        this.gunIndex = nbt.func_74762_e("slot");
        this.scopeTime = nbt.func_74762_e("scopeTime");
        this.x = nbt.func_74760_g("x");
        this.y = nbt.func_74760_g("y");
        this.z = nbt.func_74760_g("z");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("username", this.getUsername());
        nbt.func_74768_a("gun", Item.func_150891_b((Item)this.getGun()));
        nbt.func_74768_a("slot", this.getGunIndex());
        nbt.func_74768_a("scopeTime", this.getScopeTime());
        nbt.func_74776_a("x", this.getX());
        nbt.func_74776_a("y", this.getY());
        nbt.func_74776_a("z", this.getZ());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    public static class Handler
    implements IMessageHandler<SniperShootPacket, IMessage> {
        public IMessage onMessage(SniperShootPacket message, MessageContext ctx) {
            EntityPlayer player = PacketUtil.getPlayer(message.getUsername());
            message.getGun().fireGun(player, player.field_71071_by.field_70462_a[message.getGunIndex()], player.field_70170_p);
            player.field_70170_p.func_72838_d((Entity)message.getGun().getSniperBullet(message, player));
            return null;
        }
    }
}

