/**
 * Copyright 2013 Yamato
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mod.ymt.air.AirCraftCore;
import mod.ymt.air.ClientKeyBinder;

/**
 * @author Yamato
 *
 */
public class mod_HariboteAirCraft extends BaseMod {
	@MLProp(min = 0)
	public static int IdPyxis = 209;
	@MLProp(min = 0)
	public static int blockLimit = 2000;
	@MLProp
	public static int craftBodySize = -1;
	@MLProp(min = 1)
	public static int moveKeepTime = 60; // L[v^CftHg 60 b
	@MLProp
	public static String blockTarget = "";
	@MLProp
	public static String blockAppend = "";
	@MLProp
	public static String blockIgnore = "2, 3, 8, 9, 10, 11, 12, 13, 31, 32, 37, 38, 78, 87, 121"; // ŐAyAAnAAAA͂؁AԁAoAAlU[bNAGhXg[
	@MLProp
	public static String renderIgnore = "";
	@MLProp
	public static boolean creativeOnly = false;
	@MLProp
	public static int entityIdPyxis = 0;
	@MLProp
	public static int entityIdInvisible = 0;
	@MLProp
	public static int entityIdMobMat = 0;

	public ClientKeyBinder keyBinder = null;

	@Override
	public void addRenderer(Map map) {
		AirCraftCore.getInstance().addRenderer(map);
	}

	@Override
	public void clientCustomPayload(NetClientHandler handler, Packet250CustomPayload packet) {
		AirCraftCore.getInstance().net.processClientCustomPayload(packet);
	}

	@Override
	public String getPriorities() {
		return "required-after:mod_YMTLib";
	}

	@Override
	public Packet23VehicleSpawn getSpawnPacket(Entity var1, int var2) {
		return new Packet23VehicleSpawn(var1, var2);
	}

	@Override
	public String getVersion() {
		return "152v4 ulysses";
	}

	@Override
	public void keyboardEvent(KeyBinding key) {
		keyBinder.keyboardEvent(key);
	}

	@Override
	public void load() {
		try {
			AirCraftCore core = AirCraftCore.getInstance();
			core.setBaseMod(this);
			core.setBlockIdPyxis(IdPyxis);
			core.setEntityIdPyxis(entityIdPyxis);
			core.setEntityIdInvisible(entityIdInvisible);
			core.setEntityIdMobMat(entityIdMobMat);
			core.setBlocklimit(blockLimit);
			core.setCraftBodySize(craftBodySize);
			core.setMoveKeepTime(moveKeepTime * 20); // 20FPS
			core.targetBlockId.addAll(parseIdList(blockTarget));
			core.appendixBlockId.addAll(parseIdList(blockAppend));
			core.ignoredBlockId.addAll(parseIdList(blockIgnore));
			core.ignoreRenderBlockId.addAll(parseIdList(renderIgnore));
			core.setCreativeOnly(creativeOnly);
			core.run();
		}
		catch (NoClassDefFoundError ex) {
			ex.printStackTrace();
		}

		try {
			keyBinder = new ClientKeyBinder(this);
		}
		catch (NoClassDefFoundError ex) {
			ex.printStackTrace();
		}
	}

	@Override
	public void modsLoaded() {
		// fobO\
		AirCraftCore core = AirCraftCore.getInstance();
		core.debugPrint("defaultMoveableSet: %s", core.getDefaultMoveableSet());
		core.debugPrint("targetBlockId: %s", core.targetBlockId);
		core.debugPrint("appendixBlockId: %s", core.appendixBlockId);
		core.debugPrint("ignoredBlockId: %s", core.ignoredBlockId);
		core.debugPrint("MoveableBlockIds: %s", core.getMoveableBlockIds());
	}

	@Override
	public void serverCustomPayload(NetServerHandler handler, Packet250CustomPayload packet) {
		AirCraftCore.getInstance().net.processServerCustomPayload(packet);
	}

	@Override
	public Entity spawnEntity(int entId, World world, double x, double y, double z) {
		return AirCraftCore.getInstance().spawnEntity(entId, world, x, y, z);
	}

	private static List<Integer> parseIdList(String text) {
		List<Integer> result = new ArrayList<Integer>();
		if (text != null) {
			for (String value: text.split(",")) {
				value = value.trim();
				if (0 < value.length()) {
					try {
						result.add(Integer.parseInt(value));
					}
					catch (NumberFormatException ex) {
						AirCraftCore.getInstance().debugPrint("IllegalNumberFormat[%s]", value);
					}
				}
			}
		}
		return result;
	}
}
