/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.writer;

import de.maggicraft.ism.ISMMain;
import de.maggicraft.ism.writer.frames.FrameUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WriterUtil {
    private static String writerVersion = "1.2.0";
    private static int fixPoint;
    private static int sizeX;
    private static int sizeY;
    private static int sizeZ;
    private static int allBlocks;
    private static int scannedBlocks;
    private static int oldY;
    private static int oldX;

    public static void readBlocks(World world, int x, int y, int z, String block, Block tmpBlock) {
        WriterUtil.writeString("nM;" + block);
        for (int Y = 0; Y < sizeY; ++Y) {
            for (int X = 0; X < sizeX; ++X) {
                for (int Z = 0; Z < sizeZ; ++Z) {
                    if (world.func_147439_a(x + X, y + Y, z + Z) != tmpBlock) continue;
                    if (oldY == Y + 1 - fixPoint) {
                        if (oldX == X) {
                            WriterUtil.writeString(WriterUtil.getString(Z));
                        } else {
                            WriterUtil.writeString(WriterUtil.getString(X) + ";" + WriterUtil.getString(Z));
                        }
                        oldX = X;
                    } else {
                        WriterUtil.writeString(WriterUtil.getString(X) + ";" + WriterUtil.getString(Y + 1 - fixPoint) + ";" + WriterUtil.getString(Z));
                    }
                    oldY = Y + 1 - fixPoint;
                    System.out.println(++scannedBlocks + "/" + allBlocks);
                }
            }
        }
    }

    public static void readBlocks(World world, int x, int y, int z, String block, Block tmpBlock, int tmpMeta) {
        WriterUtil.writeString("sM;" + block + ";" + tmpMeta);
        WriterUtil.checkPos(tmpBlock, tmpMeta, world, x, y, z);
    }

    public static void readBlocks(World world, int x, int y, int z, String block, Block tmpBlock, int tmpMeta, String metaPack) {
        WriterUtil.writeString("cM;" + block + ";" + metaPack);
        WriterUtil.checkPos(tmpBlock, tmpMeta, world, x, y, z);
    }

    public static void specialBlocks(World world, int x, int y, int z, String block, Block tmpBlock, int tmpMeta, String metaPack) {
        WriterUtil.writeString("sB;" + block + ";" + metaPack);
        WriterUtil.checkPos(tmpBlock, tmpMeta, world, x, y, z);
    }

    public static void checkPos(Block tmpBlock, int tmpMeta, World world, int x, int y, int z) {
        for (int Y = 0; Y < sizeY; ++Y) {
            for (int X = 0; X < sizeX; ++X) {
                for (int Z = 0; Z < sizeZ; ++Z) {
                    if (world.func_147439_a(x + X, y + Y, z + Z) != tmpBlock || world.func_72805_g(x + X, y + Y, z + Z) != tmpMeta) continue;
                    if (oldY == Y + 1 - fixPoint) {
                        if (oldX == X) {
                            WriterUtil.writeString(WriterUtil.getString(Z));
                        } else {
                            WriterUtil.writeString(WriterUtil.getString(X) + ";" + WriterUtil.getString(Z));
                        }
                        oldX = X;
                    } else {
                        WriterUtil.writeString(WriterUtil.getString(X) + ";" + WriterUtil.getString(Y + 1 - fixPoint) + ";" + WriterUtil.getString(Z));
                    }
                    oldY = Y + 1 - fixPoint;
                    System.out.println(++scannedBlocks + "/" + allBlocks);
                }
            }
        }
    }

    public static void count(World world, int x, int y, int z) {
        allBlocks = 0;
        for (int X = 0; X < sizeX; ++X) {
            for (int Y = 0; Y < sizeY; ++Y) {
                for (int Z = 0; Z < sizeZ; ++Z) {
                    if (world.func_147439_a(x + X, y + Y, z + Z) == Blocks.field_150350_a || world.func_147439_a(x + X, y + Y, z + Z) == ISMMain.blockArea) continue;
                    ++allBlocks;
                }
            }
        }
        System.out.println("counted " + allBlocks + " blocks");
    }

    public static void writeInfo() {
        new File(FrameUtil.getPath()).mkdir();
        try {
            FileWriter writer = new FileWriter(FrameUtil.getFile());
            writer.write("i;date;" + new SimpleDateFormat("dd.MM.yyyy").format(new Date()));
            writer.write(System.getProperty("line.separator"));
            writer.write("i;structureName;" + FrameUtil.getStructureName());
            writer.write(System.getProperty("line.separator"));
            writer.write("i;creatorName;" + FrameUtil.getCreatorName());
            writer.write(System.getProperty("line.separator"));
            writer.write("i;genre;" + FrameUtil.getGenre());
            writer.write(System.getProperty("line.separator"));
            writer.write("i;blockQuantity;" + allBlocks);
            writer.write(System.getProperty("line.separator"));
            writer.write("i;minDepth;" + fixPoint);
            writer.write(System.getProperty("line.separator"));
            writer.write("i;maxX;" + sizeX);
            writer.write(System.getProperty("line.separator"));
            writer.write("i;maxY;" + sizeY);
            writer.write(System.getProperty("line.separator"));
            writer.write("i;maxZ;" + sizeZ);
            writer.write(System.getProperty("line.separator"));
            writer.write("i;picSrc;");
            writer.write(System.getProperty("line.separator"));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeString(String block) {
        try {
            FileWriter writer = new FileWriter(FrameUtil.getFile(), true);
            writer.write(block);
            writer.write(System.getProperty("line.separator"));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getString(int tmpInt) {
        Integer tmpInteger = new Integer(tmpInt);
        String tmpString = tmpInteger.toString();
        return tmpString;
    }

    public static void encryptFile() throws Exception {
        int n;
        String encryptedFile = FrameUtil.getPath() + "/" + FrameUtil.getFileName() + ".ism-structure";
        String decryptedFile = FrameUtil.getPath() + "/" + FrameUtil.getFileName() + ".ism-temp";
        Cipher cipher = Cipher.getInstance("DES");
        SecretKeySpec key = new SecretKeySpec(FrameUtil.getPassword().getBytes(), "DES");
        cipher.init(1, key);
        FileInputStream in = new FileInputStream(decryptedFile);
        CipherOutputStream out = new CipherOutputStream(new FileOutputStream(encryptedFile), cipher);
        byte[] byteBuffer = new byte[1024];
        while ((n = ((InputStream)in).read(byteBuffer)) != -1) {
            out.write(byteBuffer, 0, n);
        }
        ((InputStream)in).close();
        out.close();
    }

    public static void decryptFile() throws Exception {
        int n;
        String encryptedFile = FrameUtil.getPath() + "/" + FrameUtil.getFileName() + ".ism-structure";
        String decryptedFile = FrameUtil.getPath() + "/" + FrameUtil.getFileName() + ".ism-temp";
        Cipher cipher = Cipher.getInstance("DES");
        SecretKeySpec key = new SecretKeySpec(FrameUtil.getPassword().getBytes(), "DES");
        cipher.init(2, key);
        CipherInputStream in = new CipherInputStream(new FileInputStream(encryptedFile), cipher);
        FileOutputStream out = new FileOutputStream(decryptedFile);
        byte[] byteBuffer = new byte[1024];
        while ((n = in.read(byteBuffer)) != -1) {
            ((OutputStream)out).write(byteBuffer, 0, n);
        }
        in.close();
        ((OutputStream)out).close();
    }

    public static void decryptFile(String name) throws Exception {
        int n;
        System.out.println(name);
        String encryptedFile = FrameUtil.getPath() + "/" + name + ".ism-structure";
        String decryptedFile = FrameUtil.getPath() + "/" + name + ".ism-temp";
        System.out.println("path: " + encryptedFile);
        System.out.println("path: " + decryptedFile);
        Cipher cipher = Cipher.getInstance("DES");
        SecretKeySpec key = new SecretKeySpec(FrameUtil.getPassword().getBytes(), "DES");
        cipher.init(2, key);
        CipherInputStream in = new CipherInputStream(new FileInputStream(encryptedFile), cipher);
        FileOutputStream out = new FileOutputStream(decryptedFile);
        byte[] byteBuffer = new byte[1024];
        while ((n = in.read(byteBuffer)) != -1) {
            ((OutputStream)out).write(byteBuffer, 0, n);
        }
        in.close();
        ((OutputStream)out).close();
    }

    public static void deleteTmpFile(String tmp) {
        System.out.println("delete: " + FrameUtil.getPath() + "/" + tmp + ".ism-temp");
        new File(FrameUtil.getPath() + "/" + tmp + ".ism-temp").delete();
    }

    public static void deleteTmpFile() {
        System.out.println("delete: " + FrameUtil.getPath() + "/" + FrameUtil.getFileName() + ".ism-temp");
        new File(FrameUtil.getPath() + "/" + FrameUtil.getFileName() + ".ism-temp").delete();
    }

    public static void setSize(int tmpFixPoint, int x, int y, int z) {
        fixPoint = tmpFixPoint;
        sizeX = x;
        sizeY = y;
        sizeZ = z;
    }

    public static int getSizeX() {
        return sizeX;
    }

    public static int getSizeY() {
        return sizeY;
    }

    public static int getSizeZ() {
        return sizeZ;
    }

    public static void setScannedBlocks() {
        scannedBlocks = 0;
    }

    static {
        oldY = 1000000;
        oldX = 1000000;
    }
}

