/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.writer.frames;

import de.maggicraft.ism.Util;
import de.maggicraft.ism.wiki.patterns.Button;
import de.maggicraft.ism.wiki.patterns.Picture;
import de.maggicraft.ism.wiki.patterns.TextArea;
import de.maggicraft.ism.writer.ItemReader;
import de.maggicraft.ism.writer.WriterUtil;
import de.maggicraft.ism.writer.frames.FrameUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FrameReader
extends JFrame {
    private static JFrame frame = new JFrame();
    private JCheckBox checkBox = new JCheckBox();
    private JComboBox comboBox = new JComboBox();
    private static File file;
    private static File[] fileArray;
    private static File[] selectedFiles;
    private static String[] fileNames;
    private static String[] structureNames;
    private static String[] creatorNames;
    private static String[] dates;
    private static String[] blockQuantities;
    private static String[] picturesSrc;
    private static boolean noFiles;
    private static int bid;

    public FrameReader(int id) {
        frame.setSize(Util.getFrameWidth(), Util.getFrameHeight());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((dimension.width - Util.getFrameWidth()) / 2, (dimension.height - Util.getFrameHeight()) / 2);
        frame.setResizable(false);
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.setBackground(new Color(100, 100, 100));
        frame.setTitle("Reader (beta)");
        frame.add(cp);
        FrameReader.preLoad();
        if (!noFiles) {
            TextArea choose = new TextArea(20, 20, 200, 25, "choose a file", cp, Util.getFont(18));
            this.comboBox.setBounds(20, 50, 150, 30);
            this.comboBox.setModel(new DefaultComboBoxModel<String>(fileNames));
            this.comboBox.setBackground(new Color(75, 75, 75));
            this.comboBox.setForeground(new Color(35, 35, 35));
            this.comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    frame.getContentPane().removeAll();
                    new FrameReader(FrameReader.this.comboBox.getSelectedIndex());
                }
            });
            cp.add(this.comboBox);
            TextArea showFileName = new TextArea(20, 100, 340, 25, "file name: " + fileNames[id], cp, Util.getFont(18));
            TextArea showStructureName = new TextArea(20, 130, 340, 25, "structure name: " + structureNames[id], cp, Util.getFont(18));
            TextArea showCreatorName = new TextArea(20, 160, 340, 25, "creator name: " + creatorNames[id], cp, Util.getFont(18));
            TextArea showBuildDate = new TextArea(20, 190, 340, 25, "build at: " + dates[id], cp, Util.getFont(18));
            TextArea showBlockQuantities = new TextArea(20, 220, 340, 25, blockQuantities[id] + " blocks", cp, Util.getFont(18));
            if (picturesSrc[id] != null) {
                Picture picture = new Picture(380, 20, picturesSrc[id], cp);
            }
            bid = id;
            TextArea textCanFlatten = new TextArea(20, 250, 165, 30, "don't flatten the area", cp, Util.getFont(18));
            this.checkBox.setSelected(true);
            this.checkBox.setBounds(185, 250, 25, 25);
            this.checkBox.setText("");
            this.checkBox.setBorderPainted(false);
            this.checkBox.setForeground(Util.getColorDark());
            this.checkBox.setBackground(Util.getColorMedium());
            this.checkBox.setOpaque(false);
            this.checkBox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    ItemReader.setFlatten(FrameReader.this.checkBox.isSelected());
                }
            });
            cp.add(this.checkBox);
            Button enter = new Button(20, 485, 130, 35, "place", "starts scanning", cp, Util.getFont(19), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FrameUtil.setFileName(fileNames[bid]);
                    ItemReader.read();
                    frame.getContentPane().removeAll();
                    frame.dispose();
                }
            });
        } else {
            TextArea download = new TextArea(20, 30, 400, 25, "Download files or scan your own ones!", cp, Util.getFont(20));
        }
        frame.setVisible(true);
    }

    public static void Close() {
        frame.getContentPane().removeAll();
        frame.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preLoad() {
        int i;
        file = new File(FrameUtil.getPath());
        fileArray = file.listFiles();
        int tmp = 0;
        for (i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().endsWith(".ism-structure")) continue;
            ++tmp;
        }
        if (tmp > 0) {
            selectedFiles = new File[tmp];
            fileNames = new String[tmp];
            structureNames = new String[tmp];
            creatorNames = new String[tmp];
            dates = new String[tmp];
            blockQuantities = new String[tmp];
            picturesSrc = new String[tmp];
        } else {
            noFiles = true;
            System.out.println("else");
        }
        tmp = 0;
        for (i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().endsWith(".ism-structure")) continue;
            FrameReader.selectedFiles[tmp] = fileArray[i];
            FrameReader.fileNames[tmp] = fileArray[i].getName().substring(0, fileArray[i].getName().length() - 14);
            try {
                WriterUtil.decryptFile(fileNames[tmp]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File structureFile = FrameUtil.getFile(fileNames[tmp]);
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(structureFile));
                String line = null;
                boolean cancel = false;
                while ((line = br.readLine()) != null && !cancel) {
                    String[] parts = line.split(";");
                    if (parts[0].equals("i")) {
                        if (parts[1].equals("date")) {
                            FrameReader.dates[tmp] = parts[2];
                            continue;
                        }
                        if (parts[1].equals("creatorName")) {
                            FrameReader.creatorNames[tmp] = parts[2];
                            continue;
                        }
                        if (parts[1].equals("structureName")) {
                            FrameReader.structureNames[tmp] = parts[2];
                            continue;
                        }
                        if (parts[1].equals("blockQuantity")) {
                            FrameReader.blockQuantities[tmp] = parts[2];
                            continue;
                        }
                        if (!parts[1].equals("picSrc") || parts.length != 3) continue;
                        FrameReader.picturesSrc[tmp] = parts[2];
                        continue;
                    }
                    cancel = true;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            WriterUtil.deleteTmpFile(fileNames[tmp]);
            ++tmp;
        }
    }

    static {
        noFiles = false;
    }
}

