/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.interfaces;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.container.ContainerPlayerDetector;
import com.brandon3055.draconicevolution.common.core.network.PlayerDetectorButtonPacket;
import com.brandon3055.draconicevolution.common.core.network.PlayerDetectorStringPacket;
import com.brandon3055.draconicevolution.common.tileentities.TilePlayerDetectorAdvanced;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GUIPlayerDetector
extends GuiContainer {
    public EntityPlayer player;
    private TilePlayerDetectorAdvanced detector;
    public boolean showInvSlots = true;
    private boolean editMode = false;
    private int range = 0;
    private int maxRange = 20;
    private boolean whitelist = false;
    private boolean initScedualed = false;
    private int initTick = 0;
    private String[] names = new String[42];
    private GuiTextField selectedNameText;
    private int selected = -1;
    private boolean outputInverted = false;
    private static final ResourceLocation texture = new ResourceLocation("DraconicEvolution".toLowerCase(), "textures/gui/PlayerDetector.png");

    public GUIPlayerDetector(InventoryPlayer invPlayer, TilePlayerDetectorAdvanced detector) {
        super(detector.getGuiContainer(invPlayer));
        this.field_147002_h = new ContainerPlayerDetector(invPlayer, detector, this);
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i] = "";
        }
        this.field_146999_f = 176;
        this.field_147000_g = 198;
        this.detector = detector;
        this.player = invPlayer.field_70458_d;
        this.syncWithServer();
    }

    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.editMode) {
            this.func_73729_b(this.field_147003_i + 3, this.field_147009_r + this.field_147000_g / 2, 3, 3, this.field_146999_f - 6, this.field_147000_g / 2 - 3);
            this.drawNameChart(x, y);
        }
        if (this.showInvSlots) {
            this.func_73729_b(this.field_147003_i + 142, this.field_147009_r + 19, this.field_146999_f, 0, 23, 41);
        }
    }

    protected void func_146979_b(int x, int y) {
        this.drawGuiText(x, y);
    }

    public void func_73863_a(int x, int y, float p_73863_3_) {
        super.func_73863_a(x, y, p_73863_3_);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Camouflage");
        if (x - this.field_147003_i > 142 && x - this.field_147003_i < 160 && y - this.field_147009_r > 19 && y - this.field_147009_r < 37 && this.showInvSlots) {
            this.drawHoveringText(lines, x, y, this.field_146289_q);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        if (!this.editMode) {
            String wt = this.whitelist ? "White List" : "Black List";
            int centre = this.field_146294_l / 2;
            this.field_146292_n.add(new GuiButton(0, centre - 20 - 20, this.field_147009_r + 20, 20, 20, "+"));
            this.field_146292_n.add(new GuiButton(1, centre + 20, this.field_147009_r + 20, 20, 20, "-"));
            this.field_146292_n.add(new GuiButton(3, centre - 40, this.field_147009_r + 45, 60, 20, wt));
            this.field_146292_n.add(new GuiButton(4, centre + 20, this.field_147009_r + 45, 20, 20, "!"));
            this.field_146292_n.add(new GuiButton(6, centre - 40, this.field_147009_r + 70, 80, 20, "Invert Output"));
        } else {
            this.field_146292_n.add(new GuiButton(5, this.field_147003_i - 40, this.field_147009_r + this.field_147000_g - 20, 40, 20, "Back"));
        }
        this.selectedNameText = new GuiTextField(this.field_146289_q, 4, -12, 168, 12);
        this.selectedNameText.func_146193_g(-1);
        this.selectedNameText.func_146204_h(-1);
        this.selectedNameText.func_146185_a(true);
        this.selectedNameText.func_146203_f(40);
        this.selectedNameText.func_146189_e(this.editMode);
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.range = this.range < this.maxRange ? this.range + 1 : this.maxRange;
                DraconicEvolution.channelHandler.sendToServer(new PlayerDetectorButtonPacket(0, (byte)this.range));
                break;
            }
            case 1: {
                this.range = this.range > 1 ? this.range - 1 : 1;
                DraconicEvolution.channelHandler.sendToServer(new PlayerDetectorButtonPacket(0, (byte)this.range));
                break;
            }
            case 3: {
                this.initScedualed = true;
                this.editMode = true;
                this.showInvSlots = false;
                ((ContainerPlayerDetector)this.field_147002_h).updateContainerSlots();
                break;
            }
            case 4: {
                this.whitelist = !this.whitelist;
                this.initScedualed = true;
                byte val = (byte)(this.whitelist ? 1 : 0);
                DraconicEvolution.channelHandler.sendToServer(new PlayerDetectorButtonPacket(1, val));
                break;
            }
            case 5: {
                this.editMode = false;
                this.showInvSlots = true;
                ((ContainerPlayerDetector)this.field_147002_h).updateContainerSlots();
                this.initScedualed = true;
                break;
            }
            case 6: {
                this.outputInverted = !this.outputInverted;
                this.initScedualed = true;
                byte val2 = (byte)(this.outputInverted ? 1 : 0);
                DraconicEvolution.channelHandler.sendToServer(new PlayerDetectorButtonPacket(2, val2));
            }
        }
    }

    protected void func_73869_a(char par1, int par2) {
        if (this.selectedNameText.func_146201_a(par1, par2)) {
            return;
        }
        if (par2 == 28) {
            if (this.selectedNameText.func_146206_l()) {
                this.names[this.selected] = this.selectedNameText.func_146179_b();
                this.selectedNameText.func_146180_a("");
                this.selectedNameText.func_146195_b(false);
                DraconicEvolution.channelHandler.sendToServer(new PlayerDetectorStringPacket((byte)this.selected, this.names[this.selected]));
                this.selected = -1;
            }
        } else {
            super.func_73869_a(par1, par2);
        }
    }

    public void func_73876_c() {
        if (this.initScedualed) {
            ++this.initTick;
        }
        if (this.initTick > 1) {
            this.initTick = 0;
            this.initScedualed = false;
            this.func_73866_w_();
        }
        super.func_73876_c();
    }

    protected void func_73864_a(int x, int y, int par3) {
        super.func_73864_a(x, y, par3);
        if (this.editMode) {
            this.selectName(x - this.field_147003_i, y - this.field_147009_r);
        }
    }

    private void drawGuiText(int rawX, int rawY) {
        if (!this.editMode) {
            this.func_73732_a(this.field_146289_q, "Advanced Player Detector", this.field_146999_f / 2, 5, 65535);
            this.field_146289_q.func_85187_a("Range:", 73, 21, 0, false);
            this.field_146289_q.func_85187_a("Output Inverted: " + String.valueOf(this.outputInverted), 33, 97, 0, false);
            if (this.range < 10) {
                this.field_146289_q.func_85187_a("" + this.range, 85, 31, 0, false);
            } else {
                this.field_146289_q.func_85187_a("" + this.range, 82, 31, 0, false);
            }
        } else {
            if (this.selected != -1) {
                this.func_73732_a(this.field_146289_q, "Press Enter to save", this.field_146999_f / 2, -22, 0xFF0000);
            }
            for (int i = 0; i < 21; ++i) {
                for (int j = 0; j < 2; ++j) {
                    if (i + j * 21 == this.selected) continue;
                    String s = this.names[i + j * 21];
                    if (s.length() > 13) {
                        s = s.substring(0, 13) + "...";
                    }
                    this.field_146289_q.func_78276_b(s, 5 + j * 84, 6 + i * 9, 0x980000);
                }
            }
        }
        this.selectedNameText.func_146194_f();
    }

    private void drawNameChart(int rawX, int rawY) {
        int i;
        int x = rawX - this.field_147003_i;
        int y = rawY - this.field_147009_r;
        for (i = 0; i < 21; ++i) {
            this.func_73729_b(this.field_147003_i + 4, this.field_147009_r + 4 + i * 9, 0, this.field_147000_g, 186, 10);
        }
        for (i = 0; i < 21; ++i) {
            for (int j = 0; j < 2; ++j) {
                if ((x <= 4 + j * 84 || x >= this.field_146999_f / 2 - 1 + j * 82 || y <= 4 + i * 9 || y >= 13 + i * 9) && i + j * 21 != this.selected) continue;
                this.func_73729_b(this.field_147003_i + 5 + j * 84, this.field_147009_r + 5 + i * 9, 0, this.field_147000_g + 10, 82, 8);
            }
        }
    }

    public void selectName(int x, int y) {
        if (this.initScedualed) {
            return;
        }
        for (int i = 0; i < 21; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (x <= 4 + j * 84 || x >= this.field_146999_f / 2 - 1 + j * 82 || y <= 4 + i * 9 || y >= 13 + i * 9) continue;
                this.selected = i + j * 21;
                this.selectedNameText.func_146180_a(this.names[i + j * 21]);
                this.selectedNameText.func_146195_b(true);
            }
        }
    }

    private void syncWithServer() {
        this.whitelist = this.detector.whiteList;
        for (int i = 0; i < this.detector.names.length; ++i) {
            if (this.detector.names[i] == null) continue;
            this.names[i] = this.detector.names[i];
        }
        this.range = this.detector.range;
        this.outputInverted = this.detector.outputInverted;
    }
}

