/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.interfaces;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.core.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.core.network.TeleporterPacket;
import com.brandon3055.draconicevolution.common.core.network.TeleporterStringPacket;
import com.brandon3055.draconicevolution.common.core.utills.ItemNBTHelper;
import com.brandon3055.draconicevolution.common.items.ModItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GUITeleporter
extends GuiScreen {
    private final int xSize = 160;
    private final int ySize = 138;
    private ResourceLocation guiTexture = new ResourceLocation("DraconicEvolution".toLowerCase(), "textures/gui/TeleporterMKII.png");
    private ItemStack teleporterItem;
    private double[] dPosX = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
    private double[] dPosY = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
    private double[] dPosZ = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
    private int[] dPosD = new int[]{0, 0, 0, 0, 0};
    private float[] dYaw = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private float[] dPitch = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private boolean[] dSet = new boolean[]{false, false, false, false, false};
    private int selected = 0;
    private int fuel = 0;
    private boolean editing = false;
    private EntityPlayer player;
    String[] destText = new String[]{"", "", "", "", ""};
    String[] destValue = new String[]{"[Unset]", "[Unset]", "[Unset]", "[Unset]", "[Unset]"};

    public GUITeleporter(EntityPlayer player) {
        this.player = player;
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77969_a(new ItemStack((Item)ModItems.teleporterMKII))) {
            this.teleporterItem = player.func_71045_bC();
            this.updatePositions(this.teleporterItem);
            this.updateNames(this.teleporterItem);
        }
    }

    public void func_73863_a(int x, int y, float f) {
        int i;
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.guiTexture);
        int posX = (this.field_146294_l - 160) / 2;
        int posY = (this.field_146295_m - 138) / 2;
        this.func_73729_b(posX, posY, 0, 0, 160, 138);
        this.func_73729_b(posX + 3, posY + 3 + this.selected * 23, 0, 138, 67, 10);
        for (i = 0; i < 5; ++i) {
            if (x <= posX + 2 || x >= posX + 70 || y <= posY + 2 + i * 23 || y >= posY + 14 + i * 23) continue;
            if (!this.editing) {
                this.func_73729_b(posX + 3, posY + 3 + i * 23, 0, 138, 67, 10);
            }
            if (i == this.selected && !this.editing) {
                this.func_73729_b(posX, posY - 10, 0, 148, 30, 10);
                this.func_73729_b(posX + 15, posY - 10, 40, 148, 30, 10);
                this.field_146289_q.func_85187_a("Rename", posX + 3, posY - 9, 0xFFFFFF, false);
                continue;
            }
            if (this.editing) continue;
            this.func_73729_b(posX, posY - 10, 0, 148, 30, 10);
            this.func_73729_b(posX + 10, posY - 10, 40, 148, 30, 10);
            this.field_146289_q.func_85187_a("Select", posX + 3, posY - 9, 0xFFFFFF, false);
        }
        if (this.editing) {
            this.func_73729_b(posX, posY - 10, 0, 148, 60, 10);
            this.func_73729_b(posX + 60, posY - 10, 18, 148, 60, 10);
            this.field_146289_q.func_85187_a("Press Enter to save", posX + 3, posY - 9, 0xFFFFFF, false);
        }
        for (i = 0; i < 5; ++i) {
            if (this.dSet[i]) {
                this.destValue[i] = "X:" + (int)this.dPosX[0] + " Y:" + (int)this.dPosY[0] + " Z:" + (int)this.dPosZ[0];
            }
            if (this.editing && i == this.selected) {
                this.field_146289_q.func_78276_b(EnumChatFormatting.UNDERLINE + this.destText[i], posX + 5, posY + 5 + i * 23, 0xFF0000);
            } else {
                this.field_146289_q.func_78276_b(this.destText[i], posX + 5, posY + 5 + i * 23, 0);
            }
            this.field_146289_q.func_78276_b(this.dSet[i] ? EnumChatFormatting.DARK_BLUE + WorldProvider.func_76570_a((int)this.dPosD[i]).func_80007_l() : EnumChatFormatting.DARK_RED + "[Unset]", posX + 73, posY + 5 + i * 23, 0);
            this.field_146289_q.func_78276_b("X:" + String.valueOf((int)this.dPosX[i]), posX + 4, posY + 16 + i * 23, 45056);
            this.field_146289_q.func_78276_b("Y:" + String.valueOf((int)this.dPosY[i]), posX + 50, posY + 16 + i * 23, 45056);
            this.field_146289_q.func_78276_b("Z:" + String.valueOf((int)this.dPosZ[i]), posX + 96, posY + 16 + i * 23, 45056);
        }
        this.field_146289_q.func_78276_b("Charges: " + this.fuel, posX + 5, posY + 120, 0);
        super.func_73863_a(x, y, f);
        if (this.player.func_71045_bC() == null || !this.player.func_71045_bC().func_77969_a(new ItemStack((Item)ModItems.teleporterMKII)) || this.player.field_70128_L) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        int posX = (this.field_146294_l - 160) / 2;
        int posY = (this.field_146295_m - 138) / 2;
        for (int i = 0; i < 5; ++i) {
            if (x <= posX + 2 || x >= posX + 70 || y <= posY + 2 + i * 23 || y >= posY + 14 + i * 23) continue;
            if (this.selected != i && !this.editing) {
                this.selected = i;
                if (this.player.func_71045_bC() != null && this.player.func_71045_bC().func_77969_a(new ItemStack((Item)ModItems.teleporterMKII))) {
                    ItemNBTHelper.setShort(this.player.func_71045_bC(), "Selection", (short)this.selected);
                }
                DraconicEvolution.channelHandler.sendToServer(new TeleporterPacket(0, this.selected));
                this.func_73866_w_();
                continue;
            }
            if (this.editing) continue;
            this.editing = true;
        }
        super.func_73864_a(x, y, button);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        int posX = (this.field_146294_l - 160) / 2;
        int posY = (this.field_146295_m - 138) / 2;
        this.updateTeleporter();
        this.field_146292_n.add(new GuiButton(this.selected, posX - 25, posY + 3 + this.selected * 23, 25, 20, "Set"));
        this.field_146292_n.add(new GuiButton(5, posX + 109, posY + 117, 50, 20, "Add Fuel"));
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        for (int i = 0; i < 5; ++i) {
            if (i != button.field_146127_k) continue;
            double playerX = this.player.field_70165_t;
            double playerY = this.player.field_70163_u - 1.61;
            double playerZ = this.player.field_70161_v;
            float yaw = this.player.field_70177_z;
            float pitch = this.player.field_70125_A;
            int dim = this.player.field_71093_bK;
            this.dPosX[i] = playerX;
            this.dPosY[i] = playerY;
            this.dPosZ[i] = playerZ;
            this.dPosD[i] = dim;
            this.dSet[i] = true;
            DraconicEvolution.channelHandler.sendToServer(new TeleporterPacket(1, i, dim, playerX, playerY, playerZ, yaw, pitch));
        }
        if (button.field_146127_k == 5) {
            if (this.player.field_71071_by.func_146028_b(Items.field_151079_bi)) {
                if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
                    DraconicEvolution.channelHandler.sendToServer(new TeleporterPacket(6, 1));
                    this.fuel += ConfigHandler.teleporterUsesPerPearl;
                } else if (this.hasPearls(16)) {
                    DraconicEvolution.channelHandler.sendToServer(new TeleporterPacket(6, 16));
                    this.fuel += ConfigHandler.teleporterUsesPerPearl * 16;
                } else {
                    this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.teleporterOutOfPearls.txt", new Object[0]));
                }
            } else {
                this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.teleporterOutOfPearls.txt", new Object[0]));
            }
        }
    }

    public boolean hasPearls(int number) {
        int found = 0;
        for (int i = 0; i < this.player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = this.player.field_71071_by.func_70301_a(i);
            if (stack != null && stack.func_77969_a(new ItemStack(Items.field_151079_bi))) {
                found += stack.field_77994_a;
            }
            if (found < number) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_73869_a(char key, int keyN) {
        if (key == 'e' && !this.editing || key == '\u001b') {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        }
        if (!this.editing) return;
        String text = this.destText[this.selected];
        if (keyN == 14) {
            if (text.length() <= 0) return;
            this.destText[this.selected] = text.substring(0, text.length() - 1);
        } else if (keyN == 28) {
            this.editing = false;
            DraconicEvolution.channelHandler.sendToServer(new TeleporterStringPacket(this.selected, this.destText[this.selected]));
        } else {
            if (keyN == 42) {
                return;
            }
            if (this.destText[this.selected].length() < 13) {
                int n = this.selected;
                this.destText[n] = this.destText[n] + key;
            }
        }
        this.func_73866_w_();
    }

    public void func_73876_c() {
    }

    public boolean func_73868_f() {
        return false;
    }

    private void updatePositions(ItemStack teleporter) {
        int i;
        for (i = 0; i < 5; ++i) {
            this.dPosX[i] = ItemNBTHelper.getDouble(teleporter, "X_" + i, -1.0);
        }
        for (i = 0; i < 5; ++i) {
            this.dPosY[i] = ItemNBTHelper.getDouble(teleporter, "Y_" + i, -1.0);
        }
        for (i = 0; i < 5; ++i) {
            this.dPosZ[i] = ItemNBTHelper.getDouble(teleporter, "Z_" + i, -1.0);
        }
        for (i = 0; i < 5; ++i) {
            this.dPosD[i] = ItemNBTHelper.getIntager(teleporter, "Dimension_" + i, 0);
        }
        for (i = 0; i < 5; ++i) {
            this.dYaw[i] = ItemNBTHelper.getFloat(teleporter, "Yaw_" + i, 0.0f);
        }
        for (i = 0; i < 5; ++i) {
            this.dPitch[i] = ItemNBTHelper.getFloat(teleporter, "Pitch_" + i, 0.0f);
        }
        for (i = 0; i < 5; ++i) {
            this.dSet[i] = ItemNBTHelper.getBoolean(teleporter, "IsSet_" + i, false);
        }
        this.selected = ItemNBTHelper.getShort(teleporter, "Selection", (short)0);
        this.fuel = ItemNBTHelper.getIntager(teleporter, "Fuel", 0);
    }

    public void updateNames(ItemStack teleporter) {
        for (int i = 0; i < 5; ++i) {
            this.destText[i] = ItemNBTHelper.getString(teleporter, "Dest_" + i, "Destination " + i);
        }
    }

    public void updateTeleporter() {
        if (this.player.func_71045_bC() != null && this.player.func_71045_bC().func_77969_a(new ItemStack((Item)ModItems.teleporterMKII))) {
            this.teleporterItem = this.player.func_71045_bC();
            this.updatePositions(this.teleporterItem);
        }
    }
}

