/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.interfaces.manual;

import com.brandon3055.draconicevolution.client.interfaces.manual.PageCollection;
import com.brandon3055.draconicevolution.client.interfaces.manual.TitledPage;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.lwjgl.opengl.GL11;

public class CraftingInfoPage
extends TitledPage {
    protected static RenderItem itemRenderer = new RenderItem();
    public ItemStack result;
    private boolean isSmelting = false;
    private ItemStack[] recipe = new ItemStack[9];
    private boolean hasRecipe = false;
    private String rawDescription;
    private List<String> formattedDescription;
    private float descriptionScale = 0.66f;

    public CraftingInfoPage(String name, PageCollection collection, ItemStack itemStack, String unlocalizedDescription) {
        super(name, true, collection, itemStack.func_77977_a() + ".name", 65280);
        this.result = itemStack;
        for (ItemStack stack : this.recipe = this.getFirstRecipeForItem(itemStack)) {
            if (stack == null) continue;
            this.hasRecipe = true;
        }
        this.rawDescription = unlocalizedDescription == "" ? this.ttl(itemStack.func_77977_a() + ".description") : this.ttl(unlocalizedDescription);
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.renderBackgroundLayer(minecraft, offsetX, offsetY, mouseX, mouseY);
        GL11.glPushMatrix();
        if (this.isSmelting) {
            this.func_73729_b(offsetX + 87, offsetY + 15, 116, 202, 82, 54);
        } else {
            this.func_73729_b(offsetX + 70, offsetY + 15, 0, 202, 116, 54);
            if (!this.hasRecipe) {
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glBlendFunc((int)770, (int)771);
                this.func_73729_b(offsetX + 70, offsetY + 15, 198, 202, 54, 54);
                GL11.glPopMatrix();
                this.func_73731_b(this.field_146289_q, "No Crafting Recipe", offsetX + 129, offsetY + 60, 0xFF0000);
            }
        }
        GL11.glPopMatrix();
    }

    @Override
    public void drawScreen(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawScreen(minecraft, offsetX, offsetY, mouseX, mouseY);
        int relativeMouseX = mouseX + offsetX;
        int relativeMouseY = mouseY + offsetY;
        int gridOffsetX = this.isSmelting ? 88 : 71;
        int gridOffsetY = 16;
        int itemBoxSize = 18;
        this.addDescription(minecraft, offsetX, offsetY);
        ItemStack tooltip = null;
        int i = 0;
        for (ItemStack input : this.recipe) {
            if (input != null) {
                int row = i % 3;
                int column = i / 3;
                int itemX = offsetX + gridOffsetX + row * itemBoxSize;
                int itemY = offsetY + gridOffsetY + column * itemBoxSize;
                this.drawItemStack(input, itemX, itemY, "");
                if (relativeMouseX > itemX - 2 && relativeMouseX < itemX - 2 + itemBoxSize && relativeMouseY > itemY - 2 && relativeMouseY < itemY - 2 + itemBoxSize) {
                    tooltip = input;
                }
            }
            ++i;
        }
        int itemX = offsetX + (this.isSmelting ? 148 : 165);
        int itemY = offsetY + 34;
        this.drawItemStack(this.result, itemX, itemY, "");
        if (relativeMouseX > itemX - 2 && relativeMouseX < itemX - 2 + itemBoxSize && relativeMouseY > itemY - 2 && relativeMouseY < itemY - 2 + itemBoxSize) {
            tooltip = this.result;
        }
        if (tooltip != null) {
            this.drawItemStackTooltip(tooltip, relativeMouseX, relativeMouseY);
        }
    }

    public void addDescription(Minecraft minecraft, int offsetX, int offsetY) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offsetX + 5), (double)(offsetY + 75), (double)1.0);
        GL11.glScalef((float)this.descriptionScale, (float)this.descriptionScale, (float)this.descriptionScale);
        int offset = 0;
        for (String s : this.getFormattedText(this.field_146289_q)) {
            if (s == null) break;
            this.field_146289_q.func_78276_b(s, 0, offset, 0x404040);
            offset += this.field_146289_q.field_78288_b;
        }
        GL11.glPopMatrix();
    }

    public List<String> getFormattedText(FontRenderer fr) {
        if (this.formattedDescription == null) {
            this.formattedDescription = Strings.isNullOrEmpty((String)this.rawDescription) ? ImmutableList.of() : ImmutableList.copyOf((Collection)fr.func_78271_c(this.rawDescription, 370));
        }
        return this.formattedDescription;
    }

    protected void drawItemStackTooltip(ItemStack stack, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = (FontRenderer)Objects.firstNonNull((Object)stack.func_77973_b().getFontRenderer(stack), (Object)mc.field_71466_p);
        List list = stack.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
        ArrayList colored = Lists.newArrayListWithCapacity((int)list.size());
        colored.add(stack.func_77953_t().field_77937_e + (String)list.get(0));
        for (String line : list) {
            colored.add(EnumChatFormatting.GRAY + line);
        }
        if (colored.size() >= 2) {
            colored.remove(1);
        }
        this.drawHoveringText(colored, x, y, font);
    }

    private void drawItemStack(ItemStack par1ItemStack, int par2, int par3, String par4Str) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        CraftingInfoPage.itemRenderer.field_77023_b = 200.0f;
        RenderHelper.func_74520_c();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2977);
        FontRenderer font = null;
        if (par1ItemStack != null) {
            font = par1ItemStack.func_77973_b().getFontRenderer(par1ItemStack);
        }
        if (font == null) {
            font = Minecraft.func_71410_x().field_71466_p;
        }
        itemRenderer.func_82406_b(font, Minecraft.func_71410_x().func_110434_K(), par1ItemStack, par2, par3);
        itemRenderer.func_94148_a(font, Minecraft.func_71410_x().func_110434_K(), par1ItemStack, par2, par3, par4Str);
        this.field_73735_i = 0.0f;
        CraftingInfoPage.itemRenderer.field_77023_b = 0.0f;
    }

    private ItemStack[] getFirstRecipeForItem(ItemStack resultingItem) {
        ItemStack[] recipeItems = new ItemStack[9];
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            Object[] input;
            ItemStack result;
            if (recipe == null || (result = recipe.func_77571_b()) == null || !result.func_77969_a(resultingItem) || (input = this.getRecipeInput(recipe)) == null) continue;
            for (int i = 0; i < input.length; ++i) {
                recipeItems[i] = this.convertToStack(input[i]);
            }
        }
        for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            if (!(entry.getKey() instanceof ItemStack) || !((ItemStack)entry.getValue()).func_77969_a(this.result)) continue;
            this.isSmelting = true;
            recipeItems[0] = (ItemStack)entry.getKey();
        }
        return recipeItems;
    }

    protected ItemStack convertToStack(Object obj) {
        List list;
        ItemStack entry = null;
        if (obj instanceof ItemStack) {
            entry = (ItemStack)obj;
        } else if (obj instanceof List && (list = (List)obj).size() > 0) {
            entry = (ItemStack)list.get(0);
        }
        if (entry == null) {
            return null;
        }
        if ((entry = entry.func_77946_l()).func_77960_j() == Short.MAX_VALUE) {
            entry.func_77964_b(0);
        }
        return entry;
    }

    private Object[] getRecipeInput(IRecipe recipe) {
        if (recipe instanceof ShapelessOreRecipe) {
            return ((ShapelessOreRecipe)recipe).getInput().toArray();
        }
        if (recipe instanceof ShapedOreRecipe) {
            return this.getShapedOreRecipe((ShapedOreRecipe)recipe);
        }
        if (recipe instanceof ShapedRecipes) {
            return ((ShapedRecipes)recipe).field_77574_d;
        }
        if (recipe instanceof ShapelessRecipes) {
            return ((ShapelessRecipes)recipe).field_77579_b.toArray(new ItemStack[0]);
        }
        return null;
    }

    private Object[] getShapedOreRecipe(ShapedOreRecipe recipe) {
        try {
            Field field = ShapedOreRecipe.class.getDeclaredField("width");
            if (field != null) {
                field.setAccessible(true);
                int width = field.getInt(recipe);
                Object[] input = recipe.getInput();
                Object[] grid = new Object[9];
                int i = 0;
                int offset = 0;
                for (int y = 0; y < 3; ++y) {
                    int x = 0;
                    while (x < 3) {
                        if (x < width && offset < input.length) {
                            grid[i] = input[offset];
                            ++offset;
                        } else {
                            grid[i] = null;
                        }
                        ++x;
                        ++i;
                    }
                }
                return grid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

