/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.interfaces.manual;

import com.brandon3055.draconicevolution.client.interfaces.manual.GuiButtonAHeight;
import com.brandon3055.draconicevolution.client.interfaces.manual.PageCollection;
import com.brandon3055.draconicevolution.client.interfaces.manual.TitledPage;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class TutorialPage
extends TitledPage {
    private float descriptionScale = 0.66f;
    public String[] rawDescription;
    public List<String>[] formattedDescription;
    public int page = 0;
    public int lastPage = 0;

    public TutorialPage(String name, PageCollection collection, String title) {
        super(name, true, collection, title, 65280);
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.renderBackgroundLayer(minecraft, offsetX, offsetY, mouseX, mouseY);
        if (this.lastPage == 0) {
            return;
        }
        String s = "page " + this.page + "/" + this.lastPage;
        this.field_146289_q.func_78276_b(s, offsetX + 195, offsetY + 185, 0);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.lastPage == 0) {
            return;
        }
        this.field_146292_n.add(new GuiButtonAHeight(1, this.getXMin() + 62, this.getYMin() + 181, 25, 16, this.ttl("button.de.previous.txt")));
        this.field_146292_n.add(new GuiButtonAHeight(2, this.getXMin() + 170, this.getYMin() + 181, 25, 16, this.ttl("button.de.next.txt")));
        if (this.field_146292_n.get(1) instanceof GuiButton) {
            boolean bl = ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = this.page != 0;
        }
        if (this.field_146292_n.get(2) instanceof GuiButton) {
            ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = this.page != this.lastPage;
        }
    }

    @Override
    public void drawScreen(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawScreen(minecraft, offsetX, offsetY, mouseX, mouseY);
    }

    public void addDescription(Minecraft minecraft, int offsetX, int offsetY, List<String> description) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offsetX + 5), (double)(offsetY + 75), (double)1.0);
        GL11.glScalef((float)this.descriptionScale, (float)this.descriptionScale, (float)this.descriptionScale);
        int offset = 0;
        for (String s : description) {
            if (s == null) break;
            this.field_146289_q.func_78276_b(s, 0, offset, 0x404040);
            offset += this.field_146289_q.field_78288_b;
        }
        GL11.glPopMatrix();
    }

    public List<String> getFormattedText(FontRenderer fr, String raw, int descriptionIndex) {
        if (this.formattedDescription[descriptionIndex] == null) {
            this.formattedDescription[descriptionIndex] = Strings.isNullOrEmpty((String)raw) ? ImmutableList.of() : ImmutableList.copyOf((Collection)fr.func_78271_c(raw, 370));
            ArrayList<String> modified = new ArrayList<String>();
            for (int i = 0; i < this.formattedDescription[descriptionIndex].size(); ++i) {
                String line = this.formattedDescription[descriptionIndex].get(i);
                if (!line.contains("/n")) {
                    modified.add(line);
                    continue;
                }
                String joinedLine = "";
                while (i < this.formattedDescription[descriptionIndex].size()) {
                    joinedLine = joinedLine + this.formattedDescription[descriptionIndex].get(i);
                    ++i;
                }
                for (int escape = 0; !joinedLine.isEmpty() && escape < 20; ++escape) {
                    int index = 0;
                    index = joinedLine.contains("/n") ? joinedLine.indexOf("/n") : joinedLine.length();
                    String s = joinedLine.substring(0, index);
                    modified.add(s);
                    joinedLine = joinedLine.substring(index);
                    joinedLine = joinedLine.replaceFirst("/n", "");
                }
                break;
            }
            this.formattedDescription[descriptionIndex] = modified;
        }
        return this.formattedDescription[descriptionIndex];
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (this.lastPage == 0) {
            return;
        }
        if (button.field_146127_k == 1) {
            this.page = Math.max(0, this.page - 1);
        }
        if (button.field_146127_k == 2) {
            this.page = Math.min(this.lastPage, this.page + 1);
        }
        if (this.field_146292_n.get(1) instanceof GuiButton) {
            boolean bl = ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = this.page != 0;
        }
        if (this.field_146292_n.get(2) instanceof GuiButton) {
            ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = this.page != this.lastPage;
        }
    }
}

