/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.blocks;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.blocks.BlockDE;
import com.brandon3055.draconicevolution.common.blocks.ModBlocks;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.tileentities.TilePotentiometer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Potentiometer
extends BlockDE {
    IIcon[] icons = new IIcon[16];

    protected Potentiometer() {
        super(Material.field_151594_q);
        this.func_149647_a(DraconicEvolution.tolkienTabBlocksItems);
        this.func_149711_c(0.3f);
        this.func_149752_b(0.1f);
        this.func_149715_a(0.3f);
        this.func_149663_c("potentiometer");
        ModBlocks.register(this);
    }

    public boolean func_149686_d() {
        return false;
    }

    public AxisAlignedBB func_149668_a(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        return null;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TilePotentiometer();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        for (int i = 0; i < 16; ++i) {
            this.icons[i] = iconRegister.func_94245_a(References.RESOURCESPREFIX + "potentiometer/potentiometer_" + i);
        }
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TilePotentiometer) {
            return this.icons[((TilePotentiometer)tile).power];
        }
        return null;
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.icons[0];
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.isSideSolid(x, y + 1, z, ForgeDirection.UP) || world.isSideSolid(x, y - 1, z, ForgeDirection.DOWN) || world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) || world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int l = world.func_72805_g(x, y, z);
        this.setBounds(l);
    }

    private void setBounds(int meta) {
        int j = meta;
        float f = 0.206f;
        float f1 = 0.796f;
        float f2 = 0.296f;
        float f3 = 0.125f;
        if (j == 6) {
            this.func_149676_a(0.5f - f2, 0.0f, 0.5f - f2, 0.5f + f2, f3, 0.5f + f2);
        }
        if (j == 1) {
            this.func_149676_a(0.0f, f, 0.5f - f2, f3, f1, 0.5f + f2);
        } else if (j == 2) {
            this.func_149676_a(1.0f - f3, f, 0.5f - f2, 1.0f, f1, 0.5f + f2);
        } else if (j == 3) {
            this.func_149676_a(0.5f - f2, f, 0.0f, 0.5f + f2, f1, f3);
        } else if (j == 4) {
            this.func_149676_a(0.5f - f2, f, 1.0f - f3, 0.5f + f2, f1, 1.0f);
        }
        if (j == 5) {
            this.func_149676_a(0.5f - f2, 1.0f - f3, 0.5f - f2, 0.5f + f2, 1.0f, 0.5f + f2);
        }
    }

    public void func_149683_g() {
        float f = 0.206f;
        float f1 = 0.796f;
        float f2 = 0.296f;
        float f3 = 0.125f;
        this.func_149676_a(0.5f - f2, f, 0.3f, 0.5f + f2, f1, f3 + 0.3f);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float p_149660_6_, float p_149660_7_, float p_149660_8_, int p_149660_9_) {
        int j1 = world.func_72805_g(x, y, z);
        int k1 = j1 & 8;
        j1 &= 7;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        j1 = dir == ForgeDirection.NORTH && world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) ? 4 : (dir == ForgeDirection.SOUTH && world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) ? 3 : (dir == ForgeDirection.WEST && world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) ? 2 : (dir == ForgeDirection.EAST && world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) ? 1 : (dir == ForgeDirection.UP && world.isSideSolid(x, y - 1, z, ForgeDirection.UP) ? 6 : (dir == ForgeDirection.DOWN && world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN) ? 5 : this.fundSolidSide(world, x, y, z))))));
        return j1 + k1;
    }

    private int fundSolidSide(World world, int x, int y, int z) {
        if (world.isSideSolid(x, y - 1, z, ForgeDirection.UP)) {
            return 6;
        }
        if (world.isSideSolid(x - 1, y, z, ForgeDirection.EAST)) {
            return 1;
        }
        if (world.isSideSolid(x + 1, y, z, ForgeDirection.WEST)) {
            return 2;
        }
        if (world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH)) {
            return 3;
        }
        if (world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH)) {
            return 4;
        }
        if (world.isSideSolid(x, y + 1, z, ForgeDirection.UP)) {
            return 5;
        }
        return 1;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (this.isLocationStillValid(world, x, y, z)) {
            int l = world.func_72805_g(x, y, z) & 7;
            boolean flag = false;
            if (!world.isSideSolid(x, y - 1, z, ForgeDirection.UP) && l == 6) {
                flag = true;
            }
            if (!world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) && l == 1) {
                flag = true;
            }
            if (!world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) && l == 2) {
                flag = true;
            }
            if (!world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) && l == 3) {
                flag = true;
            }
            if (!world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) && l == 4) {
                flag = true;
            }
            if (!world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN) && l == 5) {
                flag = true;
            }
            if (flag) {
                this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                world.func_147468_f(x, y, z);
            }
        }
    }

    private boolean isLocationStillValid(World world, int x, int y, int z) {
        if (!this.func_149742_c(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            return false;
        }
        return true;
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (meta > 0) {
            int i1 = meta;
            this.updateBlocks(world, x, y, z, i1);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    private void updateBlocks(World world, int x, int y, int z, int meta) {
        world.func_147459_d(x, y, z, (Block)this);
        if (meta == 1) {
            world.func_147459_d(x - 1, y, z, (Block)this);
        } else if (meta == 2) {
            world.func_147459_d(x + 1, y, z, (Block)this);
        } else if (meta == 3) {
            world.func_147459_d(x, y, z - 1, (Block)this);
        } else if (meta == 4) {
            world.func_147459_d(x, y, z + 1, (Block)this);
        } else if (meta == 5) {
            world.func_147459_d(x, y + 1, z, (Block)this);
        } else if (meta == 6) {
            world.func_147459_d(x, y - 1, z, (Block)this);
        } else {
            world.func_147459_d(x, y - 1, z, (Block)this);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        TilePotentiometer tile = (TilePotentiometer)world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TilePotentiometer) {
            if (!player.func_70093_af()) {
                tile.increasePower();
            } else {
                tile.decreasePower();
            }
            if (world.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText(String.valueOf(tile.power)));
            }
            world.func_147458_c(x, y, z, x, y, z);
        } else {
            System.out.println("Invalid tile");
        }
        return true;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TilePotentiometer) {
            return ((TilePotentiometer)tile).power;
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TilePotentiometer) {
            return ((TilePotentiometer)tile).power;
        }
        return 0;
    }
}

