/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.blocks.machine;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.blocks.BlockContainerDE;
import com.brandon3055.draconicevolution.common.blocks.ModBlocks;
import com.brandon3055.draconicevolution.common.core.utills.LogHelper;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.tileentities.TileGenerator;
import com.brandon3055.draconicevolution.common.tileentities.TileGrinder;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Generator
extends BlockContainerDE {
    public IIcon icon_front;
    public IIcon icon_side;
    public IIcon icon_back;
    public IIcon icon_back_inactive;
    public IIcon icon_front_inactive;
    public IIcon[] icon_top = new IIcon[4];

    public Generator() {
        super(Material.field_151576_e);
        this.func_149663_c("generator");
        this.func_149647_a(DraconicEvolution.tolkienTabBlocksItems);
        this.func_149672_a(field_149769_e);
        this.func_149711_c(1.0f);
        this.func_149752_b(2000.0f);
        ModBlocks.register(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icon_front = iconRegister.func_94245_a(References.RESOURCESPREFIX + "animated/generator_front_active");
        this.icon_front_inactive = iconRegister.func_94245_a(References.RESOURCESPREFIX + "generator_front");
        this.icon_side = iconRegister.func_94245_a(References.RESOURCESPREFIX + "machine_side");
        this.icon_back = iconRegister.func_94245_a(References.RESOURCESPREFIX + "animated/machine_fan");
        this.icon_back_inactive = iconRegister.func_94245_a(References.RESOURCESPREFIX + "machine_fan");
        for (int i = 0; i < 4; ++i) {
            this.icon_top[i] = iconRegister.func_94245_a(References.RESOURCESPREFIX + "machine_top_" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List par3list) {
        par3list.add(new ItemStack(item, 1, 3));
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileGenerator tile;
        TileGenerator tileGenerator = tile = world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileGenerator ? (TileGenerator)world.func_147438_o(x, y, z) : null;
        if (tile == null) {
            LogHelper.error("Missing Tile Entity (Generator)");
            return 0;
        }
        return tile.burnTimeRemaining > 0 && tile.getEnergyStored(ForgeDirection.UP) < tile.getMaxEnergyStored(ForgeDirection.UP) ? 13 : 0;
    }

    public int func_149692_a(int p_149692_1_) {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        IIcon front;
        IIcon back;
        TileGenerator tile;
        TileGenerator tileGenerator = tile = world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileGenerator ? (TileGenerator)world.func_147438_o(x, y, z) : null;
        if (tile == null) {
            LogHelper.error("Missing Tile Entity (Generator)");
            return null;
        }
        int meta = world.func_72805_g(x, y, z);
        if (tile.burnTimeRemaining > 0 && tile.getEnergyStored(ForgeDirection.UP) < tile.getMaxEnergyStored(ForgeDirection.UP)) {
            back = this.icon_back;
            front = this.icon_front;
        } else {
            back = this.icon_back_inactive;
            front = this.icon_front_inactive;
        }
        switch (side) {
            case 0: {
                return this.icon_side;
            }
            case 1: {
                return this.icon_top[meta];
            }
            case 2: {
                if (meta == 0) {
                    return front;
                }
                if (meta == 2) {
                    return back;
                }
                return this.icon_side;
            }
            case 3: {
                if (meta == 2) {
                    return front;
                }
                if (meta == 0) {
                    return back;
                }
                return this.icon_side;
            }
            case 4: {
                if (meta == 3) {
                    return front;
                }
                if (meta == 1) {
                    return back;
                }
                return this.icon_side;
            }
            case 5: {
                if (meta == 1) {
                    return front;
                }
                if (meta == 3) {
                    return back;
                }
                return this.icon_side;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (side) {
            case 0: {
                return this.icon_side;
            }
            case 1: {
                return this.icon_top[meta];
            }
            case 2: {
                if (meta == 0) {
                    return this.icon_front;
                }
                if (meta == 2) {
                    return this.icon_back;
                }
                return this.icon_side;
            }
            case 3: {
                if (meta == 2) {
                    return this.icon_front;
                }
                if (meta == 0) {
                    return this.icon_back;
                }
                return this.icon_side;
            }
            case 4: {
                if (meta == 3) {
                    return this.icon_front;
                }
                if (meta == 1) {
                    return this.icon_back;
                }
                return this.icon_side;
            }
            case 5: {
                if (meta == 1) {
                    return this.icon_front;
                }
                if (meta == 3) {
                    return this.icon_back;
                }
                return this.icon_side;
            }
        }
        return null;
    }

    @Override
    public TileEntity func_149915_a(World var1, int var2) {
        return new TileGenerator();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float prx, float pry, float prz) {
        if (!world.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)DraconicEvolution.instance, (int)8, (World)world, (int)x, (int)y, (int)z);
        }
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase placer, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            world.func_72921_c(x, y, z, 0, 2);
        }
        if (l == 1) {
            world.func_72921_c(x, y, z, 1, 2);
        }
        if (l == 2) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (l == 3) {
            world.func_72921_c(x, y, z, 3, 2);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileGrinder) {
            ((TileGrinder)tile).disabled = world.func_72864_z(x, y, z);
            world.func_147471_g(x, y, z);
        }
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof IInventory) {
            IInventory inventory = (IInventory)te;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack == null) continue;
                float spawnX = (float)x + world.field_73012_v.nextFloat();
                float spawnY = (float)y + world.field_73012_v.nextFloat();
                float spawnZ = (float)z + world.field_73012_v.nextFloat();
                EntityItem droppedItem = new EntityItem(world, (double)spawnX, (double)spawnY, (double)spawnZ, stack);
                float mult = 0.05f;
                droppedItem.field_70159_w = (-0.5f + world.field_73012_v.nextFloat()) * mult;
                droppedItem.field_70181_x = (4.0f + world.field_73012_v.nextFloat()) * mult;
                droppedItem.field_70179_y = (-0.5f + world.field_73012_v.nextFloat()) * mult;
                world.func_72838_d((Entity)droppedItem);
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileGenerator tile;
        TileGenerator tileGenerator = tile = world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileGenerator ? (TileGenerator)world.func_147438_o(x, y, z) : null;
        if (tile == null) {
            LogHelper.error("Missing Tile Entity (Generator)");
            return;
        }
        if (tile.burnTimeRemaining > 0 && tile.getEnergyStored(ForgeDirection.UP) < tile.getMaxEnergyStored(ForgeDirection.UP)) {
            double ox = 0.0;
            double oz = 0.0;
            if (world.func_72805_g(x, y, z) == 0) {
                oz = -0.5;
            }
            if (world.func_72805_g(x, y, z) == 1) {
                ox = 0.5;
            }
            if (world.func_72805_g(x, y, z) == 2) {
                oz = 0.5;
            }
            if (world.func_72805_g(x, y, z) == 3) {
                ox = -0.5;
            }
            world.func_72869_a("flame", ox + (double)x + 0.5 + (Math.abs(ox) - 0.5) * ((random.nextDouble() - 0.5) * 1.0), (double)y + 0.3 + random.nextDouble() * 0.5, oz + (double)z + 0.5 + (Math.abs(oz) - 0.5) * ((random.nextDouble() - 0.5) * 1.0), ox * 0.05 * random.nextDouble(), (random.nextDouble() - 0.2) * 0.03, oz * 0.05 * random.nextDouble());
            world.func_72869_a("smoke", ox + (double)x + 0.5 + (Math.abs(ox) - 0.5) * ((random.nextDouble() - 0.5) * 1.0), (double)y + 0.3 + random.nextDouble() * 0.5, oz + (double)z + 0.5 + (Math.abs(oz) - 0.5) * ((random.nextDouble() - 0.5) * 1.0), ox * 0.05 * random.nextDouble(), (random.nextDouble() - 0.2) * 0.03, oz * 0.05 * random.nextDouble());
            world.func_72980_b((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "fire.fire", 0.2f + random.nextFloat() * 0.1f, random.nextFloat() * 0.7f + 0.5f, false);
        }
    }
}

