/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.container;

import com.brandon3055.draconicevolution.client.interfaces.GUIPlayerDetector;
import com.brandon3055.draconicevolution.client.interfaces.SlotOpaqueBlock;
import com.brandon3055.draconicevolution.common.tileentities.TilePlayerDetectorAdvanced;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerPlayerDetector
extends Container {
    private TilePlayerDetectorAdvanced tileDetector;
    private GUIPlayerDetector gui = null;

    public ContainerPlayerDetector(InventoryPlayer invPlayer, TilePlayerDetectorAdvanced tileDetector) {
        this.tileDetector = tileDetector;
        this.bindPlayerInventory(invPlayer);
        this.addContainerSlots(tileDetector);
        this.updateContainerSlots();
    }

    public ContainerPlayerDetector(InventoryPlayer invPlayer, TilePlayerDetectorAdvanced tileDetector, GUIPlayerDetector gui) {
        this.tileDetector = tileDetector;
        this.gui = gui;
        this.bindPlayerInventory(invPlayer);
        this.addContainerSlots(tileDetector);
        this.updateContainerSlots();
    }

    private void bindPlayerInventory(InventoryPlayer invPlayer) {
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)invPlayer, x, 8 + 18 * x, 174));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)invPlayer, x + y * 9 + 9, 8 + 18 * x, 116 + y * 18));
            }
        }
    }

    public void addContainerSlots(TilePlayerDetectorAdvanced tileDetector) {
        this.func_75146_a(new SlotOpaqueBlock(tileDetector, 0, 145, 15));
    }

    public void updateContainerSlots() {
        if (this.gui == null) {
            return;
        }
        for (Slot sl : this.field_75151_b) {
            if (sl instanceof SlotOpaqueBlock) {
                if (this.gui.showInvSlots) {
                    sl.field_75223_e = 143;
                    sl.field_75221_f = 20;
                    continue;
                }
                sl.field_75223_e = -1000;
                sl.field_75221_f = -1000;
                continue;
            }
            if (this.gui.showInvSlots) {
                if (sl.field_75222_d < 9) {
                    sl.field_75223_e = 8 + 18 * sl.field_75222_d;
                    sl.field_75221_f = 174;
                    continue;
                }
                if (sl.field_75222_d < 18) {
                    sl.field_75223_e = 8 + 18 * (sl.field_75222_d - 9);
                    sl.field_75221_f = 116;
                    continue;
                }
                if (sl.field_75222_d < 27) {
                    sl.field_75223_e = 8 + 18 * (sl.field_75222_d - 18);
                    sl.field_75221_f = 134;
                    continue;
                }
                if (sl.field_75222_d >= 36) continue;
                sl.field_75223_e = 8 + 18 * (sl.field_75222_d - 27);
                sl.field_75221_f = 152;
                continue;
            }
            sl.field_75223_e = -1000;
            sl.field_75221_f = -1000;
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tileDetector.func_70300_a(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int i) {
        return null;
    }

    public TilePlayerDetectorAdvanced getTileDetector() {
        return this.tileDetector;
    }

    public ItemStack func_75144_a(int slot, int button, int par3, EntityPlayer par4EntityPlayer) {
        return super.func_75144_a(slot, button, par3, par4EntityPlayer);
    }
}

