/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.core.network;

import com.brandon3055.draconicevolution.common.container.ContainerDissEnchanter;
import com.brandon3055.draconicevolution.common.container.ContainerWeatherController;
import com.brandon3055.draconicevolution.common.core.network.IPacket;
import com.brandon3055.draconicevolution.common.tileentities.TileDissEnchanter;
import com.brandon3055.draconicevolution.common.tileentities.TileWeatherController;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.NetHandlerPlayServer;

public class ButtonPacket
implements IPacket {
    byte buttonId = 0;
    boolean state = false;

    public ButtonPacket() {
    }

    public ButtonPacket(byte buttonId, boolean state) {
        this.buttonId = buttonId;
        this.state = state;
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        this.buttonId = bytes.readByte();
        this.state = bytes.readBoolean();
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        bytes.writeByte((int)this.buttonId);
        bytes.writeBoolean(this.state);
    }

    @Override
    public void handleClientSide(NetHandlerPlayClient player) {
    }

    @Override
    public void handleServerSide(NetHandlerPlayServer player) {
        switch (this.buttonId) {
            case 0: {
                Container container = player.field_147369_b.field_71070_bA;
                if (container == null || !(container instanceof ContainerWeatherController)) break;
                TileWeatherController tileWC = ((ContainerWeatherController)container).getTileWC();
                tileWC.reciveButtonEvent(this.buttonId);
                break;
            }
            case 1: {
                Container container = player.field_147369_b.field_71070_bA;
                if (container == null || !(container instanceof ContainerDissEnchanter)) break;
                TileDissEnchanter tile = ((ContainerDissEnchanter)container).getTile();
                tile.buttonClick((EntityPlayer)player.field_147369_b);
                break;
            }
        }
    }
}

