/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.core.network;

import com.brandon3055.draconicevolution.common.core.network.IPacket;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import org.apache.logging.log4j.Level;

public class ChannelHandler
extends FMLIndexedMessageToMessageCodec<IPacket> {
    public EnumMap<Side, FMLEmbeddedChannel> channels;
    private LinkedList<Class<? extends IPacket>> packets = new LinkedList();
    private boolean isPostInitialised = false;
    private final String logger;
    private final String channelName;

    public ChannelHandler(String logName, String modChannel) {
        this.logger = logName;
        this.channelName = modChannel;
    }

    public boolean registerPacket(Class<? extends IPacket> clazz) {
        if (this.packets.size() > 256) {
            FMLLog.log((String)this.logger, (Level)Level.ERROR, (String)"Cannot register more than 256 packets! Packet %s not registered!", (Object[])new Object[]{clazz.getName()});
            return false;
        }
        if (this.packets.contains(clazz)) {
            FMLLog.log((String)this.logger, (Level)Level.ERROR, (String)"Packet %s already registered!", (Object[])new Object[]{clazz.getName()});
            return false;
        }
        if (this.isPostInitialised) {
            FMLLog.log((String)this.logger, (Level)Level.ERROR, (String)"Packet %s cannot be registered during / after Post-Initialization!", (Object[])new Object[]{clazz.getName()});
            return false;
        }
        this.addDiscriminator(this.packets.size(), clazz);
        this.packets.add(clazz);
        return true;
    }

    public void encodeInto(ChannelHandlerContext ctx, IPacket msg, ByteBuf target) throws Exception {
        msg.writeBytes(target);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, IPacket msg) {
        msg.readBytes(source);
        INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
        if (netHandler instanceof NetHandlerPlayServer) {
            msg.handleServerSide((NetHandlerPlayServer)netHandler);
        } else if (netHandler instanceof NetHandlerPlayClient) {
            msg.handleClientSide((NetHandlerPlayClient)netHandler);
        }
    }

    public void initialise() {
        this.channels = NetworkRegistry.INSTANCE.newChannel(this.channelName, new io.netty.channel.ChannelHandler[]{this});
    }

    public void postInitialise() {
        if (this.isPostInitialised) {
            return;
        }
        this.isPostInitialised = true;
        Collections.sort(this.packets, new Comparator<Class<? extends IPacket>>(){

            @Override
            public int compare(Class<? extends IPacket> clazz1, Class<? extends IPacket> clazz2) {
                int com = String.CASE_INSENSITIVE_ORDER.compare(clazz1.getCanonicalName(), clazz2.getCanonicalName());
                if (com == 0) {
                    com = clazz1.getCanonicalName().compareTo(clazz2.getCanonicalName());
                }
                return com;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void sendToAll(IPacket message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendTo(IPacket message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToAllAround(IPacket message, NetworkRegistry.TargetPoint point) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToDimension(IPacket message, int dimensionId) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToServer(IPacket message) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)message);
    }
}

