/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.core.network;

import com.brandon3055.draconicevolution.common.blocks.ModBlocks;
import com.brandon3055.draconicevolution.common.core.network.IPacket;
import com.brandon3055.draconicevolution.common.tileentities.TilePlacedItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PlacedItemPacket
implements IPacket {
    byte side = 0;
    int blockX = 0;
    int blockY = 0;
    int blockZ = 0;

    public PlacedItemPacket() {
    }

    public PlacedItemPacket(byte side, int x, int y, int z) {
        this.side = side;
        this.blockX = x;
        this.blockY = y;
        this.blockZ = z;
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        bytes.writeByte((int)this.side);
        bytes.writeInt(this.blockX);
        bytes.writeInt(this.blockY);
        bytes.writeInt(this.blockZ);
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        this.side = bytes.readByte();
        this.blockX = bytes.readInt();
        this.blockY = bytes.readInt();
        this.blockZ = bytes.readInt();
    }

    @Override
    public void handleClientSide(NetHandlerPlayClient player) {
    }

    @Override
    public void handleServerSide(NetHandlerPlayServer playerData) {
        TilePlacedItem tile;
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.side);
        int x = this.blockX + dir.offsetX;
        int y = this.blockY + dir.offsetY;
        int z = this.blockZ + dir.offsetZ;
        World world = playerData.field_147369_b.field_70170_p;
        EntityPlayerMP player = playerData.field_147369_b;
        if (!world.func_147437_c(x, y, z) || player.func_70694_bm() == null) {
            return;
        }
        ItemStack stack = player.func_70694_bm();
        world.func_147465_d(x, y, z, (Block)ModBlocks.placedItem, (int)this.side, 2);
        TilePlacedItem tilePlacedItem = tile = world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TilePlacedItem ? (TilePlacedItem)world.func_147438_o(x, y, z) : null;
        if (tile == null) {
            world.func_147468_f(x, y, z);
            return;
        }
        tile.setStack(stack.func_77946_l());
        player.func_71028_bD();
    }
}

