/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.core.network;

import com.brandon3055.draconicevolution.common.core.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.core.network.IPacket;
import com.brandon3055.draconicevolution.common.core.utills.ItemNBTHelper;
import com.brandon3055.draconicevolution.common.items.ModItems;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;

public class TeleporterPacket
implements IPacket {
    byte buttonId = 0;
    int dim = 0;
    int selection = 0;
    double playerX = 0.0;
    double playerY = 0.0;
    double playerZ = 0.0;
    float yaw = 0.0f;
    float pitch = 0.0f;

    public TeleporterPacket() {
    }

    public TeleporterPacket(byte buttonId, int data) {
        this.buttonId = buttonId;
        this.selection = data;
    }

    public TeleporterPacket(byte buttonId, int data, int dim, double x, double y, double z, float yaw, float pitch) {
        this.buttonId = buttonId;
        this.dim = dim;
        this.selection = data;
        this.playerX = x;
        this.playerY = y;
        this.playerZ = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        this.buttonId = bytes.readByte();
        this.dim = bytes.readInt();
        this.selection = bytes.readInt();
        this.playerX = bytes.readDouble();
        this.playerY = bytes.readDouble();
        this.playerZ = bytes.readDouble();
        this.yaw = bytes.readFloat();
        this.pitch = bytes.readFloat();
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        bytes.writeByte((int)this.buttonId);
        bytes.writeInt(this.dim);
        bytes.writeInt(this.selection);
        bytes.writeDouble(this.playerX);
        bytes.writeDouble(this.playerY);
        bytes.writeDouble(this.playerZ);
        bytes.writeFloat(this.yaw);
        bytes.writeFloat(this.pitch);
    }

    @Override
    public void handleClientSide(NetHandlerPlayClient player) {
        System.out.println("a client");
    }

    @Override
    public void handleServerSide(NetHandlerPlayServer player) {
        switch (this.buttonId) {
            case 0: {
                if (player.field_147369_b.func_71045_bC() == null || !player.field_147369_b.func_71045_bC().func_77969_a(new ItemStack((Item)ModItems.teleporterMKII))) break;
                ItemNBTHelper.setShort(player.field_147369_b.func_71045_bC(), "Selection", (short)this.selection);
                break;
            }
            case 1: {
                ItemStack stack = player.field_147369_b.func_71045_bC();
                if (stack == null || !stack.func_77969_a(new ItemStack((Item)ModItems.teleporterMKII))) break;
                ItemNBTHelper.setDouble(stack, "X_" + this.selection, this.playerX);
                ItemNBTHelper.setDouble(stack, "Y_" + this.selection, this.playerY);
                ItemNBTHelper.setDouble(stack, "Z_" + this.selection, this.playerZ);
                ItemNBTHelper.setFloat(stack, "Yaw_" + this.selection, this.yaw);
                ItemNBTHelper.setFloat(stack, "Pitch_" + this.selection, this.pitch);
                ItemNBTHelper.setIntager(stack, "Dimension_" + this.selection, this.dim);
                ItemNBTHelper.setBoolean(stack, "IsSet_" + this.selection, true);
                break;
            }
            case 6: {
                ItemStack stack2 = player.field_147369_b.func_71045_bC();
                if (stack2 == null || !stack2.func_77969_a(new ItemStack((Item)ModItems.teleporterMKII))) break;
                int fuel = ItemNBTHelper.getIntager(stack2, "Fuel", 0);
                if (!player.field_147369_b.field_71071_by.func_146028_b(Items.field_151079_bi)) break;
                for (int i = 0; i < this.selection; ++i) {
                    player.field_147369_b.field_71071_by.func_146026_a(Items.field_151079_bi);
                }
                ItemNBTHelper.setIntager(stack2, "Fuel", fuel + ConfigHandler.teleporterUsesPerPearl * this.selection);
            }
        }
    }
}

