/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.core.proxy;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.creativetab.DETab;
import com.brandon3055.draconicevolution.client.interfaces.GuiHandler;
import com.brandon3055.draconicevolution.common.blocks.ModBlocks;
import com.brandon3055.draconicevolution.common.core.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.core.handler.CraftingHandler;
import com.brandon3055.draconicevolution.common.core.handler.FMLEventHandler;
import com.brandon3055.draconicevolution.common.core.handler.MinecraftForgeEventHandler;
import com.brandon3055.draconicevolution.common.core.network.ButtonPacket;
import com.brandon3055.draconicevolution.common.core.network.ExamplePacket;
import com.brandon3055.draconicevolution.common.core.network.ParticleGenPacket;
import com.brandon3055.draconicevolution.common.core.network.PlacedItemPacket;
import com.brandon3055.draconicevolution.common.core.network.PlayerDetectorButtonPacket;
import com.brandon3055.draconicevolution.common.core.network.PlayerDetectorStringPacket;
import com.brandon3055.draconicevolution.common.core.network.TeleporterPacket;
import com.brandon3055.draconicevolution.common.core.network.TeleporterStringPacket;
import com.brandon3055.draconicevolution.common.core.utills.Utills;
import com.brandon3055.draconicevolution.common.entity.EntityChaosDrill;
import com.brandon3055.draconicevolution.common.entity.EntityCustomDragon;
import com.brandon3055.draconicevolution.common.entity.EntityDraconicArrow;
import com.brandon3055.draconicevolution.common.entity.EntityEnderArrow;
import com.brandon3055.draconicevolution.common.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.common.items.ModItems;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.tileentities.TileCKeyStone;
import com.brandon3055.draconicevolution.common.tileentities.TileContainerTemplate;
import com.brandon3055.draconicevolution.common.tileentities.TileCustomSpawner;
import com.brandon3055.draconicevolution.common.tileentities.TileDissEnchanter;
import com.brandon3055.draconicevolution.common.tileentities.TileEnergyInfuser;
import com.brandon3055.draconicevolution.common.tileentities.TileGenerator;
import com.brandon3055.draconicevolution.common.tileentities.TileGrinder;
import com.brandon3055.draconicevolution.common.tileentities.TileParticleGenerator;
import com.brandon3055.draconicevolution.common.tileentities.TilePlacedItem;
import com.brandon3055.draconicevolution.common.tileentities.TilePlayerDetector;
import com.brandon3055.draconicevolution.common.tileentities.TilePlayerDetectorAdvanced;
import com.brandon3055.draconicevolution.common.tileentities.TilePotentiometer;
import com.brandon3055.draconicevolution.common.tileentities.TileSunDial;
import com.brandon3055.draconicevolution.common.tileentities.TileTestBlock;
import com.brandon3055.draconicevolution.common.tileentities.TileWeatherController;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnderResurrection;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyPylon;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileInvisibleMultiblock;
import com.brandon3055.draconicevolution.common.world.DraconicWorldGenerator;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraftforge.common.MinecraftForge;

public class CommonProxy {
    private static final boolean debug = DraconicEvolution.debug;

    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.init(event.getSuggestedConfigurationFile());
        this.registerEventListeners();
        ModBlocks.init();
        ModItems.init();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new DraconicWorldGenerator(), (int)1);
        this.registerTileEntities();
    }

    public void init(FMLInitializationEvent event) {
        CraftingHandler.init();
        this.registerGuiHandeler();
        this.registerWorldGen();
        DraconicEvolution.channelHandler.initialise();
        this.registerPackets();
        this.registerEntitys();
        DETab.initialize();
    }

    public void postInit(FMLPostInitializationEvent event) {
        DraconicEvolution.channelHandler.postInitialise();
    }

    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileWeatherController.class, (String)(References.RESOURCESPREFIX + "TileWeatherController"));
        GameRegistry.registerTileEntity(TileSunDial.class, (String)(References.RESOURCESPREFIX + "TileSunDial"));
        GameRegistry.registerTileEntity(TileGrinder.class, (String)(References.RESOURCESPREFIX + "TileGrinder"));
        GameRegistry.registerTileEntity(TilePotentiometer.class, (String)(References.RESOURCESPREFIX + "TilePotentiometer"));
        GameRegistry.registerTileEntity(TileParticleGenerator.class, (String)(References.RESOURCESPREFIX + "TileParticleGenerator"));
        GameRegistry.registerTileEntity(TilePlayerDetector.class, (String)(References.RESOURCESPREFIX + "TilePlayerDetector"));
        GameRegistry.registerTileEntity(TilePlayerDetectorAdvanced.class, (String)(References.RESOURCESPREFIX + "TilePlayerDetectorAdvanced"));
        GameRegistry.registerTileEntity(TileEnergyInfuser.class, (String)(References.RESOURCESPREFIX + "TileEnergyInfuser"));
        GameRegistry.registerTileEntity(TileCustomSpawner.class, (String)(References.RESOURCESPREFIX + "TileCustomSpawner"));
        GameRegistry.registerTileEntity(TileGenerator.class, (String)(References.RESOURCESPREFIX + "TileGenerator"));
        GameRegistry.registerTileEntity(TileEnergyStorageCore.class, (String)(References.RESOURCESPREFIX + "TileEnergyStorageCore"));
        GameRegistry.registerTileEntity(TileInvisibleMultiblock.class, (String)(References.RESOURCESPREFIX + "TileInvisibleMultiblock"));
        GameRegistry.registerTileEntity(TileEnergyPylon.class, (String)(References.RESOURCESPREFIX + "TileEnergyPylon"));
        GameRegistry.registerTileEntity(Utills.TileBlockChanger.class, (String)(References.RESOURCESPREFIX + "TileBlockChanger"));
        GameRegistry.registerTileEntity(TileEnderResurrection.class, (String)(References.RESOURCESPREFIX + "TileEnderResurrection"));
        GameRegistry.registerTileEntity(TilePlacedItem.class, (String)(References.RESOURCESPREFIX + "TilePlacedItem"));
        GameRegistry.registerTileEntity(TileCKeyStone.class, (String)(References.RESOURCESPREFIX + "TileCKeyStone"));
        GameRegistry.registerTileEntity(TileDissEnchanter.class, (String)(References.RESOURCESPREFIX + "TileDissEnchanter"));
        if (DraconicEvolution.debug) {
            GameRegistry.registerTileEntity(TileTestBlock.class, (String)(References.RESOURCESPREFIX + "TileTestBlock"));
            GameRegistry.registerTileEntity(TileContainerTemplate.class, (String)(References.RESOURCESPREFIX + "TileContainerTemplate"));
        }
    }

    public void registerEventListeners() {
        MinecraftForge.EVENT_BUS.register((Object)new MinecraftForgeEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new FMLEventHandler());
    }

    public void registerPackets() {
        if (debug) {
            System.out.println("[DEBUG]CommonProxy: registerPackets");
            DraconicEvolution.channelHandler.registerPacket(ExamplePacket.class);
        }
        DraconicEvolution.channelHandler.registerPacket(ButtonPacket.class);
        DraconicEvolution.channelHandler.registerPacket(TeleporterPacket.class);
        DraconicEvolution.channelHandler.registerPacket(TeleporterStringPacket.class);
        DraconicEvolution.channelHandler.registerPacket(ParticleGenPacket.class);
        DraconicEvolution.channelHandler.registerPacket(PlayerDetectorStringPacket.class);
        DraconicEvolution.channelHandler.registerPacket(PlayerDetectorButtonPacket.class);
        DraconicEvolution.channelHandler.registerPacket(PlacedItemPacket.class);
    }

    public void registerGuiHandeler() {
        new GuiHandler();
    }

    public void registerWorldGen() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new DraconicWorldGenerator(), (int)0);
    }

    public void registerEntitys() {
        EntityRegistry.registerModEntity(EntityCustomDragon.class, (String)"EnderDragon", (int)0, (Object)DraconicEvolution.instance, (int)500, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityPersistentItem.class, (String)"Persistent Item", (int)1, (Object)DraconicEvolution.instance, (int)32, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityDraconicArrow.class, (String)"Arrow", (int)2, (Object)DraconicEvolution.instance, (int)32, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityEnderArrow.class, (String)"Ender Arrow", (int)2, (Object)DraconicEvolution.instance, (int)32, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityChaosDrill.class, (String)"Chaos Drill", (int)3, (Object)DraconicEvolution.instance, (int)10, (int)5, (boolean)false);
    }
}

