/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.armor;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.core.utills.LogHelper;
import com.brandon3055.draconicevolution.common.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.common.items.ModItems;
import com.brandon3055.draconicevolution.common.items.armor.ArmorPropertiesHandler;
import com.brandon3055.draconicevolution.common.lib.References;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import org.lwjgl.input.Keyboard;

public class DraconicArmor
extends ItemArmor
implements ISpecialArmor {
    private IIcon helmIcon;
    private IIcon chestIcon;
    private IIcon leggsIcon;
    private IIcon bootsIcon;

    public DraconicArmor(ItemArmor.ArmorMaterial material, int armorType, String name) {
        super(material, 0, armorType);
        this.func_77655_b(name);
        this.func_77637_a(DraconicEvolution.tolkienTabToolsWeapons);
        GameRegistry.registerItem((Item)this, (String)name);
    }

    public String func_77658_a() {
        return String.format("item.%s%s", "DraconicEvolution".toLowerCase() + ":", super.func_77658_a().substring(super.func_77658_a().indexOf(".") + 1));
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.helmIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_helmet");
        this.chestIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_chestplate");
        this.leggsIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_leggings");
        this.bootsIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_boots");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (stack.func_77973_b() == ModItems.draconicHelm) {
            return this.helmIcon;
        }
        if (stack.func_77973_b() == ModItems.draconicChest) {
            return this.chestIcon;
        }
        if (stack.func_77973_b() == ModItems.draconicLeggs) {
            return this.leggsIcon;
        }
        return this.bootsIcon;
    }

    public IIcon func_77650_f(ItemStack stack) {
        if (stack.func_77973_b() == ModItems.draconicHelm) {
            return this.helmIcon;
        }
        if (stack.func_77973_b() == ModItems.draconicChest) {
            return this.chestIcon;
        }
        if (stack.func_77973_b() == ModItems.draconicLeggs) {
            return this.leggsIcon;
        }
        return this.bootsIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (stack.func_77973_b() == ModItems.draconicHelm || stack.func_77973_b() == ModItems.draconicChest || stack.func_77973_b() == ModItems.draconicBoots) {
            return References.RESOURCESPREFIX + "textures/models/armor/draconic_layer_1.png";
        }
        return References.RESOURCESPREFIX + "textures/models/armor/draconic_layer_2.png";
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        switch (slot) {
            case 0: {
                return ArmorPropertiesHandler.draconicBoots(player, armor, source);
            }
            case 1: {
                return ArmorPropertiesHandler.draconicLeggs(player, armor, source);
            }
            case 2: {
                return ArmorPropertiesHandler.draconicChest(player, armor, source);
            }
            case 3: {
                return ArmorPropertiesHandler.draconicHelm(player, armor, source);
            }
        }
        LogHelper.error("[Draconic Armor] Invalid slot");
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        switch (slot) {
            case 0: {
                return 3;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (player.func_70027_ad() && ArmorPropertiesHandler.hasFullSetDraconic((EntityLivingBase)player)) {
            player.func_70690_d(new PotionEffect(12, 10, 0, true));
        }
        if (stack != null && stack.func_77973_b() == ModItems.draconicHelm) {
            if (world.field_72995_K) {
                return;
            }
            this.clearNegativeEffects((Entity)player);
            if (player.field_70170_p.func_72957_l((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v) < 5) {
                player.func_70690_d(new PotionEffect(16, 210, 0, true));
            } else if (player.func_82165_m(16)) {
                player.func_82170_o(16);
            }
        }
        if (stack != null && stack.func_77973_b() == ModItems.draconicLeggs) {
            if (player.func_70051_ag()) {
                player.func_70690_d(new PotionEffect(1, 10, 3, true));
            } else {
                player.func_70690_d(new PotionEffect(1, 10, 1, true));
            }
        }
        if (stack != null && stack.func_77973_b() == ModItems.draconicBoots) {
            if (player.func_70051_ag()) {
                player.func_70690_d(new PotionEffect(8, 10, 3, true));
            } else {
                player.func_70690_d(new PotionEffect(8, 10, 1, true));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.DARK_GREEN + "Hold shift for information");
        } else {
            if (stack.func_77973_b() == ModItems.draconicHelm) {
                list.add(StatCollector.func_74838_a((String)"info.draconicArmorInfoHelm.txt"));
            } else if (stack.func_77973_b() == ModItems.draconicChest) {
                list.add(StatCollector.func_74838_a((String)"info.draconicArmorInfoChest.txt"));
                list.add(StatCollector.func_74838_a((String)"info.draconicArmorInfoChest1.txt"));
                list.add(StatCollector.func_74838_a((String)"info.draconicArmorInfoChest2.txt"));
                list.add(StatCollector.func_74838_a((String)"info.draconicArmorInfoChest3.txt"));
            } else if (stack.func_77973_b() == ModItems.draconicLeggs) {
                list.add(StatCollector.func_74838_a((String)"info.draconicArmorInfoLeggs.txt"));
            } else if (stack.func_77973_b() == ModItems.draconicBoots) {
                list.add(StatCollector.func_74838_a((String)"info.draconicArmorInfoBoots.txt"));
                list.add(StatCollector.func_74838_a((String)"info.draconicArmorInfoBoots1.txt"));
            }
            list.add("");
            list.add("" + EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"info.draconicArmorLegend1.txt"));
            list.add("" + EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"info.draconicArmorLegend2.txt"));
        }
    }

    public static void registerRecipe() {
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ModItems.draconicHelm), new Object[]{"ISI", "DAD", "CIC", Character.valueOf('I'), ModItems.draconiumIngot, Character.valueOf('S'), ModItems.sunFocus, Character.valueOf('D'), ModItems.draconicCompound, Character.valueOf('C'), ModItems.draconicCore, Character.valueOf('A'), ModItems.wyvernHelm});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ModItems.draconicChest), new Object[]{"ISI", "DAD", "CDC", Character.valueOf('I'), ModItems.draconiumIngot, Character.valueOf('S'), ModItems.sunFocus, Character.valueOf('D'), ModItems.draconicCompound, Character.valueOf('C'), ModItems.draconicCore, Character.valueOf('A'), ModItems.wyvernChest});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ModItems.draconicLeggs), new Object[]{"ISI", "DAD", "CIC", Character.valueOf('I'), ModItems.draconiumIngot, Character.valueOf('S'), ModItems.sunFocus, Character.valueOf('D'), ModItems.draconicCompound, Character.valueOf('C'), ModItems.draconicCore, Character.valueOf('A'), ModItems.wyvernLeggs});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ModItems.draconicBoots), new Object[]{"ISI", "DAD", "CIC", Character.valueOf('I'), ModItems.draconiumIngot, Character.valueOf('S'), ModItems.sunFocus, Character.valueOf('D'), ModItems.draconicCompound, Character.valueOf('C'), ModItems.draconicCore, Character.valueOf('A'), ModItems.wyvernBoots});
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }

    public void clearNegativeEffects(Entity par3Entity) {
        if (par3Entity.field_70173_aa % 20 == 0 && par3Entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par3Entity;
            Collection potions = player.func_70651_bq();
            if (player.func_70027_ad()) {
                player.func_70066_B();
            } else {
                for (PotionEffect potion : potions) {
                    int id = potion.func_76456_a();
                    if (!((Boolean)ReflectionHelper.getPrivateValue(Potion.class, (Object)Potion.field_76425_a[id], (String[])new String[]{"isBadEffect", "field_76418_K", "J"})).booleanValue()) continue;
                    if (player.func_70694_bm() != null && (player.func_70694_bm().func_77973_b() == ModItems.wyvernBow || player.func_70694_bm().func_77973_b() == ModItems.draconicBow) && id == 2) break;
                    player.func_82170_o(id);
                    break;
                }
            }
        }
    }
}

