/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.armor;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.core.utills.LogHelper;
import com.brandon3055.draconicevolution.common.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.common.items.ModItems;
import com.brandon3055.draconicevolution.common.items.armor.ArmorPropertiesHandler;
import com.brandon3055.draconicevolution.common.lib.References;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class WyvernArmor
extends ItemArmor
implements ISpecialArmor {
    private IIcon helmIcon;
    private IIcon chestIcon;
    private IIcon leggsIcon;
    private IIcon bootsIcon;

    public WyvernArmor(ItemArmor.ArmorMaterial material, int armorType, String name) {
        super(material, 0, armorType);
        this.func_77655_b(name);
        this.func_77637_a(DraconicEvolution.tolkienTabToolsWeapons);
        GameRegistry.registerItem((Item)this, (String)name);
    }

    public String func_77658_a() {
        return String.format("item.%s%s", "DraconicEvolution".toLowerCase() + ":", super.func_77658_a().substring(super.func_77658_a().indexOf(".") + 1));
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.helmIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "wyvern_helmet");
        this.chestIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "wyvern_chestplate");
        this.leggsIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "wyvern_leggings");
        this.bootsIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "wyvern_boots");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (stack.func_77973_b() == ModItems.wyvernHelm) {
            return this.helmIcon;
        }
        if (stack.func_77973_b() == ModItems.wyvernChest) {
            return this.chestIcon;
        }
        if (stack.func_77973_b() == ModItems.wyvernLeggs) {
            return this.leggsIcon;
        }
        return this.bootsIcon;
    }

    public IIcon func_77650_f(ItemStack stack) {
        if (stack.func_77973_b() == ModItems.wyvernHelm) {
            return this.helmIcon;
        }
        if (stack.func_77973_b() == ModItems.wyvernChest) {
            return this.chestIcon;
        }
        if (stack.func_77973_b() == ModItems.wyvernLeggs) {
            return this.leggsIcon;
        }
        return this.bootsIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (stack.func_77973_b() == ModItems.wyvernHelm || stack.func_77973_b() == ModItems.wyvernChest || stack.func_77973_b() == ModItems.wyvernBoots) {
            return References.RESOURCESPREFIX + "textures/models/armor/wyvern_layer_1.png";
        }
        return References.RESOURCESPREFIX + "textures/models/armor/wyvern_layer_2.png";
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        switch (slot) {
            case 0: {
                return ArmorPropertiesHandler.wyvernBoots(player, armor, source);
            }
            case 1: {
                return ArmorPropertiesHandler.wyvernLeggs(player, armor, source);
            }
            case 2: {
                return ArmorPropertiesHandler.wyvernChest(player, armor, source);
            }
            case 3: {
                return ArmorPropertiesHandler.wyvernHelm(player, armor, source);
            }
        }
        LogHelper.error("[Draconic Armor] Invalid slot");
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        switch (slot) {
            case 0: {
                return 3;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (stack != null && stack.func_77973_b() == ModItems.wyvernLeggs) {
            if (player.func_70051_ag()) {
                player.func_70690_d(new PotionEffect(1, 10, 1, true));
            } else {
                player.func_70690_d(new PotionEffect(1, 10, 0, true));
            }
        }
        if (stack != null && stack.func_77973_b() == ModItems.wyvernBoots) {
            if (player.func_70051_ag()) {
                player.func_70690_d(new PotionEffect(8, 10, 1, true));
            } else {
                player.func_70690_d(new PotionEffect(8, 10, 0, true));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        list.add("" + EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"info.wyvernArmorLegend1.txt"));
        list.add("" + EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"info.wyvernArmorLegend2.txt"));
    }

    public static void registerRecipe() {
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ModItems.wyvernHelm), new Object[]{" I ", "IDI", " C ", Character.valueOf('I'), ModItems.infusedCompound, Character.valueOf('D'), Items.field_151161_ac, Character.valueOf('C'), ModItems.draconicCore});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ModItems.wyvernChest), new Object[]{"PIP", "IDI", "ICI", Character.valueOf('I'), ModItems.infusedCompound, Character.valueOf('D'), Items.field_151163_ad, Character.valueOf('C'), ModItems.draconicCore, Character.valueOf('P'), new ItemStack((Item)Items.field_151068_bn, 1, 8259)});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ModItems.wyvernLeggs), new Object[]{"PIP", "IDI", " C ", Character.valueOf('I'), ModItems.infusedCompound, Character.valueOf('D'), Items.field_151173_ae, Character.valueOf('C'), ModItems.draconicCore, Character.valueOf('P'), new ItemStack((Item)Items.field_151068_bn, 1, 8258)});
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ModItems.wyvernBoots), new Object[]{" I ", "IDI", "PCP", Character.valueOf('I'), ModItems.infusedCompound, Character.valueOf('D'), Items.field_151175_af, Character.valueOf('C'), ModItems.draconicCore, Character.valueOf('P'), Blocks.field_150331_J});
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }
}

