/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.tools;

import cofh.api.energy.IEnergyContainerItem;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.core.utills.EnergyHelper;
import com.brandon3055.draconicevolution.common.core.utills.ItemInfoHelper;
import com.brandon3055.draconicevolution.common.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.common.items.ModItems;
import com.brandon3055.draconicevolution.common.items.tools.ToolHandler;
import com.brandon3055.draconicevolution.common.lib.References;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class DraconicAxe
extends ItemAxe
implements IEnergyContainerItem {
    protected int capacity = 10000000;
    protected int maxReceive = 10000;
    protected int maxExtract = 10000;

    public DraconicAxe() {
        super(ModItems.DRACONIUM_T1);
        this.func_77655_b("draconicAxe");
        this.func_77637_a(DraconicEvolution.tolkienTabToolsWeapons);
        GameRegistry.registerItem((Item)this, (String)"draconicAxe");
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag(new ItemStack(item, 1, 0), 0));
        list.add(EnergyHelper.setDefaultEnergyTag(new ItemStack(item, 1, 0), this.capacity));
    }

    public String func_77658_a() {
        return String.format("item.%s%s", "DraconicEvolution".toLowerCase() + ":", super.func_77658_a().substring(super.func_77658_a().indexOf(".") + 1));
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_axe");
    }

    public boolean onBlockStartBreak(ItemStack stack, int X, int Y, int Z, EntityPlayer player) {
        World world = player.field_70170_p;
        boolean tree = this.isTree(world, X, Y, Z);
        if (player.func_70093_af()) {
            return false;
        }
        Block block = world.func_147439_a(X, Y, Z);
        Material mat = block.func_149688_o();
        if (!ToolHandler.isRightMaterial(mat, ToolHandler.materialsAxe)) {
            return false;
        }
        if (!tree) {
            ToolHandler.disSquare(X, Y, Z, player, world, false, 0, ToolHandler.materialsAxe, stack);
            return false;
        }
        if (!world.field_72995_K) {
            world.func_72926_e(2001, X, Y, Z, Block.func_149682_b((Block)world.func_147439_a(X, Y, Z)));
        }
        this.trimLeavs(X, Y, Z, player, world, stack);
        this.chopTree(X, Y, Z, player, world, stack);
        return true;
    }

    private boolean isTree(World world, int X, int Y, int Z) {
        Block wood = world.func_147439_a(X, Y, Z);
        if (wood == null || !wood.isWood((IBlockAccess)world, X, Y, Z)) {
            return false;
        }
        int top = Y;
        for (int y = Y; y <= Y + 50; ++y) {
            if (world.func_147439_a(X, y, Z).isWood((IBlockAccess)world, X, y, Z) || world.func_147439_a(X, y, Z).isLeaves((IBlockAccess)world, X, y, Z)) continue;
            top += y;
            break;
        }
        int leaves = 0;
        for (int xPos = X - 1; xPos <= X + 1; ++xPos) {
            for (int yPos = Y; yPos <= top; ++yPos) {
                for (int zPos = Z - 1; zPos <= Z + 1; ++zPos) {
                    if (!world.func_147439_a(xPos, yPos, zPos).isLeaves((IBlockAccess)world, xPos, yPos, zPos)) continue;
                    ++leaves;
                }
            }
        }
        return leaves >= 3;
    }

    void chopTree(int X, int Y, int Z, EntityPlayer player, World world, ItemStack stack) {
        for (int xPos = X - 1; xPos <= X + 1; ++xPos) {
            for (int yPos = Y; yPos <= Y + 1; ++yPos) {
                for (int zPos = Z - 1; zPos <= Z + 1; ++zPos) {
                    Block block = world.func_147439_a(xPos, yPos, zPos);
                    int meta = world.func_72805_g(xPos, yPos, zPos);
                    if (!block.isWood((IBlockAccess)world, xPos, yPos, zPos)) continue;
                    world.func_147468_f(xPos, yPos, zPos);
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (block.removedByPlayer(world, player, xPos, yPos, zPos, false)) {
                            block.func_149664_b(world, xPos, yPos, zPos, meta);
                        }
                        block.func_149636_a(world, player, xPos, yPos, zPos, meta);
                        block.func_149681_a(world, xPos, yPos, zPos, meta, player);
                        this.func_150894_a(stack, world, block, xPos, yPos, zPos, (EntityLivingBase)player);
                    }
                    this.chopTree(xPos, yPos, zPos, player, world, stack);
                }
            }
        }
    }

    void trimLeavs(int X, int Y, int Z, EntityPlayer player, World world, ItemStack stack) {
        this.scedualUpdates(X, Y, Z, player, world, stack);
    }

    void scedualUpdates(int X, int Y, int Z, EntityPlayer player, World world, ItemStack stack) {
        for (int xPos = X - 15; xPos <= X + 15; ++xPos) {
            for (int yPos = Y; yPos <= Y + 50; ++yPos) {
                for (int zPos = Z - 15; zPos <= Z + 15; ++zPos) {
                    Block block = world.func_147439_a(xPos, yPos, zPos);
                    if (!block.isLeaves((IBlockAccess)world, xPos, yPos, zPos)) continue;
                    world.func_147464_a(xPos, yPos, zPos, block, 2 + world.field_73012_v.nextInt(10));
                }
            }
        }
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int x, int y, int z, int side, float par8, float par9, float par10) {
        return super.func_77648_a(par1ItemStack, par2EntityPlayer, par3World, x, y, z, side, par8, par9, par10);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extraInformation) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"info.draconicAxe1.txt"));
            list.add(EnumChatFormatting.DARK_GREEN + "Hold shift for information");
            ItemInfoHelper.energyDisplayInfo(stack, list);
        } else {
            list.add(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"info.draconicAxe2.txt"));
            list.add(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"info.draconicAxe3.txt"));
            list.add(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"info.draconicAxe4.txt"));
            list.add("");
            list.add(EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"info.draconicLaw1.txt"));
            list.add(EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"info.draconicLaw2.txt"));
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.rare;
    }

    public static void registerRecipe() {
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ModItems.draconicAxe), new Object[]{"DFD", "CAC", "DTD", Character.valueOf('F'), ModItems.sunFocus, Character.valueOf('C'), ModItems.draconicCompound, Character.valueOf('D'), ModItems.draconiumIngot, Character.valueOf('T'), ModItems.draconicCore, Character.valueOf('A'), Items.field_151056_x});
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) != this.getMaxEnergyStored(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (stack.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)stack.func_77973_b()).getEnergyStored(stack) >= 450) {
            return super.getDigSpeed(stack, block, meta);
        }
        return 1.0f;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }
}

