/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.tools;

import cofh.api.energy.IEnergyContainerItem;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.core.utills.EnergyHelper;
import com.brandon3055.draconicevolution.common.core.utills.ItemInfoHelper;
import com.brandon3055.draconicevolution.common.core.utills.ItemNBTHelper;
import com.brandon3055.draconicevolution.common.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.common.items.ModItems;
import com.brandon3055.draconicevolution.common.items.tools.ToolHandler;
import com.brandon3055.draconicevolution.common.lib.References;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class DraconicDistructionStaff
extends ItemTool
implements IEnergyContainerItem {
    public IIcon itemIcon0;
    public IIcon itemIcon1;
    public IIcon itemIcon2;
    protected int capacity = 100000000;
    protected int maxReceive = 10000;
    protected int maxExtract = 500000;
    private static Set<Block> minableBlocks = Sets.newHashSet();

    public DraconicDistructionStaff() {
        super(0.0f, ModItems.DRACONIUM_T3, minableBlocks);
        this.func_77655_b("draconicDistructionStaff");
        this.func_77637_a(DraconicEvolution.tolkienTabToolsWeapons);
        this.setHarvestLevel("pickaxe", 4);
        this.setHarvestLevel("shovel", 4);
        this.setHarvestLevel("axe", 4);
        GameRegistry.registerItem((Item)this, (String)"draconicDistructionStaff");
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag(new ItemStack(item, 1, 0), 0));
        list.add(EnergyHelper.setDefaultEnergyTag(new ItemStack(item, 1, 0), this.capacity));
    }

    public String func_77658_a() {
        return String.format("item.%s%s", "DraconicEvolution".toLowerCase() + ":", super.func_77658_a().substring(super.func_77658_a().indexOf(".") + 1));
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    public boolean func_150897_b(Block block) {
        return block == Blocks.field_150343_Z ? this.field_77862_b.func_77996_d() == 3 : (block != Blocks.field_150484_ah && block != Blocks.field_150482_ag ? (block != Blocks.field_150412_bA && block != Blocks.field_150475_bE ? (block != Blocks.field_150340_R && block != Blocks.field_150352_o ? (block != Blocks.field_150339_S && block != Blocks.field_150366_p ? (block != Blocks.field_150368_y && block != Blocks.field_150369_x ? (block != Blocks.field_150450_ax && block != Blocks.field_150439_ay ? (block.func_149688_o() == Material.field_151576_e ? true : (block.func_149688_o() == Material.field_151573_f ? true : block.func_149688_o() == Material.field_151574_g)) : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 1) : this.field_77862_b.func_77996_d() >= 1) : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 2);
    }

    public float func_150893_a(ItemStack stack, Block block) {
        return block.func_149688_o() != Material.field_151573_f && block.func_149688_o() != Material.field_151574_g && block.func_149688_o() != Material.field_151576_e ? super.func_150893_a(stack, block) : this.field_77864_a;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.itemIcon0 = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_staff");
        this.itemIcon1 = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_staff_active");
        this.itemIcon2 = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_staff_obliterate");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (ItemNBTHelper.getShort(stack, "size", (short)0) > 0 && ItemNBTHelper.getBoolean(stack, "obliterate", false)) {
            return this.itemIcon2;
        }
        if (ItemNBTHelper.getShort(stack, "size", (short)0) > 0) {
            return this.itemIcon1;
        }
        return this.itemIcon0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        if (ItemNBTHelper.getShort(stack, "size", (short)0) > 0 && ItemNBTHelper.getBoolean(stack, "obliterate", false)) {
            return this.itemIcon2;
        }
        if (ItemNBTHelper.getShort(stack, "size", (short)0) > 0) {
            return this.itemIcon1;
        }
        return this.itemIcon0;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        Block block = world.func_147439_a(x, y, z);
        Material mat = block.func_149688_o();
        if (!ToolHandler.isRightMaterial(mat, ToolHandler.materialsDStaff)) {
            return false;
        }
        int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
        boolean silk = EnchantmentHelper.func_77502_d((EntityLivingBase)player);
        ToolHandler.disSquare(x, y, z, player, world, silk, fortune, ToolHandler.materialsDStaff, stack);
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        return ToolHandler.changeMode(stack, player, true, 4);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        ToolHandler.AOEAttack(player, entity, stack, 25, ItemNBTHelper.getShort(stack, "size", (short)0) * 2);
        ToolHandler.damageEntityBasedOnHealth(entity, player, 0.5f);
        return true;
    }

    public Multimap func_111205_h() {
        Multimap multimap = super.func_111205_h();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 4.0 + (double)ModItems.DRACONIUM_T2.func_78000_c(), 0));
        return multimap;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extraInformation) {
        int size = ItemNBTHelper.getShort(stack, "size", (short)0) * 2 + 1;
        boolean oblit = ItemNBTHelper.getBoolean(stack, "obliterate", false);
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.DARK_GREEN + "Hold shift for information");
            ItemInfoHelper.energyDisplayInfo(stack, list);
        } else {
            list.add(EnumChatFormatting.GREEN + "Mining Mode: " + EnumChatFormatting.BLUE + size + "x" + size);
            list.add(EnumChatFormatting.GREEN + "Shift Right-click to change minning mode");
            list.add(StatCollector.func_74838_a((String)("msg.oblit" + oblit + ".txt")));
            list.add(EnumChatFormatting.GREEN + "Right-click to toggle Obliteration mode");
            list.add(EnumChatFormatting.GREEN + "Obliteration mode destroys low value blocks");
            list.add("");
            list.add(EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + "After great pains you have managed");
            list.add(EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + "to master the Draconic powers!");
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.epic;
    }

    public static void registerRecipe() {
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ModItems.draconicDistructionStaff), new Object[]{"DFD", "PTS", "DWD", Character.valueOf('F'), ModItems.sunFocus, Character.valueOf('D'), ModItems.draconicCompound, Character.valueOf('T'), ModItems.draconicCore, Character.valueOf('P'), ModItems.draconicPickaxe, Character.valueOf('S'), ModItems.draconicShovel, Character.valueOf('W'), ModItems.draconicSword});
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) != this.getMaxEnergyStored(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (stack.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)stack.func_77973_b()).getEnergyStored(stack) >= 450) {
            return super.getDigSpeed(stack, block, meta);
        }
        return 1.0f;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }
}

