/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.tools;

import cofh.api.energy.IEnergyContainerItem;
import com.brandon3055.draconicevolution.common.core.utills.ItemNBTHelper;
import com.brandon3055.draconicevolution.common.items.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ToolHandler {
    public static Material[] materialsPick = new Material[]{Material.field_151574_g, Material.field_151594_q, Material.field_151589_v, Material.field_151592_s, Material.field_151588_w, Material.field_151573_f, Material.field_151576_e};
    public static Material[] materialsShovel = new Material[]{Material.field_151571_B, Material.field_151578_c, Material.field_151577_b, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z};
    public static Material[] materialsAxe = new Material[]{Material.field_151570_A, Material.field_151584_j, Material.field_151575_d, Material.field_151585_k};
    public static Material[] materialsDStaff = new Material[]{Material.field_151574_g, Material.field_151594_q, Material.field_151589_v, Material.field_151592_s, Material.field_151588_w, Material.field_151573_f, Material.field_151576_e, Material.field_151571_B, Material.field_151578_c, Material.field_151577_b, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151570_A, Material.field_151584_j, Material.field_151575_d, Material.field_151585_k, Material.field_151580_n};
    public static Block[] destroyList = new Block[]{Blocks.field_150347_e, Blocks.field_150348_b, Blocks.field_150346_d, Blocks.field_150351_n, Blocks.field_150354_m, Blocks.field_150349_c, Blocks.field_150424_aL};

    public static boolean isRightMaterial(Material material, Material[] materialsListing) {
        for (Material mat : materialsListing) {
            if (material != mat) continue;
            return true;
        }
        return false;
    }

    public static boolean checkDestroyList(Block curBlock) {
        for (Block block : destroyList) {
            if (curBlock != block) continue;
            return true;
        }
        return false;
    }

    public static boolean disSquare(int x, int y, int z, EntityPlayer player, World world, boolean silk, int fortune, Material[] materialsListing, ItemStack stack) {
        int size = stack.func_77973_b().equals(ModItems.draconicAxe) ? 2 : (int)ItemNBTHelper.getShort(stack, "size", (short)0);
        MovingObjectPosition mop = ToolHandler.raytraceFromEntity(world, (Entity)player, 4.5);
        if (mop == null) {
            if (player instanceof EntityPlayer) {
                ToolHandler.updateGhostBlocks(player, world);
            }
            return false;
        }
        int sizeX = size;
        int sizeY = size;
        int sizeZ = size;
        int yOff = size * -1;
        Block targetBlock = world.func_147439_a(x, y, z);
        if (size > 0) {
            ++yOff;
        }
        int side = stack.func_77973_b().equals(ModItems.draconicAxe) ? 6 : mop.field_72310_e;
        switch (side) {
            case 0: 
            case 1: {
                sizeY = 0;
                yOff = 0;
                break;
            }
            case 2: 
            case 3: {
                sizeZ = 0;
                break;
            }
            case 4: 
            case 5: {
                sizeX = 0;
            }
        }
        for (int x1 = x - sizeX; x1 <= x + sizeX; ++x1) {
            for (int y1 = y - (sizeY + yOff); y1 <= y + (sizeY - yOff); ++y1) {
                for (int z1 = z - sizeZ; z1 <= z + sizeZ; ++z1) {
                    ToolHandler.mineBlock(x1, y1, z1, player, world, silk, fortune, materialsListing, stack);
                }
            }
        }
        world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), targetBlock.field_149762_H.func_150498_e(), (targetBlock.field_149762_H.func_150497_c() + 1.0f) / 2.0f, targetBlock.field_149762_H.func_150494_d() * 0.8f);
        return true;
    }

    public static void mineBlock(int x, int y, int z, EntityPlayer player, World world, boolean silk, int fortune, Material[] materialsListing, ItemStack stack) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        Material mat = block.func_149688_o();
        if (block != null && !block.isAir((IBlockAccess)world, x, y, z) && block.func_149737_a(player, world, x, y, z) != 0.0f) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            if (!block.canHarvestBlock(player, meta) || !ToolHandler.isRightMaterial(mat, materialsListing)) {
                return;
            }
            if (!(stack.func_77973_b() instanceof IEnergyContainerItem) || ((IEnergyContainerItem)stack.func_77973_b()).getEnergyStored(stack) < 450) {
                if (!player.field_71075_bZ.field_75098_d) {
                    return;
                }
            } else if (!player.field_71075_bZ.field_75098_d) {
                ((IEnergyContainerItem)stack.func_77973_b()).extractEnergy(stack, 450, false);
            }
            if (ToolHandler.checkDestroyList(block) && ItemNBTHelper.getBoolean(stack, "obliterate", false)) {
                world.func_147468_f(x, y, z);
                return;
            }
            if ((stack.func_77973_b().equals(ModItems.draconicAxe) ? 2 : (int)ItemNBTHelper.getShort(stack, "size", (short)0)) == 0) {
                return;
            }
            if (silk && block.canSilkHarvest(world, player, x, y, z, meta)) {
                if (block == Blocks.field_150439_ay) {
                    items.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150450_ax)));
                } else {
                    items.add(new ItemStack(block.func_149694_d(world, x, y, z), 1, meta));
                }
            } else {
                items.addAll(block.getDrops(world, x, y, z, meta, fortune));
                int xp = block.getExpDrop((IBlockAccess)world, meta, fortune);
                player.func_71023_q(xp);
            }
            world.func_147468_f(x, y, z);
            if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && world.func_82736_K().func_82766_b("doTileDrops")) {
                for (ItemStack item : items) {
                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, item));
                }
            }
        }
    }

    public static ItemStack changeMode(ItemStack stack, EntityPlayer player, boolean hasOblit, int maxSize) {
        if (player.func_70093_af()) {
            if (ItemNBTHelper.getShort(stack, "size", (short)0) < maxSize) {
                ItemNBTHelper.setShort(stack, "size", (short)(ItemNBTHelper.getShort(stack, "size", (short)0) + 1));
            } else {
                ItemNBTHelper.setShort(stack, "size", (short)0);
            }
            if (!player.field_70170_p.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.size" + ItemNBTHelper.getShort(stack, "size", (short)0) + ".txt", new Object[0]));
            }
        } else {
            ToolHandler.updateGhostBlocks(player, player.field_70170_p);
            if (hasOblit) {
                ItemNBTHelper.setBoolean(stack, "obliterate", !ItemNBTHelper.getBoolean(stack, "obliterate", false));
                if (player.field_70170_p.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.oblit" + ItemNBTHelper.getBoolean(stack, "obliterate", false) + ".txt", new Object[0]));
                }
            }
        }
        return stack;
    }

    public static void damageEntityBasedOnHealth(Entity entity, EntityPlayer player, float dmg) {
        World world = player.field_70170_p;
        ItemStack stack = player.func_71045_bC();
        if (entity instanceof EntityLivingBase) {
            float entHealth = ((EntityLivingBase)entity).func_110143_aJ();
            if (!world.field_72995_K && entHealth > 20.0f) {
                if (stack == null || !(stack.func_77973_b() instanceof IEnergyContainerItem) || ((IEnergyContainerItem)stack.func_77973_b()).getEnergyStored(stack) < 450) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        return;
                    }
                } else if (!player.field_71075_bZ.field_75098_d) {
                    ((IEnergyContainerItem)stack.func_77973_b()).extractEnergy(stack, 1000 + (int)(entHealth * 100.0f), false);
                }
                entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), entHealth * dmg);
            }
        } else if (entity instanceof EntityDragonPart) {
            if (!world.field_72995_K) {
                if (stack == null || !(stack.func_77973_b() instanceof IEnergyContainerItem) || ((IEnergyContainerItem)stack.func_77973_b()).getEnergyStored(stack) < 450) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        return;
                    }
                } else if (!player.field_71075_bZ.field_75098_d) {
                    ((IEnergyContainerItem)stack.func_77973_b()).extractEnergy(stack, 21000, false);
                }
                entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 200.0f * dmg);
            }
        } else if (!world.field_72995_K) {
            if (stack == null || !(stack.func_77973_b() instanceof IEnergyContainerItem) || ((IEnergyContainerItem)stack.func_77973_b()).getEnergyStored(stack) < 450) {
                if (!player.field_71075_bZ.field_75098_d) {
                    return;
                }
            } else if (!player.field_71075_bZ.field_75098_d) {
                ((IEnergyContainerItem)stack.func_77973_b()).extractEnergy(stack, 11000, false);
            }
            entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 100.0f * dmg);
        }
    }

    public static void AOEAttack(EntityPlayer player, Entity entity, ItemStack stack, int dmg, int range) {
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
        int sharp = 0;
        if (enchants.get(16) != null) {
            sharp = (Integer)enchants.get(16);
        }
        World world = player.field_70170_p;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(entity.field_70165_t - (double)range), (double)(entity.field_70163_u - (double)range), (double)(entity.field_70161_v - (double)range), (double)(entity.field_70165_t + (double)range), (double)(entity.field_70163_u + (double)range), (double)(entity.field_70161_v + (double)range)).func_72314_b(1.0, 1.0, 1.0);
        List list = world.func_72839_b((Entity)player, box);
        for (Object o : list) {
            if (stack == null || !(stack.func_77973_b() instanceof IEnergyContainerItem) || ((IEnergyContainerItem)stack.func_77973_b()).getEnergyStored(stack) < 450) {
                if (!player.field_71075_bZ.field_75098_d) {
                    return;
                }
            } else if (!player.field_71075_bZ.field_75098_d) {
                ((IEnergyContainerItem)stack.func_77973_b()).extractEnergy(stack, 1000, false);
            }
            if (!((Entity)o instanceof EntityLivingBase)) continue;
            ((Entity)o).func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)(dmg + sharp));
        }
    }

    public static MovingObjectPosition raytraceFromEntity(World world, Entity player, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            d1 += 1.62;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        if (player instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_72933_a(vec3, vec31);
    }

    private static void updateGhostBlocks(EntityPlayer player, World world) {
        int xPos = (int)player.field_70165_t;
        int yPos = (int)player.field_70163_u;
        int zPos = (int)player.field_70161_v;
        for (int x = xPos - 6; x < xPos + 6; ++x) {
            for (int y = yPos - 6; y < yPos + 6; ++y) {
                for (int z = zPos - 6; z < zPos + 6; ++z) {
                    world.func_147471_g(x, y, z);
                }
            }
        }
    }
}

