/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.tools;

import cofh.api.energy.IEnergyContainerItem;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.core.utills.EnergyHelper;
import com.brandon3055.draconicevolution.common.core.utills.ItemInfoHelper;
import com.brandon3055.draconicevolution.common.core.utills.ItemNBTHelper;
import com.brandon3055.draconicevolution.common.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.common.items.ModItems;
import com.brandon3055.draconicevolution.common.items.tools.ToolHandler;
import com.brandon3055.draconicevolution.common.lib.References;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class WyvernPickaxe
extends ItemPickaxe
implements IEnergyContainerItem {
    public IIcon itemIcon0;
    public IIcon itemIcon1;
    protected int capacity = 1000000;
    protected int maxReceive = 1000;
    protected int maxExtract = 1000;

    public WyvernPickaxe() {
        super(ModItems.DRACONIUM_T1);
        this.func_77655_b("wyvernPickaxe");
        this.func_77637_a(DraconicEvolution.tolkienTabToolsWeapons);
        GameRegistry.registerItem((Item)this, (String)"wyvernPickaxe");
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag(new ItemStack(item, 1, 0), 0));
        list.add(EnergyHelper.setDefaultEnergyTag(new ItemStack(item, 1, 0), this.capacity));
    }

    public String func_77658_a() {
        return String.format("item.%s%s", "DraconicEvolution".toLowerCase() + ":", super.func_77658_a().substring(super.func_77658_a().indexOf(".") + 1));
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.itemIcon0 = iconRegister.func_94245_a(References.RESOURCESPREFIX + "wyvern_pick");
        this.itemIcon1 = iconRegister.func_94245_a(References.RESOURCESPREFIX + "wyvern_pick_active");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (ItemNBTHelper.getShort(stack, "size", (short)0) > 0) {
            return this.itemIcon1;
        }
        return this.itemIcon0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        if (ItemNBTHelper.getShort(stack, "size", (short)0) > 0) {
            return this.itemIcon1;
        }
        return this.itemIcon0;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        Block block = world.func_147439_a(x, y, z);
        Material mat = block.func_149688_o();
        if (!ToolHandler.isRightMaterial(mat, ToolHandler.materialsPick)) {
            return false;
        }
        int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
        boolean silk = EnchantmentHelper.func_77502_d((EntityLivingBase)player);
        ToolHandler.disSquare(x, y, z, player, world, silk, fortune, ToolHandler.materialsPick, stack);
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        return ToolHandler.changeMode(stack, player, false, 1);
    }

    public static int getMode(ItemStack tool) {
        return tool.func_77960_j();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extraInformation) {
        int size = ItemNBTHelper.getShort(stack, "size", (short)0) * 2 + 1;
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.DARK_GREEN + "Hold shift for information");
            ItemInfoHelper.energyDisplayInfo(stack, list);
        } else {
            list.add(EnumChatFormatting.GREEN + "Mining Mode: " + EnumChatFormatting.BLUE + size + "x" + size);
            list.add(EnumChatFormatting.GREEN + "Shift Right-click to change mode");
            list.add("");
            list.add(EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + "Weary of plain tools you begin to understand");
            list.add(EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + "ways to use Draconic energy to upgrade");
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    public static void registerRecipe() {
        CraftingManager.func_77594_a().func_92103_a(new ItemStack(ModItems.wyvernPickaxe), new Object[]{" C ", "CPC", " C ", Character.valueOf('C'), ModItems.infusedCompound, Character.valueOf('P'), Items.field_151046_w});
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) != this.getMaxEnergyStored(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (stack.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)stack.func_77973_b()).getEnergyStored(stack) >= 450) {
            return super.getDigSpeed(stack, block, meta);
        }
        return 1.0f;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }
}

