/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class CustomSpawnerBaseLogic {
    public int spawnDelay = 20;
    public String entityName = "";
    public double renderRotation0;
    public double renderRotation1;
    private int minSpawnDelay = 400;
    private int maxSpawnDelay = 600;
    private int spawnCount = 4;
    private Entity renderedEntity;
    private int maxNearbyEntities = 20;
    public boolean powered = false;
    public boolean requiresPlayer = true;
    public boolean ignoreSpawnRequirements = false;
    public int spawnSpeed = 0;
    private int activatingRangeFromPlayer = 24;
    private int spawnRange = 4;

    public String getEntityNameToSpawn() {
        return this.entityName;
    }

    public void setEntityName(String name) {
        this.entityName = name;
    }

    public boolean isActivated() {
        if (!this.requiresPlayer) {
            return true;
        }
        return this.getSpawnerWorld().func_72977_a((double)this.getSpawnerX() + 0.5, (double)this.getSpawnerY() + 0.5, (double)this.getSpawnerZ() + 0.5, (double)this.activatingRangeFromPlayer) != null;
    }

    public void updateSpawner() {
        if (this.isActivated() && !this.powered) {
            if (this.getSpawnerWorld().field_72995_K) {
                double d0 = (float)this.getSpawnerX() + this.getSpawnerWorld().field_73012_v.nextFloat();
                double d1 = (float)this.getSpawnerY() + this.getSpawnerWorld().field_73012_v.nextFloat();
                double d2 = (float)this.getSpawnerZ() + this.getSpawnerWorld().field_73012_v.nextFloat();
                this.getSpawnerWorld().func_72869_a("smoke", d0, d1, d2, 0.0, 0.0, 0.0);
                this.getSpawnerWorld().func_72869_a("flame", d0, d1, d2, 0.0, 0.0, 0.0);
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                }
                this.renderRotation1 = this.renderRotation0;
                this.renderRotation0 = (this.renderRotation0 + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
            } else {
                if (this.spawnDelay == -1) {
                    this.resetTimer();
                }
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                    return;
                }
                boolean flag = false;
                for (int i = 0; i < this.spawnCount; ++i) {
                    Entity entity = EntityList.func_75620_a((String)this.getEntityNameToSpawn(), (World)this.getSpawnerWorld());
                    if (entity == null) {
                        return;
                    }
                    int j = this.getSpawnerWorld().func_72872_a(entity.getClass(), AxisAlignedBB.func_72330_a((double)this.getSpawnerX(), (double)this.getSpawnerY(), (double)this.getSpawnerZ(), (double)(this.getSpawnerX() + 1), (double)(this.getSpawnerY() + 1), (double)(this.getSpawnerZ() + 1)).func_72314_b((double)(this.spawnRange * 2), 4.0, (double)(this.spawnRange * 2))).size();
                    if (j >= this.maxNearbyEntities) {
                        this.resetTimer();
                        return;
                    }
                    int x = this.getSpawnerX() + (int)((this.getSpawnerWorld().field_73012_v.nextDouble() - this.getSpawnerWorld().field_73012_v.nextDouble()) * (double)this.spawnRange);
                    int y = this.getSpawnerY() + this.getSpawnerWorld().field_73012_v.nextInt(3) - 1;
                    int z = this.getSpawnerZ() + (int)((this.getSpawnerWorld().field_73012_v.nextDouble() - this.getSpawnerWorld().field_73012_v.nextDouble()) * (double)this.spawnRange);
                    EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                    entity.func_70012_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.getSpawnerWorld().field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (entityliving == null || entityliving.func_70601_bi() || this.ignoreSpawnRequirements && this.getSpawnerWorld().func_147439_a(x, y, z) == Blocks.field_150350_a) {
                        this.spawnEntity(entity);
                        this.getSpawnerWorld().func_72926_e(2004, this.getSpawnerX(), this.getSpawnerY(), this.getSpawnerZ(), 0);
                        if (entityliving != null) {
                            entityliving.func_70656_aK();
                        }
                        flag = true;
                        if (this.spawnCount <= 4) continue;
                        --this.spawnCount;
                        continue;
                    }
                    if (this.spawnCount >= 10) continue;
                    ++this.spawnCount;
                }
                if (flag) {
                    this.resetTimer();
                }
            }
        }
    }

    public Entity spawnEntity(Entity par1Entity) {
        if (par1Entity instanceof EntityLivingBase && par1Entity.field_70170_p != null) {
            ((EntityLiving)par1Entity).func_110161_a((IEntityLivingData)null);
            this.getSpawnerWorld().func_72838_d(par1Entity);
        }
        return par1Entity;
    }

    private void resetTimer() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.getSpawnerWorld().field_73012_v.nextInt(i);
        }
        this.blockEvent(1);
    }

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.entityName = par1NBTTagCompound.func_74779_i("EntityId");
        this.spawnDelay = par1NBTTagCompound.func_74765_d("Delay");
        this.powered = par1NBTTagCompound.func_74767_n("Powered");
        this.spawnSpeed = par1NBTTagCompound.func_74765_d("Speed");
        this.requiresPlayer = par1NBTTagCompound.func_74767_n("RequiresPlayer");
        this.ignoreSpawnRequirements = par1NBTTagCompound.func_74767_n("IgnoreSpawnRequirements");
        if (par1NBTTagCompound.func_150297_b("MinSpawnDelay", 99)) {
            this.minSpawnDelay = par1NBTTagCompound.func_74765_d("MinSpawnDelay");
            this.maxSpawnDelay = par1NBTTagCompound.func_74765_d("MaxSpawnDelay");
            this.spawnCount = par1NBTTagCompound.func_74765_d("SpawnCount");
        }
        if (par1NBTTagCompound.func_150297_b("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = par1NBTTagCompound.func_74765_d("MaxNearbyEntities");
            this.activatingRangeFromPlayer = par1NBTTagCompound.func_74765_d("RequiredPlayerRange");
        }
        if (par1NBTTagCompound.func_150297_b("SpawnRange", 99)) {
            this.spawnRange = par1NBTTagCompound.func_74765_d("SpawnRange");
        }
        if (this.getSpawnerWorld() != null && this.getSpawnerWorld().field_72995_K) {
            this.renderedEntity = null;
        }
    }

    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74778_a("EntityId", this.getEntityNameToSpawn());
        par1NBTTagCompound.func_74777_a("Delay", (short)this.spawnDelay);
        par1NBTTagCompound.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
        par1NBTTagCompound.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
        par1NBTTagCompound.func_74777_a("SpawnCount", (short)this.spawnCount);
        par1NBTTagCompound.func_74777_a("MaxNearbyEntities", (short)this.maxNearbyEntities);
        par1NBTTagCompound.func_74777_a("RequiredPlayerRange", (short)this.activatingRangeFromPlayer);
        par1NBTTagCompound.func_74777_a("SpawnRange", (short)this.spawnRange);
        par1NBTTagCompound.func_74757_a("Powered", this.powered);
        par1NBTTagCompound.func_74777_a("Speed", (short)this.spawnSpeed);
        par1NBTTagCompound.func_74757_a("RequiresPlayer", this.requiresPlayer);
        par1NBTTagCompound.func_74757_a("IgnoreSpawnRequirements", this.ignoreSpawnRequirements);
    }

    public boolean setDelayToMin(int par1) {
        if (par1 == 1 && this.getSpawnerWorld().field_72995_K) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getEntityForRenderer() {
        if (this.renderedEntity == null) {
            Entity entity = EntityList.func_75620_a((String)this.getEntityNameToSpawn(), (World)null);
            this.renderedEntity = entity = this.spawnEntity(entity);
        }
        return this.renderedEntity;
    }

    public abstract void blockEvent(int var1);

    public abstract World getSpawnerWorld();

    public abstract int getSpawnerX();

    public abstract int getSpawnerY();

    public abstract int getSpawnerZ();

    public void setSpawnRate(int i) {
        this.spawnSpeed = i;
        this.minSpawnDelay = 400 - i * 150;
        this.maxSpawnDelay = 600 - i * 200;
        if (i == 3) {
            this.minSpawnDelay = 40;
            this.maxSpawnDelay = 40;
        }
        if (this.minSpawnDelay < 0) {
            this.minSpawnDelay = 0;
        }
        if (this.maxSpawnDelay < 1) {
            this.maxSpawnDelay = 1;
        }
        this.resetTimer();
    }
}

