/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities;

import cofh.api.energy.IEnergyHandler;
import com.brandon3055.draconicevolution.common.core.utills.EnergyStorage;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileGenerator
extends TileEntity
implements ISidedInventory,
IEnergyHandler {
    private ItemStack[] items;
    public int burnTime = 1;
    public int burnTimeRemaining = 0;
    private int burnSpeed = 6;
    private int EPBT = 14;
    protected EnergyStorage storage = new EnergyStorage(100000, 0, 1000);

    public TileGenerator() {
        this.items = new ItemStack[1];
    }

    public void func_145845_h() {
        if (this.burnTimeRemaining > 0 && this.storage.getEnergyStored() < this.storage.getMaxEnergyStored()) {
            this.burnTimeRemaining -= this.burnSpeed;
            this.storage.setEnergyStored(this.storage.getEnergyStored() + Math.min(this.burnSpeed * this.EPBT, this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()));
        } else if (this.burnTimeRemaining <= 0) {
            this.tryRefuel();
        }
        if (this.storage.getEnergyStored() > 0) {
            for (int i = 0; i < 6; ++i) {
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + ForgeDirection.getOrientation((int)i).offsetX, this.field_145848_d + ForgeDirection.getOrientation((int)i).offsetY, this.field_145849_e + ForgeDirection.getOrientation((int)i).offsetZ);
                if (tile == null || !(tile instanceof IEnergyHandler)) continue;
                this.storage.extractEnergy(((IEnergyHandler)tile).receiveEnergy(ForgeDirection.getOrientation((int)i).getOpposite(), this.storage.extractEnergy(this.storage.getMaxExtract(), true), false), false);
            }
        }
    }

    public void tryRefuel() {
        int itemBurnTime;
        if (this.burnTimeRemaining > 0 || this.storage.getEnergyStored() >= this.storage.getMaxEnergyStored()) {
            return;
        }
        if (this.items[0] != null && this.items[0].field_77994_a > 0 && (itemBurnTime = TileGenerator.getItemBurnTime(this.items[0])) > 0) {
            this.func_70298_a(0, 1);
            this.burnTime = itemBurnTime;
            this.burnTimeRemaining = itemBurnTime;
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.items[i];
    }

    public ItemStack func_70298_a(int i, int count) {
        ItemStack itemstack = this.func_70301_a(i);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= count) {
                this.func_70299_a(i, null);
            } else {
                itemstack = itemstack.func_77979_a(count);
                if (itemstack.field_77994_a == 0) {
                    this.func_70299_a(i, null);
                }
            }
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack item = this.func_70301_a(i);
        if (item != null) {
            this.func_70299_a(i, null);
        }
        return item;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.items[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.4) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return TileGenerator.getItemBurnTime(stack) > 0;
    }

    public int[] func_94128_d(int var1) {
        return new int[1];
    }

    public boolean func_102007_a(int var1, ItemStack var2, int var3) {
        return true;
    }

    public boolean func_102008_b(int var1, ItemStack var2, int var3) {
        return false;
    }

    public void func_145841_b(NBTTagCompound compound) {
        NBTTagCompound[] tag = new NBTTagCompound[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            tag[i] = new NBTTagCompound();
            if (this.items[i] != null) {
                tag[i] = this.items[i].func_77955_b(tag[i]);
            }
            compound.func_74782_a("Item" + i, (NBTBase)tag[i]);
        }
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("BurnTimeRemaining", this.burnTimeRemaining);
        this.storage.writeToNBT(compound);
        super.func_145841_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        NBTTagCompound[] tag = new NBTTagCompound[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            tag[i] = compound.func_74775_l("Item" + i);
            this.items[i] = ItemStack.func_77949_a((NBTTagCompound)tag[i]);
        }
        this.burnTime = compound.func_74762_e("BurnTime");
        this.burnTimeRemaining = compound.func_74762_e("BurnTimeRemaining");
        this.storage.readFromNBT(compound);
        super.func_145839_a(compound);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }
}

